/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.xsltextn;

import com.saxonica.expr.NextIteration;
import com.saxonica.xsltextn.XSLBreakOrContinue;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.LocalParam;
import net.sf.saxon.expr.instruct.WithParam;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.XSLParam;
import net.sf.saxon.style.XSLWithParam;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;

public class XSLNextIteration
extends XSLBreakOrContinue {
    protected ItemType getReturnedItemType() {
        return AnyItemType.getInstance();
    }

    public void validate(Declaration decl) throws XPathException {
        NodeInfo child;
        this.validatePosition();
        if (this.xslIterate == null) {
            this.compileError("xsl:next-iteration must be a descendant of an xsl:iterate instruction");
        }
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = (NodeInfo)kids.next()) != null) {
            if (child instanceof XSLWithParam) {
                if (!((XSLWithParam)child).isTunnelParam()) continue;
                this.compileError("An xsl:with-param element within xsl:iterate must not specify tunnel='yes'", "XTSE0020");
                continue;
            }
            if (child.getNodeKind() == 3) {
                if (Whitespace.isWhite(child.getStringValueCS())) continue;
                this.compileError("No character data is allowed within xsl:next-iteration", "XTSE0010");
                continue;
            }
            this.compileError("Child element " + Err.wrap(child.getDisplayName(), 1) + " is not allowed as a child of xsl:next-iteration", "XTSE0010");
        }
    }

    public void postValidate() throws XPathException {
        NodeInfo w;
        if (this.xslIterate == null) {
            return;
        }
        AxisIterator actualParams = this.iterateAxis((byte)3);
        while ((w = (NodeInfo)actualParams.next()) != null) {
            NodeInfo param;
            if (!(w instanceof XSLWithParam)) continue;
            XSLWithParam withParam = (XSLWithParam)w;
            AxisIterator formalParams = this.xslIterate.iterateAxis((byte)3);
            boolean ok = false;
            while ((param = (NodeInfo)formalParams.next()) != null) {
                if (!(param instanceof XSLParam) || !((XSLParam)param).getVariableQName().equals(withParam.getVariableQName())) continue;
                ok = true;
                SequenceType required = ((XSLParam)param).getRequiredType();
                withParam.checkAgainstRequiredType(required);
                break;
            }
            if (ok || this.xPath10ModeIsEnabled()) continue;
            this.compileError("Parameter " + withParam.getVariableDisplayName() + " is not declared in the containing xsl:iterate instruction", "XTSE0680");
        }
    }

    public Expression compile(Executable exec, Declaration decl) throws XPathException {
        NextIteration call = new NextIteration();
        WithParam[] actualParams = this.getWithParamInstructions(exec, decl, false, call);
        if (this.xslIterate != null) {
            NodeInfo param;
            PrincipalStylesheetModule psm = this.getPrincipalStylesheetModule();
            AxisIterator declaredParams = this.xslIterate.iterateAxis((byte)3);
            while ((param = (NodeInfo)declaredParams.next()) != null) {
                if (!(param instanceof XSLParam)) continue;
                XSLParam pdecl = (XSLParam)param;
                StructuredQName paramName = pdecl.getVariableQName();
                LocalParam lp = (LocalParam)pdecl.getCompiledVariable();
                boolean found = false;
                for (int i = 0; i < actualParams.length; ++i) {
                    if (!paramName.equals(actualParams[i].getVariableQName())) continue;
                    actualParams[i].setSlotNumber(lp.getSlotNumber());
                    found = true;
                    break;
                }
                if (found) continue;
                WithParam wp = new WithParam();
                wp.setVariableQName(paramName);
                VariableReference ref = new VariableReference(lp);
                wp.setSelectExpression(ref);
                wp.setParameterId(psm.allocateUniqueParameterNumber(paramName));
                wp.setSlotNumber(lp.getSlotNumber());
                ref.setStaticType(pdecl.getRequiredType(), null, 0);
                WithParam[] p2 = new WithParam[actualParams.length + 1];
                p2[0] = wp;
                System.arraycopy(actualParams, 0, p2, 1, actualParams.length);
                actualParams = p2;
            }
        }
        call.setParameters(actualParams);
        return call;
    }
}

