/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.validate;

import com.saxonica.schema.Assertion;
import com.saxonica.schema.ElementDecl;
import com.saxonica.schema.UserComplexType;
import com.saxonica.validate.AnyTypeValidator;
import com.saxonica.validate.AttributeValidator;
import com.saxonica.validate.ComplexContentValidator;
import com.saxonica.validate.ConstraintChecker;
import com.saxonica.validate.ContentValidator;
import com.saxonica.validate.EmptyContentValidator;
import com.saxonica.validate.LaxValidator;
import com.saxonica.validate.SimpleContentValidator;
import com.saxonica.validate.SkipValidator;
import com.saxonica.validate.StartTagBufferEE;
import com.saxonica.validate.ValidatingFilter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.Controller;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.InscopeNamespaceResolver;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.tree.wrapper.VirtualCopy;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Whitespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationStack
extends ValidatingFilter {
    private Stack stack = new Stack();
    private boolean contentStarted = false;
    private Receiver outputReceiver;
    private ContentValidator initialValidator;
    private SchemaType xsiType;
    private ConstraintChecker constraintChecker;
    private StartTagBufferEE startTagBuffer;
    private List xsiValidationErrors;
    private int initialValidationMode;
    private SchemaType initialType;
    private boolean isNilled = false;
    private int topLevelElement = -1;
    private TinyBuilder builder;
    private int builderDepth;
    private Map<SchemaComponent, Integer> statistics;

    public ValidationStack(Receiver out, int initialValidationMode, SchemaType initialType) {
        this.outputReceiver = out;
        this.setUnderlyingReceiver(out);
        this.initialValidationMode = initialValidationMode;
        this.initialType = initialType;
        this.setPipelineConfiguration(out.getPipelineConfiguration());
    }

    @Override
    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        super.setPipelineConfiguration(pipe);
        if (pipe.getController() == null) {
            pipe.setController(new Controller(pipe.getConfiguration()));
        }
        if (pipe.getParseOptions().getValidationStatisticsRecipient() != null) {
            this.setKeepStatistics(true);
        }
    }

    public void setTopLevelElement(int nameCode) {
        this.topLevelElement = nameCode;
    }

    public int getTopLevelElement() {
        return this.topLevelElement;
    }

    public void setConstraintChecker(ConstraintChecker checker) {
        this.constraintChecker = checker;
    }

    public void setXSIType(SchemaType type) {
        this.xsiType = type;
    }

    public void setIsNilled(boolean nilled) {
        this.isNilled = nilled;
    }

    public void setStartTagBuffer(StartTagBufferEE resolver) {
        this.startTagBuffer = resolver;
    }

    public void setXsiValidationErrors(List errors) {
        this.xsiValidationErrors = errors;
    }

    @Override
    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        if (this.isNilled) {
            properties |= 0x10;
        }
        try {
            if (this.stack.isEmpty()) {
                SchemaType type;
                ContentValidator initial;
                if (this.initialValidator != null && this.xsiType == null) {
                    initial = this.initialValidator;
                } else {
                    ElementDecl decl;
                    if (this.topLevelElement != -1 && (this.topLevelElement & 0xFFFFF) != (nameCode & 0xFFFFF)) {
                        String actual;
                        String required = Err.wrap(this.getNamePool().getDisplayName(this.topLevelElement), 1);
                        if (required.equals(actual = Err.wrap(this.getNamePool().getDisplayName(nameCode), 1))) {
                            required = this.getNamePool().getClarkName(this.topLevelElement);
                            actual = this.getNamePool().getClarkName(nameCode);
                        }
                        ValidationException ve = new ValidationException("Top-level element name is " + actual + ", required name is " + required);
                        this.reportValidationError(ve, false, locationId, 1);
                    }
                    Receiver initialReceiver = this.getUnderlyingReceiver();
                    if (this.xsiType != null) {
                        SchemaType type2;
                        if (initialReceiver instanceof EmptyContentValidator || initialReceiver instanceof AnyTypeValidator || initialReceiver instanceof LaxValidator) {
                            initial = ContentValidator.makeValidatorForType(null, this.xsiType, this.getPipelineConfiguration(), this.outputReceiver);
                        } else if (initialReceiver instanceof SimpleContentValidator) {
                            type2 = ((SimpleContentValidator)initialReceiver).getSchemaType();
                            try {
                                this.getConfiguration().checkTypeDerivationIsOK(this.xsiType, type2, 0);
                            }
                            catch (SchemaException e) {
                                throw new XPathException(e);
                            }
                            ((SimpleContentValidator)initialReceiver).setSchemaType(this.xsiType);
                            initial = (ContentValidator)this.getUnderlyingReceiver();
                        } else if (initialReceiver instanceof ComplexContentValidator) {
                            type2 = ((ComplexContentValidator)initialReceiver).getSchemaType();
                            try {
                                this.getConfiguration().checkTypeDerivationIsOK(this.xsiType, type2, 0);
                            }
                            catch (SchemaException e) {
                                throw new XPathException(e);
                            }
                            ((ComplexContentValidator)initialReceiver).setSchemaType((UserComplexType)this.xsiType);
                            initial = (ContentValidator)this.getUnderlyingReceiver();
                        } else {
                            decl = (ElementDecl)this.getConfiguration().getElementDeclaration(nameCode & 0xFFFFF);
                            initial = ContentValidator.makeValidator(decl, nameCode, locationId, this.startTagBuffer, this.xsiType, this.initialValidationMode, this.getPipelineConfiguration(), this.outputReceiver);
                        }
                    } else if (initialReceiver instanceof ContentValidator) {
                        initial = (ContentValidator)this.getUnderlyingReceiver();
                    } else if (this.initialType != null) {
                        initial = ContentValidator.makeValidatorForType(null, this.initialType, this.getPipelineConfiguration(), this.outputReceiver);
                    } else {
                        decl = (ElementDecl)this.getConfiguration().getElementDeclaration(nameCode & 0xFFFFF);
                        initial = ContentValidator.makeValidator(decl, nameCode, locationId, this.startTagBuffer, this.xsiType, this.initialValidationMode, this.getPipelineConfiguration(), this.outputReceiver);
                    }
                    initial.setStartTagBuffer(this.startTagBuffer);
                    initial.setErrorCode(this.getErrorCode());
                }
                int annotation = initial.getAnnotation();
                if (this.isNilled) {
                    annotation |= 0x20000000;
                }
                if (!(initial instanceof SkipValidator) && !this.xsiValidationErrors.isEmpty()) {
                    for (int i = 0; i < this.xsiValidationErrors.size(); ++i) {
                        ValidationException err = (ValidationException)this.xsiValidationErrors.get(i);
                        this.reportValidationError(err, false, locationId, 1);
                    }
                }
                if ((type = initial.getSchemaType()) instanceof UserComplexType && ((UserComplexType)type).hasAssertions()) {
                    this.builder = new TinyBuilder();
                    this.builder.setPipelineConfiguration(this.getPipelineConfiguration());
                    this.builder.setLineNumbering(true);
                    this.builder.open();
                    this.builderDepth = 0;
                }
                if (this.constraintChecker != null) {
                    ElementDecl element = initial.getElementDeclaration();
                    if (element != null) {
                        this.constraintChecker.setElementDeclaration(element);
                    }
                    this.constraintChecker.startElement(nameCode, annotation, locationId, properties);
                } else {
                    this.outputReceiver.startElement(nameCode, annotation, locationId, properties);
                }
                this.stack.push(initial);
            } else {
                SchemaType type;
                if (!this.contentStarted) {
                    this.startContent();
                }
                ContentValidator v0 = (ContentValidator)this.stack.peek();
                v0.setXSIType(this.xsiType);
                v0.setStartTagBuffer(this.startTagBuffer);
                v0.startElement(nameCode, typeCode, locationId, properties);
                ContentValidator v1 = v0.getChildValidator();
                v1.setStartTagBuffer(this.startTagBuffer);
                v1.setUnderlyingReceiver(this.outputReceiver);
                v1.setPipelineConfiguration(this.getPipelineConfiguration());
                v1.setErrorCode(this.getErrorCode());
                if (this.statistics != null) {
                    this.incrementStatistics(v1.getElementDeclaration());
                    this.incrementStatistics(v1.getSchemaType());
                }
                this.setUnderlyingReceiver(v1);
                this.stack.push(v1);
                this.contentStarted = false;
                if (!(v1 instanceof SkipValidator) && !this.xsiValidationErrors.isEmpty()) {
                    for (int i = 0; i < this.xsiValidationErrors.size(); ++i) {
                        ValidationException err = (ValidationException)this.xsiValidationErrors.get(i);
                        this.reportValidationError(err, false, locationId, 1);
                    }
                }
                if (this.builder == null && (type = v1.getSchemaType()) instanceof UserComplexType && ((UserComplexType)type).hasAssertions()) {
                    this.builder = new TinyBuilder();
                    this.builder.setPipelineConfiguration(this.getPipelineConfiguration());
                    this.builder.open();
                    this.builderDepth = 0;
                }
            }
            this.xsiType = null;
            if (this.builder != null) {
                this.builder.startElement(nameCode, typeCode, locationId, properties);
                ++this.builderDepth;
            }
        }
        catch (ValidationException ve) {
            if (!ve.hasBeenReported()) {
                this.reportValidationError(ve, true, locationId, 1);
                ve.setHasBeenReported(true);
            }
            throw ve;
        }
    }

    public void setInitialValidator(ContentValidator validator) {
        this.initialValidator = validator;
    }

    @Override
    public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        SimpleType type;
        ContentValidator v0 = (ContentValidator)this.stack.peek();
        v0.setStartTagBuffer(this.startTagBuffer);
        v0.attribute(nameCode, typeCode, value, locationId, properties);
        if (this.builder != null) {
            this.builder.attribute(nameCode, typeCode, value, locationId, properties);
        }
        if (this.statistics != null && v0 instanceof AttributeValidator && (type = ((AttributeValidator)v0).getMostRecentAttributeType()) != null) {
            this.incrementStatistics(type);
        }
    }

    @Override
    public final void startContent() throws XPathException {
        this.contentStarted = true;
        ContentValidator v0 = (ContentValidator)this.stack.peek();
        v0.startContent();
        if (this.builder != null) {
            this.builder.startContent();
        }
    }

    @Override
    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        if (!this.contentStarted) {
            this.startContent();
        }
        ContentValidator v0 = (ContentValidator)this.stack.peek();
        v0.characters(chars, locationId, properties);
        if (this.builder != null) {
            this.builder.characters(chars, locationId, properties);
        }
    }

    @Override
    public void endElement() throws XPathException {
        if (!this.contentStarted) {
            this.startContent();
        }
        ContentValidator v0 = (ContentValidator)this.stack.pop();
        v0.endElement();
        if (v0.isInvalid()) {
            this.setInvalidity(v0.getInvalidity());
        }
        if (this.builder != null) {
            this.builder.endElement();
            --this.builderDepth;
            SchemaType type = v0.getSchemaType();
            if (type instanceof UserComplexType && ((UserComplexType)type).hasAssertions()) {
                NodeInfo root = this.builder.getLastCompletedElement();
                if (this.builderDepth != 0) {
                    root = VirtualCopy.makeVirtualCopy(root, root);
                }
                this.testAssertions(root, (UserComplexType)type);
            }
            if (this.builderDepth == 0) {
                this.builder.close();
                this.builder = null;
            }
        }
        if (this.constraintChecker != null && this.constraintChecker.isInvalid()) {
            this.setInvalidity(1);
            StructuredQName qCode = this.constraintChecker.getErrorCode();
            if (qCode != null) {
                this.setErrorCode(qCode.getLocalName());
            }
        }
        if (!this.stack.isEmpty()) {
            this.setUnderlyingReceiver((ContentValidator)this.stack.peek());
        } else {
            this.setUnderlyingReceiver(this.outputReceiver);
            this.reportIfInvalid();
        }
    }

    @Override
    public void endDocument() throws XPathException {
        this.nextReceiver.endDocument();
        this.reportIfInvalid();
        if (this.statistics != null) {
            this.getPipelineConfiguration().getParseOptions().getValidationStatisticsRecipient().notifyValidationStatistics(this.statistics);
        }
    }

    public void testAssertions(NodeInfo root, UserComplexType type) throws XPathException {
        Set assertions = type.getAssertions();
        ValueRepresentation value = null;
        if (type.isSimpleContent()) {
            CharSequence s = root.getStringValueCS();
            SimpleType st = type.getSimpleContentType();
            InscopeNamespaceResolver ns = st.isNamespaceSensitive() ? new InscopeNamespaceResolver(root) : null;
            NameChecker nc = this.getConfiguration().getNameChecker();
            value = SequenceExtent.makeSequenceExtent(st.getTypedValue(s, ns, this.getConfiguration().getConversionRules()));
        }
        for (Assertion assertion : assertions) {
            List<Item> offendingItems = assertion.test(root, value, this.getPipelineConfiguration().getController());
            if (offendingItems == null) continue;
            String message = "Element " + root.getDisplayName() + " does not satisfy assertion";
            message = assertion.getMessage() != null ? message + ". " + assertion.getMessage() : message + " " + Whitespace.collapseWhitespace(assertion.getConditionText());
            if (offendingItems.isEmpty()) {
                ValidationException error = new ValidationException(message, (SourceLocator)((Object)root));
                this.reportValidationError(error, true, 0, 1);
                continue;
            }
            message = message + ". Offending items are: ";
            int limit = offendingItems.size();
            if (limit > 50) {
                limit = 50;
                message = message + "(1-50)";
            }
            for (int i = 0; i < limit; ++i) {
                Item item = offendingItems.get(i);
                message = item instanceof NodeInfo ? message + "\n    " + Navigator.getPath((NodeInfo)item) : message + "\n    " + item.getStringValue();
            }
            ValidationException error = new ValidationException(message, (SourceLocator)((Object)root));
            this.reportValidationError(error, true, 0, 1);
        }
    }

    private void incrementStatistics(SchemaComponent component) {
        Integer count = this.statistics.get(component);
        if (count == null) {
            this.statistics.put(component, 1);
        } else {
            this.statistics.put(component, count + 1);
        }
    }

    public void setKeepStatistics(boolean keep) {
        this.statistics = keep ? new HashMap<SchemaComponent, Integer>() : null;
    }

    public Map<SchemaComponent, Integer> getCoverageStatistics() {
        return this.statistics;
    }
}

