/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.validate;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.SaxonLocator;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ValidationException;

public class ValidatingFilter
extends ProxyReceiver {
    private int invalidity;
    private String errorCode;

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    protected String getErrorCode() {
        return this.errorCode;
    }

    protected void setInvalidity(int invalidity) {
        this.invalidity = invalidity;
    }

    protected int getInvalidity() {
        return this.invalidity;
    }

    protected boolean isInvalid() {
        return this.invalidity != 0;
    }

    public boolean usesTypeAnnotations() {
        return false;
    }

    protected void reportValidationError(ValidationException err, boolean issueComment, int locationId, int severity) throws XPathException {
        PipelineConfiguration pipe = this.getPipelineConfiguration();
        SaxonLocator locator = ExpressionLocation.getSourceLocator(locationId, pipe.getLocationProvider());
        err.setSourceLocator(locator);
        err.setErrorCode(this.errorCode);
        ErrorListener listener = pipe.getErrorListener();
        if (listener == null) {
            listener = pipe.getConfiguration().getErrorListener();
        }
        try {
            if (!pipe.getParseOptions().isContinueAfterValidationErrors()) {
                listener.fatalError(err);
                err.setHasBeenReported(true);
                throw err;
            }
            listener.error(err);
        }
        catch (TransformerException e) {
            err.setHasBeenReported(true);
            if (e instanceof ValidationException) {
                throw (ValidationException)e;
            }
            if (e.getException() instanceof ValidationException) {
                throw (ValidationException)e.getException();
            }
            throw new ValidationException(e);
        }
        this.setInvalidity(severity);
        if (issueComment && pipe.getParseOptions().isAddCommentsAfterValidationErrors()) {
            this.comment("\nVALIDATION ERROR: " + err.getMessage() + '\n', locationId, 0);
        }
    }

    protected void reportIfInvalid() throws ValidationException {
        if (this.isInvalid()) {
            ValidationException err = new ValidationException("One or more validation errors were reported");
            if (this.getErrorCode() != null) {
                err.setErrorCode(this.getErrorCode());
            } else {
                err.setErrorCode(this.getPipelineConfiguration().getHostLanguage() == 50 ? "XTTE1510" : "XQDY0027");
            }
            throw err;
        }
    }
}

