/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.validate;

import com.saxonica.validate.ContentValidator;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;

public class SkipValidator
extends ContentValidator {
    boolean stripIdProperty = false;
    TypeHierarchy typeHierarchy;

    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        super.setPipelineConfiguration(pipe);
        this.stripIdProperty = pipe.getHostLanguage() == 51;
        this.typeHierarchy = pipe.getConfiguration().getTypeHierarchy();
    }

    public SchemaType getSchemaType() {
        return null;
    }

    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        if (!this.stripIdProperty && typeCode != 630 && (properties & 0x2000) == 0) {
            if (this.typeHierarchy.isIdCode(typeCode)) {
                properties |= 0x800;
            } else if (this.typeHierarchy.isIdrefsCode(typeCode)) {
                properties |= 0x1000;
            }
            properties |= 0x2000;
        }
        super.startElement(nameCode, 630, locationId, properties);
    }

    protected ContentValidator getChildValidator() {
        return this;
    }

    public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        int newTypeCode = 631;
        if ((typeCode & 0x40000000) != 0) {
            newTypeCode = typeCode;
        }
        if (!this.stripIdProperty && typeCode != 631 && (properties & 0x2000) == 0) {
            if (this.typeHierarchy.isIdCode(typeCode)) {
                properties |= 0x800;
            } else if (this.typeHierarchy.isIdrefsCode(typeCode)) {
                properties |= 0x1000;
            }
            properties |= 0x2000;
        }
        this.nextReceiver.attribute(nameCode, newTypeCode, value, locationId, properties);
    }
}

