/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.validate;

import com.saxonica.schema.ElementDecl;
import com.saxonica.schema.UserComplexType;
import com.saxonica.validate.AnyTypeValidator;
import com.saxonica.validate.AttributeValidator;
import com.saxonica.validate.ContentValidator;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Value;

public class SimpleContentValidator
extends AttributeValidator {
    private SchemaType schemaType;
    private SimpleType simpleType;
    private Value fixedValue = null;
    private CharSequence fixedValueLexicalRepresentation = null;
    private Comparable fixedValueComparable = null;
    private String defaultValue = null;
    private boolean needToValidateConstraint = false;
    private FastStringBuffer buffer = new FastStringBuffer(64);

    public SimpleContentValidator(ElementDecl declaration, SchemaType type) throws ValidationException {
        this.setSchemaType(type);
        if (declaration != null) {
            this.defaultValue = declaration.getDefaultValue();
            this.fixedValue = declaration.getFixedValue();
            if (this.fixedValue != null) {
                this.fixedValueLexicalRepresentation = declaration.getFixedValueLexicalRepresentation();
                this.fixedValueComparable = declaration.getFixedValueComparable();
            }
            this.setNillability(declaration.isNillable() ? 1 : 2);
            this.needToValidateConstraint = type != declaration.getType();
        } else {
            this.needToValidateConstraint = false;
        }
    }

    public SchemaType getSchemaType() {
        return this.schemaType;
    }

    public void setSchemaType(SchemaType type) throws ValidationException {
        this.schemaType = type;
        if (type.isSimpleType()) {
            this.simpleType = (SimpleType)type;
        } else {
            UserComplexType ctype = (UserComplexType)type;
            this.simpleType = ctype.getSimpleContentType();
            this.setAttributeGroup(ctype.getCombinedAttributeGroup());
        }
        this.setAnnotation(this.simpleType.getFingerprint());
        this.needToValidateConstraint = true;
    }

    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        String message = "Invalid child element " + Err.wrap(this.getNamePool().getDisplayName(nameCode), 1) + ", " + this.getContainingElementName() + " must have simple content";
        ValidationException ve = new ValidationException(message);
        ve.setConstraintReference(1, "cvc-type", "3.1.2");
        this.reportValidationError(ve, true, locationId, 1);
        super.startElement(nameCode, 572, locationId, properties);
    }

    protected ContentValidator getChildValidator() {
        return new AnyTypeValidator();
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        this.buffer.append(chars);
        if (this.getNillability() == 1) {
            properties |= 0x200;
        }
        super.characters(chars, locationId, properties);
    }

    public void endElement() throws XPathException {
        if (this.isNil()) {
            if (this.fixedValue != null) {
                String message = "Element " + this.getContainingElementName() + " has a fixed value so it must not be nil";
                ValidationException ve = new ValidationException(message);
                ve.setConstraintReference(1, "cvc-elt", "3.2.1");
                this.reportValidationError(ve, true, this.getContainingElementLocationId(), 1);
                super.endElement();
                return;
            }
        } else if (this.defaultValue != null && this.buffer.length() == 0) {
            ValidationFailure err;
            if (this.needToValidateConstraint && (err = this.simpleType.validateContent(this.defaultValue, this.getNamespaceResolver(), this.getConfiguration().getConversionRules())) != null) {
                String message = "The default value " + Err.wrap(this.defaultValue, 4) + " for " + this.getContainingElementName() + " does not match the type " + this.simpleType.getDescription() + ": " + err.getMessage();
                ValidationException ve = new ValidationException(message);
                ve.setConstraintReference(2, "cvc-datatype-valid", "1");
                this.reportValidationError(ve, true, this.getContainingElementLocationId(), 1);
                super.endElement();
                return;
            }
            this.characters(this.defaultValue, 0, 0);
        } else if (this.fixedValue != null) {
            if (this.buffer.length() == 0) {
                ValidationFailure err;
                if (this.needToValidateConstraint && (err = this.simpleType.validateContent(this.fixedValueLexicalRepresentation, this.getNamespaceResolver(), this.getConfiguration().getConversionRules())) != null) {
                    String message = "The fixed value " + Err.wrap(this.fixedValueLexicalRepresentation, 4) + " for " + this.getContainingElementName() + " does not match the type " + this.simpleType.getDescription() + ": " + err.getMessage();
                    ValidationException ve = new ValidationException(message);
                    ve.setConstraintReference(2, "cvc-datatype-valid", "1");
                    this.reportValidationError(ve, true, this.getContainingElementLocationId(), 1);
                    super.endElement();
                    return;
                }
                this.characters(this.fixedValue.getCanonicalLexicalRepresentation(), 0, 0);
            } else {
                Value actual = (Value)SequenceExtent.makeSequenceExtent(this.simpleType.getTypedValue(this.buffer, this.getNamespaceResolver(), this.getConfiguration().getConversionRules()));
                if (!actual.getSchemaComparable().equals(this.fixedValueComparable)) {
                    String message = "The content " + Err.wrap(this.buffer, 4) + " of " + this.getContainingElementName() + " does not match the fixed value " + Err.wrap(this.fixedValueLexicalRepresentation, 4);
                    ValidationException ve = new ValidationException(message);
                    ve.setConstraintReference(1, "cvc-elt", "5.2.2.2");
                    this.reportValidationError(ve, true, this.getContainingElementLocationId(), 1);
                }
            }
        } else {
            ValidationFailure err = this.simpleType.validateContent(this.buffer, this.getNamespaceResolver(), this.getConfiguration().getConversionRules());
            if (err != null) {
                String message = "The content " + Err.wrap(this.buffer, 4) + " of " + this.getContainingElementName() + " does not match the required simple type. " + err.getMessage();
                ValidationException ve = new ValidationException(message);
                ve.setConstraintReference(2, "cvc-datatype-valid", "1");
                this.reportValidationError(ve, true, this.getContainingElementLocationId(), 1);
                super.endElement();
                return;
            }
        }
        super.endElement();
    }
}

