/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.validate;

import com.saxonica.schema.IdentityConstraint;
import com.saxonica.schema.IdentityField;
import com.saxonica.schema.Key;
import com.saxonica.schema.KeyRef;
import com.saxonica.schema.Unique;
import com.saxonica.stream.om.FleetingNode;
import com.saxonica.stream.watch.Watch;
import com.saxonica.validate.AbstractWatch;
import com.saxonica.validate.ConstraintChecker;
import com.saxonica.validate.FieldWatch;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SaxonLocator;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.Value;

public abstract class SelectorWatch
extends AbstractWatch
implements Watch {
    IdentityConstraint identityConstraint;
    ConstraintChecker constraintChecker;
    int numberOfColumns;
    Value[] currentRow;
    Stack<Value[]> activationStack = null;
    HashMap<String, List<ValueEntry>> table = new HashMap(100);

    public SelectorWatch(ConstraintChecker checker, IdentityConstraint uniqueConstraint) {
        this.identityConstraint = uniqueConstraint;
        this.constraintChecker = checker;
        this.setSelection(uniqueConstraint.getSelector().getSelection());
        this.numberOfColumns = uniqueConstraint.getFields().size();
    }

    public IdentityConstraint getIdentityConstraint() {
        return this.identityConstraint;
    }

    public Receiver startSelectedParentNode(FleetingNode node, int locationId) throws XPathException {
        if (this.currentRow != null) {
            if (this.activationStack == null) {
                this.activationStack = new Stack();
            }
            this.activationStack.push(this.currentRow);
        }
        this.currentRow = new Value[this.numberOfColumns];
        Iterator<IdentityField> fields = this.identityConstraint.iterateFields();
        int column = 0;
        ConstraintChecker fieldHandler = this.constraintChecker;
        while (fields.hasNext()) {
            IdentityField field = fields.next();
            Pattern fieldSelection = field.getSelection();
            FieldWatch fieldWatch = new FieldWatch(this, fieldSelection, this.currentRow, column++);
            fieldWatch.setAnchorNode(node);
            fieldWatch.setNamespaceResolver(this.getNamespaceResolver());
            fieldHandler.addWatch(fieldWatch);
        }
        return null;
    }

    public void endSelectedParentNode(int locationId) throws ValidationException {
        this.checkRow(this.currentRow, false, locationId);
        this.currentRow = this.activationStack != null && !this.activationStack.isEmpty() ? this.activationStack.pop() : null;
    }

    public void close() throws ValidationException {
    }

    public void addFieldValue(Value[] currentRow, int column, Value value, boolean nillableElement, long locationId) throws ValidationException {
        int hostLanguage;
        ValidationException ve;
        if (currentRow[column] != null) {
            ve = new ValidationException("Identity constraint " + Err.wrap(this.identityConstraint.getName()) + ": the " + this.identifyField(column) + " selects more than one node");
            hostLanguage = this.constraintChecker.getPipelineConfiguration().getHostLanguage();
            if (hostLanguage == 50) {
                ve.setErrorCode("XTTE1555");
            } else if (hostLanguage == 51) {
                ve.setErrorCode("XQDY0027");
            }
            ve.setConstraintReference(1, "cvc-identity-constraint", "3");
            this.reportValidationError(ve, locationId);
        }
        if (nillableElement && this.identityConstraint instanceof Key) {
            ve = new ValidationException("The element declaration of a field in an xs:key constraint must not be nillable");
            hostLanguage = this.constraintChecker.getPipelineConfiguration().getHostLanguage();
            if (hostLanguage == 50) {
                ve.setErrorCode("XTTE1555");
            } else if (hostLanguage == 51) {
                ve.setErrorCode("XQDY0027");
            }
            ve.setConstraintReference(1, "cvc-identity-constraint", "4.2.3");
            this.reportValidationError(ve, locationId);
        }
        currentRow[column] = value;
    }

    private String identifyField(int column) {
        if (this.numberOfColumns == 1) {
            return "field";
        }
        if (column == 0) {
            return "first field";
        }
        if (column == 1) {
            return "second field";
        }
        if (column == 2) {
            return "third field";
        }
        if (column < 20) {
            return column + 1 + "th field";
        }
        return "field " + (column + 1);
    }

    protected void checkRow(Value[] currentRow, boolean isTarget, int locationId) throws ValidationException {
        PipelineConfiguration pipe = this.getPipelineConfiguration();
        StringBuffer hash = new StringBuffer(100);
        for (int i = 0; i < this.numberOfColumns; ++i) {
            if (currentRow[i] == null) {
                if (isTarget) {
                    return;
                }
                if (this.identityConstraint instanceof Unique) {
                    return;
                }
                if (this.identityConstraint instanceof Key) {
                    ValidationException ve = new ValidationException("The " + this.identifyField(i) + " in constraint " + Err.wrap(this.identityConstraint.getName()) + " has no value");
                    int hostLanguage = this.constraintChecker.getPipelineConfiguration().getHostLanguage();
                    if (hostLanguage == 50) {
                        ve.setErrorCode("XTTE1555");
                    } else if (hostLanguage == 51) {
                        ve.setErrorCode("XQDY0027");
                    }
                    ve.setConstraintReference(1, "cvc-identity-constraint", "4.2.1");
                    this.reportValidationError(ve, locationId);
                    continue;
                }
                return;
            }
            hash.append(currentRow[i].getSchemaComparable().hashCode());
        }
        List<ValueEntry> existingValues = this.table.get(hash.toString());
        if (existingValues != null) {
            boolean foundEqual = false;
            for (ValueEntry entry : existingValues) {
                Value[] values = entry.values;
                boolean equal = true;
                for (int k = 0; k < currentRow.length; ++k) {
                    try {
                        if (currentRow[k].getSchemaComparable().equals(values[k].getSchemaComparable())) continue;
                        equal = false;
                    }
                    catch (ClassCastException err) {
                        equal = false;
                    }
                    catch (NullPointerException err) {
                        equal = false;
                    }
                    break;
                }
                if (!equal) continue;
                foundEqual = true;
                if (isTarget) {
                    int count = entry.flags >> 16;
                    entry.flags = ++count << 16 | entry.flags & 0xFFFF;
                    if (count <= 1 || (entry.flags & 1) == 0) continue;
                    ValidationException ve = new ValidationException("More than one referenced value found for keyRef " + Err.wrap(this.identityConstraint.getName()) + "\n    " + this.displayRow(currentRow));
                    int hostLanguage = this.constraintChecker.getPipelineConfiguration().getHostLanguage();
                    if (hostLanguage == 50) {
                        ve.setErrorCode("XTTE1555");
                    } else if (hostLanguage == 51) {
                        ve.setErrorCode("XQDY0027");
                    }
                    ve.setConstraintReference(1, "cvc-identity-constraint", "3");
                    this.reportValidationError(ve, locationId);
                    continue;
                }
                if (this.identityConstraint instanceof KeyRef) {
                    entry.flags |= 1;
                    if (entry.flags >> 16 > 1) {
                        ValidationException ve = new ValidationException("More than one referenced value found for keyRef " + Err.wrap(this.identityConstraint.getName()) + "\n    " + this.displayRow(currentRow));
                        int hostLanguage = this.constraintChecker.getPipelineConfiguration().getHostLanguage();
                        if (hostLanguage == 50) {
                            ve.setErrorCode("XTTE1555");
                        } else if (hostLanguage == 51) {
                            ve.setErrorCode("XQDY0027");
                        }
                        ve.setConstraintReference(1, "cvc-identity-constraint", "3");
                        this.reportValidationError(ve, locationId);
                    }
                    return;
                }
                ValidationException ve = new ValidationException("Non-unique value found for constraint " + this.identityConstraint.getName() + ": " + this.displayRow(currentRow));
                int hostLanguage = this.constraintChecker.getPipelineConfiguration().getHostLanguage();
                if (hostLanguage == 50) {
                    ve.setErrorCode("XTTE1555");
                } else if (hostLanguage == 51) {
                    ve.setErrorCode("XQDY0027");
                }
                ve.setConstraintReference(1, "cvc-identity-constraint", this.identityConstraint instanceof Unique ? "4.1" : "4.2.2");
                this.reportValidationError(ve, locationId);
            }
            if (!foundEqual) {
                ValueEntry entry2 = new ValueEntry();
                entry2.systemId = pipe.getLocationProvider().getSystemId(locationId);
                entry2.lineNumber = pipe.getLocationProvider().getLineNumber(locationId);
                entry2.values = currentRow;
                entry2.flags = isTarget ? 0 : 1;
                existingValues.add(entry2);
            }
        } else {
            existingValues = new ArrayList<ValueEntry>(10);
            ValueEntry entry = new ValueEntry();
            entry.systemId = pipe.getLocationProvider().getSystemId(locationId);
            entry.lineNumber = pipe.getLocationProvider().getLineNumber(locationId);
            entry.values = currentRow;
            entry.flags = isTarget ? 65536 : 1;
            existingValues.add(entry);
            this.table.put(hash.toString(), existingValues);
        }
    }

    protected String displayRow(Value[] row) {
        if (this.numberOfColumns == 1) {
            return this.displayValue(row[0]);
        }
        StringBuffer sb = new StringBuffer(100);
        sb.append('(');
        for (int i = 0; i < this.numberOfColumns; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(this.displayValue(row[i]));
        }
        sb.append(')');
        return sb.toString();
    }

    private String displayValue(Value val) {
        if (val == null) {
            return "()";
        }
        return val.toString();
    }

    protected void reportValidationError(ValidationException err, long locationId) throws ValidationException {
        PipelineConfiguration pipe = this.getPipelineConfiguration();
        SaxonLocator locator = ExpressionLocation.getSourceLocator(locationId, pipe.getLocationProvider());
        this.reportValidationError(err, locator);
    }

    protected void reportValidationError(ValidationException err, SourceLocator locator) throws ValidationException {
        PipelineConfiguration pipe = this.getPipelineConfiguration();
        int language = pipe.getHostLanguage();
        StructuredQName errorCode = language == 50 ? new StructuredQName("err", "http://www.w3.org/2005/xqt-errors", "XTTE1555") : (language == 51 ? new StructuredQName("err", "http://www.w3.org/2005/xqt-errors", "XQDY0027") : new StructuredQName("err", "http://www.w3.org/2005/xqt-errors", "XSD99999"));
        this.constraintChecker.setErrorCode(errorCode);
        err.setSourceLocator(locator);
        ErrorListener listener = pipe.getErrorListener();
        if (listener == null) {
            listener = pipe.getConfiguration().getErrorListener();
        }
        try {
            listener.fatalError(err);
            err.setHasBeenReported(true);
        }
        catch (TransformerException e) {
            err.setHasBeenReported(true);
            if (e instanceof ValidationException) {
                throw (ValidationException)e;
            }
            if (e.getException() instanceof ValidationException) {
                throw (ValidationException)e.getException();
            }
            throw new ValidationException(e);
        }
    }

    static class ValueEntry {
        String systemId;
        int lineNumber;
        Value[] values;
        int flags;

        ValueEntry() {
        }
    }
}

