/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.validate;

import com.saxonica.schema.AttributeDecl;
import com.saxonica.validate.SchemaElementTest;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.sort.IntSet;
import net.sf.saxon.expr.sort.IntSingletonSet;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.SchemaNodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.type.SchemaComponentVisitor;
import net.sf.saxon.type.SchemaType;

public class SchemaAttributeTest
extends NodeTest
implements SchemaNodeTest {
    private Configuration config;
    private AttributeDecl declaration;

    public SchemaAttributeTest(AttributeDecl element) {
        this.config = element.getConfiguration();
        this.declaration = element;
    }

    public boolean matches(int nodeKind, int nameCode, int annotation) {
        if (nodeKind != 2) {
            return false;
        }
        return (nameCode & 0xFFFFF) == this.declaration.getFingerprint() && SchemaElementTest.matchesAnnotation(this.config, this.declaration.getType(), annotation);
    }

    public boolean matches(TinyTree tree, int nodeNr) {
        return tree.getNodeKind(nodeNr) == 2 && (tree.getNameCode(nodeNr) & 0xFFFFF) == this.declaration.getFingerprint() && SchemaElementTest.matchesAnnotation(this.config, this.declaration.getType(), tree.getTypeAnnotation(nodeNr));
    }

    public boolean matches(NodeInfo node) {
        return node.getNodeKind() == 2 && (node.getNameCode() & 0xFFFFF) == this.declaration.getFingerprint() && SchemaElementTest.matchesAnnotation(this.config, this.declaration.getType(), node.getTypeAnnotation());
    }

    public final double getDefaultPriority() {
        return 0.0;
    }

    public int getPrimitiveType() {
        return 2;
    }

    public int getNodeKindMask() {
        return 4;
    }

    public IntSet getRequiredNodeNames() {
        return new IntSingletonSet(this.declaration.getFingerprint());
    }

    public SchemaType getContentType() {
        return this.declaration.getType();
    }

    public void visitNamedSchemaComponents(SchemaComponentVisitor visitor) throws XPathException {
        visitor.visitSchemaComponent(this.declaration);
    }

    public String toString() {
        return "schema-attribute(" + this.declaration.getDisplayName() + ')';
    }

    public String toString(NamePool pool) {
        return this.toString();
    }

    public int hashCode() {
        return this.declaration.getFingerprint();
    }

    public boolean equals(Object other) {
        return other instanceof SchemaAttributeTest && ((SchemaAttributeTest)other).declaration == this.declaration;
    }
}

