/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.validate;

import com.saxonica.schema.KeyRef;
import com.saxonica.validate.ConstraintChecker;
import com.saxonica.validate.SelectorWatch;
import java.util.List;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.trans.Err;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.Value;

public class RefSelectorWatch
extends SelectorWatch {
    public RefSelectorWatch(ConstraintChecker checker, KeyRef constraint) {
        super(checker, constraint);
    }

    public void notifyActualKey(Value[] keyValue, int locationId) throws ValidationException {
        this.checkRow(keyValue, true, locationId);
    }

    public void close() throws ValidationException {
        int errorCount = 0;
        block0: for (List entryList : this.table.values()) {
            for (SelectorWatch.ValueEntry entry : entryList) {
                ExpressionLocation loc;
                ValidationException ve;
                if ((entry.flags & 1) == 0) continue;
                int count = entry.flags >> 16;
                if (count == 0) {
                    ve = new ValidationException("No referenced value found for keyRef " + Err.wrap(this.identityConstraint.getName()) + ": " + this.displayRow(entry.values));
                    ve.setConstraintReference(1, "cvc-identity-constraint", "4.3");
                    loc = new ExpressionLocation();
                    loc.setSystemId(entry.systemId);
                    loc.setLineNumber(entry.lineNumber);
                    this.reportValidationError(ve, loc);
                    if (errorCount++ <= 100) continue;
                    continue block0;
                }
                if (count <= 1) continue;
                ve = new ValidationException("More than one referenced value found for keyRef " + Err.wrap(this.identityConstraint.getName()) + ": " + this.displayRow(entry.values));
                loc = new ExpressionLocation();
                loc.setSystemId(entry.systemId);
                loc.setLineNumber(entry.lineNumber);
                this.reportValidationError(ve, loc);
                if (errorCount++ <= 100) continue;
                continue block0;
            }
        }
    }
}

