/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.validate;

import com.saxonica.schema.AttributeDecl;
import com.saxonica.schema.ElementDecl;
import com.saxonica.schema.UserAtomicType;
import com.saxonica.validate.ContentValidator;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.value.Whitespace;

public class LaxValidator
extends ContentValidator {
    ContentValidator childValidator;

    public SchemaType getSchemaType() {
        return null;
    }

    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        ElementDecl decl = (ElementDecl)this.getConfiguration().getElementDeclaration(nameCode & 0xFFFFF);
        try {
            this.childValidator = LaxValidator.makeValidator(decl, nameCode, locationId, this.getStartTagBuffer(), this.xsiType, 2, this.getPipelineConfiguration(), this.getUnderlyingReceiver());
        }
        catch (ValidationException e) {
            String message = e.getMessage();
            if (this.getContainingElement() != -1) {
                message = "In content of " + this.getContainingElementName() + ": " + message;
            }
            ValidationException ve = new ValidationException(message);
            ve.setConstraintReference(e);
            this.reportValidationError(ve, true, locationId, 1);
        }
        if (this.nil) {
            String message = "No child elements are allowed when xsi:nil is true";
            ValidationException ve = new ValidationException(message);
            ve.setConstraintReference(1, "cvc-elt", "3.2.1");
            this.reportValidationError(ve, true, locationId, 1);
        }
        typeCode = this.childValidator.getAnnotation();
        super.startElement(nameCode, typeCode, locationId, properties);
    }

    public ContentValidator getChildValidator() {
        return this.childValidator;
    }

    public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        int fingerprint = nameCode & 0xFFFFF;
        if (fingerprint == 642) {
            if (this.getNillability() == 2) {
                String message = "The element is not nillable, so xsi:nil must not be present";
                ValidationException ve = new ValidationException(message);
                ve.setConstraintReference(1, "cvc-elt", "3.1");
                this.reportValidationError(ve, true, locationId, 1);
            }
            String b = Whitespace.trim(value);
            if (this.getNillability() != 0 && (b.equals("true") || b.equals("1"))) {
                this.nil = true;
            }
        }
        int annotation = 631;
        AttributeDecl decl = (AttributeDecl)this.getConfiguration().getAttributeDeclaration(fingerprint);
        if (decl != null) {
            SimpleType type = decl.getSimpleType();
            ValidationFailure err = type.validateContent(value, this.getNamespaceResolver(), this.getConfiguration().getConversionRules());
            if (err != null) {
                err.setConstraintReference(1, "cvc-complex-type", "3");
                this.reportValidationError(err.makeException(), false, locationId, 1);
            } else {
                if (type instanceof UserAtomicType) {
                    value = ((UserAtomicType)type).getSharedInstance(((Object)value).toString());
                }
                annotation = type.getFingerprint();
                if (!decl.testFixedValue(value, this.getNamespaceResolver())) {
                    Value fixed = decl.getFixedValue();
                    String message = "The actual value " + Err.wrap(value, 4) + " of attribute " + Err.wrap(this.getNamePool().getDisplayName(nameCode), 2) + " does not match the required fixed value " + (fixed instanceof AtomicValue ? Err.wrap(fixed.getStringValue(), 4) : "");
                    ValidationException ve = new ValidationException(message);
                    ve.setConstraintReference(1, "cvc-au", "0");
                    this.reportValidationError(ve, false, locationId, 1);
                }
            }
        }
        super.attribute(nameCode, annotation, value, locationId, properties);
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        if (this.nil && !Whitespace.isWhite(chars)) {
            String message = "No character content is allowed when xsi:nil is true";
            ValidationException ve = new ValidationException(message);
            ve.setConstraintReference(1, "cvc-elt", "3.2.1");
            this.reportValidationError(ve, true, locationId, 1);
        }
        super.characters(chars, locationId, properties);
    }
}

