/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.validate;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.CopyInformee;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sink;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.MutableNodeInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;

public class InSituValidator {
    private MutableNodeInfo[] nodeBuffer = new MutableNodeInfo[16];
    private MutableNodeInfo root;
    private int validationMode;

    public InSituValidator(MutableNodeInfo root, int validationMode) {
        this.root = root;
        this.validationMode = validationMode;
    }

    public void validate() throws XPathException {
        Configuration config = this.root.getConfiguration();
        NodeUpdater endPoint = new NodeUpdater();
        PipelineConfiguration pipe = config.makePipelineConfiguration();
        endPoint.setPipelineConfiguration(pipe);
        Receiver validator = this.root instanceof DocumentInfo ? config.getDocumentValidator(endPoint, this.root.getSystemId(), this.validationMode, 3, null, -1) : config.getElementValidator(endPoint, this.root.getNameCode(), 0, null, this.validationMode);
        pipe.setCopyInformee(new NodeCounter(validator));
        this.root.copy(validator, 2, 0);
    }

    private class NodeUpdater
    extends Sink {
        private MutableNodeInfo currentElement;

        public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
            MutableNodeInfo node = InSituValidator.this.nodeBuffer[locationId % 16];
            node.setTypeAnnotation(typeCode);
            this.currentElement = node;
        }

        public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) throws XPathException {
            if ((properties & 8) != 0) {
                this.currentElement.addAttribute(nameCode, typeCode, value, 0);
            } else {
                NodeInfo att;
                AxisIterator axis = this.currentElement.iterateAxis((byte)2);
                while ((att = (NodeInfo)axis.next()) != null) {
                    if (att.getFingerprint() != (nameCode & 0xFFFFF)) continue;
                    ((MutableNodeInfo)att).setTypeAnnotation(typeCode);
                    break;
                }
            }
        }

        public boolean usesTypeAnnotations() {
            return true;
        }
    }

    private class NodeCounter
    implements CopyInformee {
        int counter = 0;

        public NodeCounter(Receiver next) {
        }

        public int notifyElementNode(NodeInfo element) {
            ((InSituValidator)InSituValidator.this).nodeBuffer[this.counter % 16] = (MutableNodeInfo)element;
            return this.counter++;
        }
    }
}

