/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.validate;

import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.Whitespace;

public class IgnorableWhitespaceStripper
extends ProxyReceiver {
    private boolean[] stripStack = new boolean[100];
    private int top = 0;

    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        SchemaType type;
        this.nextReceiver.startElement(nameCode, typeCode, locationId, properties);
        boolean strip = false;
        if (typeCode != -1 && typeCode != 630 && (type = this.getConfiguration().getSchemaType(typeCode & 0xFFFFF)).isComplexType() && !((ComplexType)type).isSimpleContent() && !((ComplexType)type).isMixedContent()) {
            strip = true;
        }
        ++this.top;
        if (this.top >= this.stripStack.length) {
            boolean[] newStack = new boolean[this.top * 2];
            System.arraycopy(this.stripStack, 0, newStack, 0, this.top);
            this.stripStack = newStack;
        }
        this.stripStack[this.top] = strip;
    }

    public void endElement() throws XPathException {
        this.nextReceiver.endElement();
        --this.top;
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        if (!(chars.length() <= 0 || this.stripStack[this.top] && Whitespace.isWhite(chars))) {
            this.nextReceiver.characters(chars, locationId, properties);
        }
    }

    public boolean usesTypeAnnotations() {
        return true;
    }
}

