/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.validate;

import com.saxonica.stream.om.FleetingNode;
import com.saxonica.validate.Checker;
import com.saxonica.validate.SelectorWatch;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

public class FieldChecker
extends Checker {
    private SelectorWatch parentWatch;
    private NamespaceResolver namespaceResolver;
    private Value[] currentRow;
    private int column;
    private boolean matchElements;
    private boolean active = false;
    private boolean nillableElement = false;
    private SchemaType elementType;
    private FastStringBuffer buffer = new FastStringBuffer(64);
    private long textLocationId = 0L;
    int depth = 0;

    public FieldChecker(SelectorWatch parentWatch, Pattern selection, Value[] currentRow, int column) {
        this.parentWatch = parentWatch;
        this.currentRow = currentRow;
        this.column = column;
        this.matchElements = selection.getNodeKind() == 1 || selection.getNodeKind() == 0;
    }

    public void setNamespaceResolver(NamespaceResolver resolver) {
        this.namespaceResolver = resolver;
    }

    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        this.nillableElement = false;
        if (this.matchElements) {
            if (this.depth > 0) {
                throw new ValidationException("An element participating as a field in a constraint cannot have child elements");
            }
            if (typeCode != -1) {
                this.elementType = this.getConfiguration().getSchemaType(typeCode);
            }
            this.active = true;
            this.buffer.setLength(0);
        }
        ++this.depth;
    }

    public void notifySelectedAttribute(FleetingNode attribute, int locationId) throws XPathException {
        Configuration config = this.getConfiguration();
        ConversionRules rules = config.getConversionRules();
        int typeCode = attribute.getTypeAnnotation();
        String value = attribute.getStringValue();
        if (typeCode != -1 && typeCode != 631) {
            Value val;
            block4: {
                try {
                    SchemaType type = config.getSchemaType(typeCode);
                    if (type instanceof SimpleType) {
                        val = ((SimpleType)type).isNamespaceSensitive() ? (Value)SequenceExtent.makeSequenceExtent(((SimpleType)type).getTypedValue(value, this.namespaceResolver, rules)) : (type.isAtomicType() ? StringValue.convertStringToAtomicType(value, (AtomicType)type, rules).asAtomic() : (Value)SequenceExtent.makeSequenceExtent(((SimpleType)type).getTypedValue(value, this.namespaceResolver, rules)));
                        break block4;
                    }
                    throw new IllegalStateException("Attributes must have a simple type");
                }
                catch (XPathException e) {
                    throw new ValidationException(e);
                }
            }
            this.parentWatch.addFieldValue(this.currentRow, this.column, val, false, locationId);
        }
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        if (this.active && this.matchElements && this.depth == 1) {
            this.buffer.append(chars);
        }
        this.nillableElement = (properties & 0x200) != 0;
        this.textLocationId = locationId;
    }

    public void endElement() throws XPathException {
        if (this.active && this.matchElements && this.depth == 1) {
            Value val;
            if (this.elementType == null || this.elementType instanceof AnySimpleType) {
                val = new UntypedAtomicValue(this.buffer.toString());
            } else {
                SchemaType contentType = this.elementType;
                if (this.elementType instanceof ComplexType) {
                    if (((ComplexType)this.elementType).isSimpleContent()) {
                        contentType = ((ComplexType)this.elementType).getSimpleContentType();
                    } else {
                        ValidationException err = new ValidationException("The value of a field participating in an identity constraint must have a simple type, or a complex type with simple content");
                        err.setConstraintReference(1, "cvc-identity-constraint", "3");
                        throw err;
                    }
                }
                val = contentType.getFingerprint() == 513 ? StringValue.makeStringValue(this.buffer.toString()) : (((SimpleType)contentType).isNamespaceSensitive() ? (Value)SequenceExtent.makeSequenceExtent(((SimpleType)contentType).getTypedValue(this.buffer, this.namespaceResolver, this.getConfiguration().getConversionRules())) : (contentType.isAtomicType() ? StringValue.convertStringToAtomicType(this.buffer, (AtomicType)contentType, this.getConfiguration().getConversionRules()).asAtomic() : (Value)SequenceExtent.makeSequenceExtent(((SimpleType)contentType).getTypedValue(this.buffer, this.namespaceResolver, this.getConfiguration().getConversionRules()))));
            }
            this.parentWatch.addFieldValue(this.currentRow, this.column, val, this.nillableElement, this.textLocationId);
        }
        --this.depth;
    }

    public void close() {
        this.active = false;
    }

    public boolean usesTypeAnnotations() {
        return true;
    }
}

