/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.validate;

import com.saxonica.schema.TypeReference;
import com.saxonica.schema.UserUnionType;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.SaxonLocator;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.expr.instruct.DummyNamespaceResolver;
import net.sf.saxon.expr.sort.IntHashMap;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ListType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Whitespace;

public class EntityValidator
extends ProxyReceiver {
    private Set<String> declaredEntities = new HashSet<String>(10);
    private EntityChecker currentElementChecker = null;
    private FastStringBuffer buffer = new FastStringBuffer(64);
    private long textLocationId = 0L;
    private IntHashMap<EntityChecker> checkerMap = new IntHashMap(10);
    private static NonIdChecker SINGLETON_NON_ENTITY_CHECKER = new NonIdChecker();

    public void setUnparsedEntity(String name, String uri, String publicId) throws XPathException {
        this.declaredEntities.add(name);
    }

    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        this.currentElementChecker = this.checkerMap.get(typeCode);
        if (this.currentElementChecker == null) {
            this.currentElementChecker = this.allocateChecker(typeCode & 0xFFFFF);
            this.checkerMap.put(typeCode, this.currentElementChecker);
        }
        if (this.currentElementChecker == SINGLETON_NON_ENTITY_CHECKER) {
            this.currentElementChecker = null;
        }
        this.nextReceiver.startElement(nameCode, typeCode, locationId, properties);
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        if (this.currentElementChecker != null) {
            this.buffer.append(chars);
        }
        this.nextReceiver.characters(chars, locationId, properties);
        this.textLocationId = locationId;
    }

    public void endElement() throws XPathException {
        if (this.currentElementChecker != null) {
            this.currentElementChecker.checkValue(this.buffer, this.textLocationId);
        }
        this.buffer.setLength(0);
        this.currentElementChecker = null;
        this.nextReceiver.endElement();
    }

    public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        EntityChecker checker = this.checkerMap.get(typeCode);
        if (checker == null) {
            checker = this.allocateChecker(typeCode & 0xFFFFF);
            this.checkerMap.put(typeCode, checker);
        }
        checker.checkValue(value, locationId);
        this.nextReceiver.attribute(nameCode, typeCode, value, locationId, properties);
    }

    private EntityChecker allocateChecker(int fingerprint) {
        switch (fingerprint) {
            case 563: {
                return new SimpleEntityChecker();
            }
            case 564: {
                return new EntityListChecker();
            }
        }
        if (fingerprint < 1023) {
            return SINGLETON_NON_ENTITY_CHECKER;
        }
        Configuration config = this.getConfiguration();
        TypeHierarchy th = config.getTypeHierarchy();
        SchemaType stype = config.getSchemaType(fingerprint);
        if (stype.isComplexType()) {
            return SINGLETON_NON_ENTITY_CHECKER;
        }
        SimpleType type = (SimpleType)stype;
        if (type.isAtomicType()) {
            if (th.isSubType((AtomicType)type, BuiltInAtomicType.ENTITY)) {
                return new SimpleEntityChecker();
            }
            return SINGLETON_NON_ENTITY_CHECKER;
        }
        if (type.isListType()) {
            if (EntityValidator.isEntityType(type, th)) {
                return new EntityListChecker();
            }
            return SINGLETON_NON_ENTITY_CHECKER;
        }
        if (EntityValidator.isEntityType(type, th)) {
            return new UnionChecker(type);
        }
        return SINGLETON_NON_ENTITY_CHECKER;
    }

    private static boolean isEntityType(SimpleType type, TypeHierarchy th) {
        if (type.isAtomicType()) {
            return th.isSubType((AtomicType)type, BuiltInAtomicType.ENTITY);
        }
        if (type.isListType()) {
            return EntityValidator.isEntityType(((ListType)type).getItemType(), th);
        }
        if (type.isUnionType()) {
            UserUnionType union = (UserUnionType)type;
            for (TypeReference ref : union.getMemberTypeReferences()) {
                SimpleType mem = (SimpleType)ref.getTarget();
                if (!EntityValidator.isEntityType(mem, th)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean usesTypeAnnotations() {
        return true;
    }

    protected void reportValidationError(ValidationException err, long locationId) throws ValidationException {
        PipelineConfiguration pipe = this.getPipelineConfiguration();
        SaxonLocator locator = ExpressionLocation.getSourceLocator(locationId, pipe.getLocationProvider());
        err.setSourceLocator(locator);
        ErrorListener listener = pipe.getErrorListener();
        try {
            listener.fatalError(err);
            err.setHasBeenReported(true);
        }
        catch (TransformerException e) {
            err.setHasBeenReported(true);
            if (e instanceof ValidationException) {
                throw (ValidationException)e;
            }
            if (e.getException() instanceof ValidationException) {
                throw (ValidationException)e.getException();
            }
            throw new ValidationException(e);
        }
    }

    private void processEntityRef(String eref, long locationId) throws XPathException {
        if (!this.declaredEntities.contains(eref)) {
            ValidationException ve = new ValidationException("Value '" + eref + "' is not declared in the DTD as an unparsed entity name");
            ve.setConstraintReference(1, "cvc-simple-type", "3");
            this.reportValidationError(ve, locationId);
            throw ve;
        }
    }

    private static class NonIdChecker
    implements EntityChecker {
        private NonIdChecker() {
        }

        public void checkValue(CharSequence value, long locationId) throws XPathException {
        }
    }

    private class UnionChecker
    implements EntityChecker {
        private SimpleType type;

        public UnionChecker(SimpleType type) {
            this.type = type;
        }

        public void checkValue(CharSequence value, long locationId) throws XPathException {
            AtomicValue val;
            Configuration config = EntityValidator.this.getConfiguration();
            TypeHierarchy th = config.getTypeHierarchy();
            SequenceIterator iter = this.type.getTypedValue(value, DummyNamespaceResolver.getInstance(), config.getConversionRules());
            while ((val = (AtomicValue)iter.next()) != null) {
                AtomicType itemType = val.getTypeLabel();
                if (!EntityValidator.isEntityType(itemType, th)) continue;
                EntityValidator.this.processEntityRef(val.getStringValue(), locationId);
            }
        }
    }

    private class EntityListChecker
    implements EntityChecker {
        private EntityListChecker() {
        }

        public void checkValue(CharSequence value, long locationId) throws XPathException {
            String ids = ((Object)value).toString();
            StringTokenizer tok = new StringTokenizer(ids, " \t\n\r", false);
            while (tok.hasMoreTokens()) {
                String id = tok.nextToken();
                EntityValidator.this.processEntityRef(id, locationId);
            }
        }
    }

    private class SimpleEntityChecker
    implements EntityChecker {
        private SimpleEntityChecker() {
        }

        public void checkValue(CharSequence value, long locationId) throws XPathException {
            String id = ((Object)Whitespace.trimWhitespace(value)).toString();
            EntityValidator.this.processEntityRef(id, locationId);
        }
    }

    private static interface EntityChecker {
        public void checkValue(CharSequence var1, long var2) throws XPathException;
    }
}

