/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.validate;

import com.saxonica.schema.ElementDecl;
import com.saxonica.schema.UserComplexType;
import com.saxonica.validate.AnyTypeValidator;
import com.saxonica.validate.AttributeValidator;
import com.saxonica.validate.ContentValidator;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.ValidationException;

public class EmptyContentValidator
extends AttributeValidator {
    private boolean allowTextNodes;
    private int locationId;
    private FastStringBuffer buffer;
    private SchemaType schemaType;

    public EmptyContentValidator(UserComplexType type) throws ValidationException {
        this.schemaType = type;
        this.setAttributeGroup(type.getCombinedAttributeGroup());
        this.allowTextNodes = type.isMixedContent();
        this.setAnnotation(type.getFingerprint());
    }

    public SchemaType getSchemaType() {
        return this.schemaType;
    }

    public ContentValidator getChildValidator() {
        return new AnyTypeValidator();
    }

    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        this.locationId = locationId;
        String message = "Invalid child element " + Err.wrap(this.getNamePool().getDisplayName(nameCode), 1) + ", " + this.getContainingElementName() + " has an empty content model";
        ValidationException ve = new ValidationException(message);
        ve.setConstraintReference(1, "cvc-complex-type", "2.1");
        this.reportValidationError(ve, true, locationId, 1);
        this.buffer = null;
        super.startElement(nameCode, 572, locationId, properties);
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        ValidationException ve;
        String message;
        if (this.allowTextNodes) {
            ElementDecl decl = this.getElementDeclaration();
            if (decl != null && (decl.getFixedValue() != null || decl.getDefaultValue() != null)) {
                if (this.buffer == null) {
                    this.buffer = new FastStringBuffer(chars.length());
                }
                this.buffer.append(chars);
            }
        } else {
            message = "Character data is not allowed: " + this.getContainingElementName() + " has an empty content model";
            ve = new ValidationException(message);
            ve.setConstraintReference(1, "cvc-complex-type", "2.1");
            this.reportValidationError(ve, true, locationId, 1);
        }
        if (this.isNil()) {
            message = "Character data is not allowed when xsi:nil='true'";
            ve = new ValidationException(message);
            ve.setConstraintReference(1, "cvc-elt", "3.2.1");
            this.reportValidationError(ve, true, locationId, 1);
        }
        this.nextReceiver.characters(chars, locationId, properties);
    }

    public void endElement() throws XPathException {
        ElementDecl decl;
        if (this.isNil() && (decl = this.getElementDeclaration()) != null && decl.getFixedValue() != null) {
            String message = "An element with xsi:nil='true' must not have a fixed value";
            ValidationException ve = new ValidationException(message);
            ve.setConstraintReference(1, "cvc-elt", "3.2.2");
            this.reportValidationError(ve, true, this.locationId, 1);
        }
        if (this.allowTextNodes && (decl = this.getElementDeclaration()) != null) {
            String defaultValue = decl.getDefaultValue();
            String fixedValue = decl.getFixedValueLexicalRepresentation();
            if (defaultValue != null && (this.buffer == null || this.buffer.length() == 0)) {
                this.characters(defaultValue, 0, 0);
            } else if (fixedValue != null) {
                if (this.buffer == null || this.buffer.length() == 0) {
                    this.characters(fixedValue, 0, 0);
                } else if (!this.buffer.toString().equals(fixedValue)) {
                    String message = "The content " + Err.wrap(this.buffer, 4) + " of " + this.getContainingElementName() + " does not match the fixed value " + Err.wrap(fixedValue, 4);
                    ValidationException ve = new ValidationException(message);
                    ve.setConstraintReference(1, "cvc-elt", "5.2.2.2");
                    this.reportValidationError(ve, true, this.getContainingElementLocationId(), 1);
                }
            }
        }
        super.endElement();
    }
}

