/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.validate;

import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

public class DocumentValidator
extends ProxyReceiver {
    boolean foundElement = false;
    int level = 0;

    public void setPipelineConfiguration(PipelineConfiguration config) {
        super.setPipelineConfiguration(config);
    }

    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        if (this.foundElement && this.level == 0) {
            XPathException de = new XPathException("A valid document must have only one child element");
            if (this.getPipelineConfiguration().getHostLanguage() == 50) {
                de.setErrorCode("XTTE1550");
            } else {
                de.setErrorCode("XQDY0061");
            }
            throw de;
        }
        this.foundElement = true;
        ++this.level;
        this.nextReceiver.startElement(nameCode, typeCode, locationId, properties);
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        if (this.level == 0) {
            if (Whitespace.isWhite(chars)) {
                return;
            }
            XPathException de = new XPathException("A valid document must contain no text outside the outermost element");
            if (this.getPipelineConfiguration().getHostLanguage() == 50) {
                de.setErrorCode("XTTE1550");
            } else {
                de.setErrorCode("XQDY0061");
            }
            throw de;
        }
        this.nextReceiver.characters(chars, locationId, properties);
    }

    public void endElement() throws XPathException {
        --this.level;
        this.nextReceiver.endElement();
    }

    public void endDocument() throws XPathException {
        if (this.level == 0) {
            if (!this.foundElement) {
                XPathException de = new XPathException("A valid document must have a child element");
                if (this.getPipelineConfiguration().getHostLanguage() == 50) {
                    de.setErrorCode("XTTE1550");
                } else {
                    de.setErrorCode("XQDY0061");
                }
                throw de;
            }
            this.foundElement = false;
            this.nextReceiver.endDocument();
            this.level = -1;
        }
    }
}

