/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.validate;

import com.saxonica.schema.ElementDecl;
import com.saxonica.schema.TypeAlternative;
import com.saxonica.schema.UserComplexType;
import com.saxonica.validate.AllElementValidator;
import com.saxonica.validate.AnyTypeValidator;
import com.saxonica.validate.ComplexContentValidator;
import com.saxonica.validate.ConstraintChecker;
import com.saxonica.validate.EmptyContentValidator;
import com.saxonica.validate.LaxValidator;
import com.saxonica.validate.SimpleContentValidator;
import com.saxonica.validate.SkipValidator;
import com.saxonica.validate.StartTagBufferEE;
import com.saxonica.validate.ValidatingFilter;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.sxpath.XPathDynamicContext;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;

public abstract class ContentValidator
extends ValidatingFilter {
    public static final int NIL_IGNORED = 0;
    public static final int NIL_ALLOWED = 1;
    public static final int NIL_DISALLOWED = 2;
    private int containingElement = -1;
    private int containingElementLocation;
    protected SchemaType xsiType;
    protected boolean nil = false;
    private int nillability = 0;
    private ElementDecl elementDecl;
    private StartTagBufferEE startTagBuffer;
    private int annotation = 630;
    protected List<String> pendingMessages;

    public void setContainingElement(int fingerprint, int locationId) {
        this.containingElement = fingerprint;
        this.containingElementLocation = locationId;
    }

    protected void setElementDeclaration(ElementDecl decl) {
        this.elementDecl = decl;
    }

    protected ElementDecl getElementDeclaration() {
        return this.elementDecl;
    }

    public int getContainingElement() {
        return this.containingElement;
    }

    public int getContainingElementLocationId() {
        return this.containingElementLocation;
    }

    protected String getContainingElementName() {
        int fp = this.getContainingElement();
        if (fp == -1) {
            return "element";
        }
        return "element " + Err.wrap(this.getNamePool().getDisplayName(fp), 1);
    }

    public abstract SchemaType getSchemaType();

    protected final void setAnnotation(int annotation) {
        this.annotation = annotation;
    }

    protected final int getAnnotation() {
        return this.annotation;
    }

    public void setXSIType(SchemaType xsiType) {
        this.xsiType = xsiType;
    }

    public void setStartTagBuffer(StartTagBufferEE startTag) {
        this.startTagBuffer = startTag;
    }

    public StartTagBufferEE getStartTagBuffer() {
        return this.startTagBuffer;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.startTagBuffer;
    }

    public void setNillability(int nillability) {
        this.nillability = nillability;
    }

    public int getNillability() {
        return this.nillability;
    }

    public boolean isNil() {
        return this.nil;
    }

    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        ElementDecl element;
        this.xsiType = null;
        if (this.nextReceiver instanceof ConstraintChecker && (element = this.getChildValidator().getElementDeclaration()) != null) {
            ((ConstraintChecker)this.nextReceiver).setElementDeclaration(element);
        }
        try {
            this.nextReceiver.startElement(nameCode, typeCode, locationId, properties);
        }
        catch (ValidationException ve) {
            this.reportValidationError(ve, true, locationId, 1);
        }
    }

    public static ContentValidator makeValidator(ElementDecl decl, int nameCode, int locationId, StartTagBufferEE startTagBuffer, SchemaType governingType, int validation, PipelineConfiguration pipe, Receiver nextReceiver) throws XPathException {
        ContentValidator val;
        Configuration config = pipe.getConfiguration();
        int nillability = 0;
        if (validation == 4 && governingType == null) {
            val = new SkipValidator();
        } else if (validation == 8) {
            val = ContentValidator.makeValidatorForType(null, governingType, pipe, nextReceiver);
        } else if (decl == null) {
            if (governingType != null) {
                val = ContentValidator.makeValidatorForType(null, governingType, pipe, nextReceiver);
            } else {
                if (validation == 1) {
                    String message = "Cannot validate " + Err.wrap(config.getNamePool().getClarkName(nameCode), 1) + ": no element declaration available";
                    ValidationException ve = new ValidationException(message);
                    ve.setConstraintReference(1, "cvc-elt", "1");
                    throw ve;
                }
                val = new LaxValidator();
                val.setUnderlyingReceiver(nextReceiver);
            }
        } else {
            if (decl.isAbstract()) {
                String msg = "Invalid element " + Err.wrap(config.getNamePool().getDisplayName(nameCode), 1) + ": the element is declared to be abstract";
                throw new ValidationException(msg);
            }
            nillability = decl.isNillable() ? 1 : 2;
            config.sealNamespace(decl.getTargetNamespace());
            if (governingType != null && governingType.getFingerprint() == 631) {
                throw new ValidationException("Cannot use xs:untypedAtomic as governing type for validation");
            }
            SchemaType elType = decl.getType();
            if (startTagBuffer != null && decl.hasTypeAlternatives()) {
                elType = ContentValidator.getConditionalType(startTagBuffer, decl);
            }
            if (elType != null && governingType != null) {
                int block = decl.getBlock() | elType.getBlock();
                try {
                    config.checkTypeDerivationIsOK(governingType, elType, block);
                }
                catch (SchemaException err) {
                    ValidationException ve = new ValidationException("The xsi:type is not validly derived from the declared type. " + err.getMessage());
                    ve.setConstraintReference(1, "cvc-elt", "4.3");
                    throw ve;
                }
                elType = governingType;
            }
            if (elType == null) {
                if (governingType == null) {
                    val = new AnyTypeValidator();
                    val.setUnderlyingReceiver(nextReceiver);
                } else {
                    val = ContentValidator.makeValidatorForType(decl, governingType, pipe, nextReceiver);
                }
            } else if (elType instanceof UserComplexType && ((ComplexType)elType).isAbstract()) {
                if (governingType == null) {
                    governingType = elType;
                    val = new EmptyContentValidator((UserComplexType)elType);
                    val.setUnderlyingReceiver(nextReceiver);
                } else {
                    val = ContentValidator.makeValidatorForType(decl, governingType, pipe, nextReceiver);
                }
            } else {
                governingType = elType;
                val = ContentValidator.makeValidatorForType(decl, elType, pipe, nextReceiver);
            }
        }
        val.setPipelineConfiguration(pipe);
        val.setContainingElement(nameCode == -1 ? -1 : nameCode & 0xFFFFF, locationId);
        val.setStartTagBuffer(startTagBuffer);
        val.setNillability(nillability);
        val.setElementDeclaration(decl);
        val.setAnnotation(governingType == null ? 630 : governingType.getFingerprint());
        return val;
    }

    private static SchemaType getConditionalType(StartTagBufferEE startTagBuffer, ElementDecl decl) throws XPathException {
        SchemaType eltype = decl.getType();
        NodeInfo element = startTagBuffer.createSkeletonElementNode();
        Iterator<TypeAlternative> iter = decl.iterateTypeAlternatives();
        while (iter.hasNext()) {
            TypeAlternative alt = iter.next();
            XPathExpression exp = alt.getCondition();
            if (exp == null) {
                eltype = alt.getSchemaType();
                break;
            }
            XPathExpression condition = exp;
            XPathDynamicContext context = condition.createDynamicContext(element);
            try {
                if (!ExpressionTool.effectiveBooleanValue(condition.iterate(context))) continue;
                eltype = alt.getSchemaType();
                break;
            }
            catch (XPathException err) {
                PipelineConfiguration pipe = startTagBuffer.getPipelineConfiguration();
                try {
                    XPathException warning = new XPathException("Dynamic error occurred during evaluation of Conditional Type Alternative test: " + err.getMessage(), err);
                    pipe.getErrorListener().warning(warning);
                }
                catch (TransformerException err2) {
                    throw XPathException.makeXPathException(err2);
                }
            }
        }
        return eltype;
    }

    protected abstract ContentValidator getChildValidator();

    public static ContentValidator makeValidatorForType(ElementDecl elementDecl, SchemaType schemaType, PipelineConfiguration pipe, Receiver nextReceiver) throws ValidationException {
        ContentValidator val;
        if (schemaType instanceof SimpleType) {
            val = new SimpleContentValidator(elementDecl, schemaType);
        } else if (schemaType instanceof AnyType) {
            val = new AnyTypeValidator(elementDecl);
        } else {
            if (schemaType.getFingerprint() == 631) {
                throw new ValidationException("Cannot use xs:untypedAtomic as governing type for validation");
            }
            ComplexType complexType = (ComplexType)schemaType;
            val = complexType.isSimpleContent() ? new SimpleContentValidator(elementDecl, complexType) : (complexType.isAbstract() ? new AnyTypeValidator(elementDecl) : (complexType.isEmptyContent() ? new EmptyContentValidator((UserComplexType)complexType) : (complexType.isAllContent() ? new AllElementValidator((UserComplexType)complexType) : new ComplexContentValidator(elementDecl, (UserComplexType)complexType))));
        }
        val.setPipelineConfiguration(pipe);
        val.setUnderlyingReceiver(nextReceiver);
        val.setErrorCode(pipe.getHostLanguage() == 50 ? "XTTE1540" : "XQDY0027");
        return val;
    }

    public void endDocument() throws XPathException {
        this.reportIfInvalid();
        this.nextReceiver.endDocument();
    }
}

