/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.validate;

import com.saxonica.schema.ElementDecl;
import com.saxonica.schema.Term;
import com.saxonica.schema.UserComplexType;
import com.saxonica.schema.Wildcard;
import com.saxonica.schema.fsa.Edge;
import com.saxonica.schema.fsa.FiniteStateMachine;
import com.saxonica.schema.fsa.State;
import com.saxonica.schema.fsa.SuffixState;
import com.saxonica.validate.AnyTypeValidator;
import com.saxonica.validate.AttributeValidator;
import com.saxonica.validate.ContentValidator;
import com.saxonica.validate.SkipValidator;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.Value;
import net.sf.saxon.value.Whitespace;

public class ComplexContentValidator
extends AttributeValidator {
    UserComplexType type;
    boolean mixed;
    String fixedValue = null;
    String defaultValue = null;
    State state;
    boolean ignoreIgnorable;
    FastStringBuffer buffer;
    boolean foundChildren = false;

    public ComplexContentValidator(ElementDecl declaration, UserComplexType type) throws ValidationException {
        this.setSchemaType(type);
        if (declaration != null) {
            this.defaultValue = declaration.getDefaultValue();
            try {
                Value fixed = declaration.getFixedValue();
                if (fixed != null) {
                    this.fixedValue = fixed.getStringValue();
                }
            }
            catch (XPathException xPathException) {
                // empty catch block
            }
        }
    }

    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        super.setPipelineConfiguration(pipe);
        this.ignoreIgnorable = this.getConfiguration().getStripsWhiteSpace() != 0;
    }

    public void setSchemaType(UserComplexType type) throws ValidationException {
        this.type = type;
        this.mixed = type.isMixedContent();
        this.state = type.getInitialState();
        this.setAnnotation(type.getFingerprint());
        this.setAttributeGroup(type.getCombinedAttributeGroup());
    }

    public SchemaType getSchemaType() {
        return this.type;
    }

    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        int annotation;
        if (this.getInvalidity() > 1) {
            this.nextReceiver.startElement(nameCode, 572, locationId, properties);
            return;
        }
        PipelineConfiguration pipe = this.getPipelineConfiguration();
        NamePool pool = this.getNamePool();
        if (this.fixedValue != null) {
            String message = "Element " + Err.wrap(pool.getDisplayName(nameCode), 1) + " cannot appear here, because the containing " + this.getContainingElementName() + " element has fixed content";
            ValidationException ve = new ValidationException(message);
            ve.setConstraintReference(1, "cvc-elt", "5.2.2.1");
            this.reportValidationError(ve, true, locationId, 2);
        }
        this.foundChildren = true;
        int fingerprint = nameCode & 0xFFFFF;
        Edge edge = this.state.getTransition(fingerprint, this.type);
        if (edge == null) {
            FiniteStateMachine machine = this.type.getFiniteStateMachine();
            Wildcard openContentWildcard = machine.getOpenContentWildcard();
            if (openContentWildcard != null && openContentWildcard.matches(fingerprint, true, this.getConfiguration(), this.type)) {
                if (machine.isOpenContentInterleaved()) {
                    int annotation2 = this.processWildcardTerm(openContentWildcard, nameCode, locationId);
                    super.startElement(nameCode, annotation2, locationId, properties);
                    return;
                }
                if (this.state.isFinalState()) {
                    this.state = SuffixState.getInstance();
                    int annotation3 = this.processWildcardTerm(openContentWildcard, nameCode, locationId);
                    super.startElement(nameCode, annotation3, locationId, properties);
                    return;
                }
            }
            CharSequence sb = this.state.listAllowedElements();
            String message = this.state instanceof SuffixState ? "The content model does not allow element " + Err.wrap(pool.getDisplayName(nameCode), 1) + " to appear after an element that matches the suffix open content wildcard. " : "The content model does not allow element " + Err.wrap(pool.getDisplayName(nameCode), 1) + " to appear here" + (openContentWildcard == null ? "" : " (it does not match the open content wildcard)") + ". " + ((Object)sb).toString();
            if (this.getContainingElement() != -1) {
                message = "In content of " + this.getContainingElementName() + ": " + message;
            }
            ValidationException ve = new ValidationException(message);
            ve.setConstraintReference(1, "cvc-complex-type", "2.4");
            this.reportValidationError(ve, true, locationId, 2);
            this.nextReceiver.startElement(nameCode, 572, locationId, properties);
            return;
        }
        try {
            this.state = edge.makeTransition(this.state);
        }
        catch (ValidationException e) {
            String message = e.getMessage();
            if (this.getContainingElement() != -1) {
                message = "In content of " + this.getContainingElementName() + ": " + message;
            }
            ValidationException ve = new ValidationException(message);
            ve.setSourceLocator(e.getLocator());
            ve.setConstraintReference(e.getConstraintSchemaPart(), e.getConstraintName(), e.getConstraintClauseNumber());
            this.reportValidationError(ve, true, locationId, 2);
            this.childValidator = new SkipValidator();
        }
        Term term = edge.getTerm();
        if (term instanceof ElementDecl) {
            ElementDecl decl = (ElementDecl)term;
            try {
                this.childValidator = ComplexContentValidator.makeValidator(decl, nameCode, locationId, this.getStartTagBuffer(), this.xsiType, 0, pipe, this.getUnderlyingReceiver());
            }
            catch (ValidationException e) {
                String message = e.getMessage();
                if (this.getContainingElement() != -1) {
                    message = "In content of " + this.getContainingElementName() + ": " + message;
                }
                ValidationException ve = new ValidationException(message);
                ve.setSourceLocator(e.getLocator());
                ve.setConstraintReference(e.getConstraintSchemaPart(), e.getConstraintName(), e.getConstraintClauseNumber());
                this.reportValidationError(ve, true, locationId, 2);
                this.childValidator = new SkipValidator();
            }
            this.childValidator.setContainingElement(decl.getFingerprint(), locationId);
            annotation = this.childValidator.getAnnotation();
        } else {
            Wildcard card = (Wildcard)term;
            annotation = this.processWildcardTerm(card, nameCode, locationId);
        }
        super.startElement(nameCode, annotation, locationId, properties);
    }

    protected ContentValidator getChildValidator() {
        if (this.getInvalidity() > 1) {
            return new AnyTypeValidator();
        }
        return this.childValidator;
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        if (this.mixed) {
            if (this.buffer == null) {
                this.buffer = new FastStringBuffer(chars.length());
            }
            this.buffer.append(chars);
            this.nextReceiver.characters(chars, locationId, properties);
        } else if (Whitespace.isWhite(chars)) {
            if (!this.ignoreIgnorable) {
                this.nextReceiver.characters(chars, locationId, properties);
            }
        } else {
            String message = "The content model for " + this.getContainingElementName() + " does not allow character content";
            ValidationException ve = new ValidationException(message);
            ve.setConstraintReference(1, "cvc-complex-type", "2.3");
            this.reportValidationError(ve, true, locationId, 1);
        }
    }

    public void endElement() throws XPathException {
        ValidationException ve;
        String message;
        if (this.fixedValue != null) {
            if (this.isNil()) {
                String message2 = "Element " + this.getContainingElementName() + " has a fixed value so it must not be nil";
                ValidationException ve2 = new ValidationException(message2);
                this.reportValidationError(ve2, true, this.getContainingElementLocationId(), 1);
                this.nextReceiver.endElement();
                return;
            }
            if (this.buffer == null || this.buffer.length() == 0) {
                this.characters(this.fixedValue, 0, 0);
            } else if (!this.buffer.toString().equals(this.fixedValue)) {
                message = "The content of " + this.getContainingElementName() + " differs from the fixed value defined in the schema. Fixed value is " + Err.wrap(this.fixedValue, 4) + ", actual value is " + Err.wrap(this.buffer, 4);
                ve = new ValidationException(message);
                ve.setConstraintReference(1, "cvc-elt", "5.2.2.2");
                this.reportValidationError(ve, true, this.getContainingElementLocationId(), 1);
            }
        }
        if (!(this.defaultValue == null || this.foundChildren || this.buffer != null && this.buffer.length() != 0)) {
            this.characters(this.defaultValue, 0, 0);
        }
        if (!(this.state.isFinalState() || this.isNil() || this.isInvalid())) {
            message = "The content of " + this.getContainingElementName() + " is incomplete. " + this.state.listAllowedElements();
            ve = new ValidationException(message);
            ve.setConstraintReference(1, "cvc-complex-type", "2.4");
            this.reportValidationError(ve, true, this.getContainingElementLocationId(), 1);
        }
        this.nextReceiver.endElement();
    }
}

