/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.validate;

import com.saxonica.schema.AttributeDecl;
import com.saxonica.schema.AttributeGroupDecl;
import com.saxonica.schema.AttributeUse;
import com.saxonica.schema.AttributeWildcard;
import com.saxonica.schema.ElementDecl;
import com.saxonica.schema.UserAtomicType;
import com.saxonica.schema.UserComplexType;
import com.saxonica.schema.Wildcard;
import com.saxonica.validate.ContentValidator;
import com.saxonica.validate.LaxValidator;
import com.saxonica.validate.SkipValidator;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.sort.IntHashMap;
import net.sf.saxon.expr.sort.IntIterator;
import net.sf.saxon.expr.sort.IntToIntMap;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.UnresolvedReferenceException;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.value.Whitespace;

public abstract class AttributeValidator
extends ContentValidator {
    private IntHashMap<AttributeUse> declaredAttributes;
    private IntToIntMap attributeCounterMap;
    private boolean[] found;
    private AttributeWildcard attributeWildcard = null;
    private int idAttributes = 0;
    ContentValidator childValidator;
    SimpleType latestAttributeType = null;

    public void setAttributeGroup(AttributeGroupDecl attributeGroup) throws ValidationException {
        try {
            if (attributeGroup != null) {
                this.attributeWildcard = attributeGroup.getAttributeWildcard(null);
                this.declaredAttributes = attributeGroup.getDeclaredAttributes();
                this.attributeCounterMap = attributeGroup.getCounterMap();
                this.found = new boolean[this.attributeCounterMap.size()];
            }
        }
        catch (UnresolvedReferenceException e) {
            throw new ValidationException(e);
        }
    }

    public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        int fingerprint = nameCode & 0xFFFFF;
        int annotation = typeCode;
        AttributeUse use = this.declaredAttributes == null ? null : this.declaredAttributes.get(fingerprint);
        AttributeDecl decl = null;
        if (use != null && !use.isProhibited()) {
            decl = (AttributeDecl)use.getTarget();
            int counter = this.attributeCounterMap.get(fingerprint);
            if (counter != this.attributeCounterMap.getDefaultValue()) {
                this.found[counter] = true;
            }
        } else {
            boolean implicitlyAllowed = false;
            String uri = this.getNamePool().getURI(nameCode);
            if (uri.equals("http://www.w3.org/2001/XMLSchema-instance")) {
                if (fingerprint == 641) {
                    implicitlyAllowed = true;
                } else if (fingerprint == 642) {
                    if (this.getNillability() == 2) {
                        String message = "The element is not nillable, so xsi:nil must not be present";
                        ValidationException ve = new ValidationException(message);
                        ve.setConstraintReference(1, "cvc-elt", "3.1");
                        this.reportValidationError(ve, true, locationId, 1);
                    }
                    String b = Whitespace.trim(((Object)value).toString());
                    if (this.getNillability() != 0 && (b.equals("true") || b.equals("1"))) {
                        this.nil = true;
                    }
                    implicitlyAllowed = true;
                } else if (fingerprint == 643) {
                    implicitlyAllowed = true;
                } else if (fingerprint == 644) {
                    implicitlyAllowed = true;
                }
            }
            if (!implicitlyAllowed) {
                ValidationException ve;
                String message;
                if (this.attributeWildcard != null) {
                    String process;
                    if (!this.attributeWildcard.getWildcard().matches(fingerprint, false, this.getConfiguration(), null)) {
                        String reason = this.attributeWildcard.getWildcard().reasonForNonMatch(fingerprint, false, this.getConfiguration());
                        message = "Attribute " + Err.wrap(this.getNamePool().getDisplayName(nameCode), 2) + " is not allowed on " + this.getContainingElementName() + ". " + reason;
                        ve = new ValidationException(message);
                        ve.setConstraintReference(1, "cvc-complex-type", "3.2.1");
                        this.reportValidationError(ve, false, locationId, 1);
                    }
                    if (!(process = this.attributeWildcard.getWildcard().getProcessContents()).equals("skip") && (decl = (AttributeDecl)this.getConfiguration().getAttributeDeclaration(nameCode & 0xFFFFF)) == null && process.equals("strict")) {
                        message = "The <xs:anyAttribute> that matches attribute " + Err.wrap(this.getNamePool().getDisplayName(nameCode), 2) + " requires strict validation, but no attribute declaration is available";
                        ve = new ValidationException(message);
                        ve.setConstraintReference(1, "cvc-wildcard", "2");
                        this.reportValidationError(ve, false, locationId, 1);
                    }
                } else {
                    String possibleNamespaceMessage = "";
                    if (this.declaredAttributes != null) {
                        Iterator ii = this.declaredAttributes.valueIterator();
                        while (ii.hasNext()) {
                            AttributeUse au = (AttributeUse)ii.next();
                            if (!this.getNamePool().getLocalName(au.getFingerprint()).equals(this.getNamePool().getLocalName(fingerprint))) continue;
                            String ns = this.getNamePool().getURI(au.getFingerprint());
                            if (ns.length() == 0) {
                                possibleNamespaceMessage = " (it would be allowed in no namespace)";
                                break;
                            }
                            possibleNamespaceMessage = " (it would be allowed in namespace " + ns + ")";
                            break;
                        }
                    }
                    message = "Attribute " + Err.wrap(this.getNamePool().getDisplayName(nameCode), 2) + " is not allowed on " + this.getContainingElementName() + possibleNamespaceMessage;
                    ve = new ValidationException(message);
                    ve.setConstraintReference(1, "cvc-complex-type", "3");
                    this.reportValidationError(ve, true, locationId, 1);
                }
            }
        }
        if (decl != null) {
            ValidationFailure err;
            SimpleType type;
            this.latestAttributeType = type = decl.getSimpleType();
            if (type.getBuiltInBaseType().getFingerprint() == 560) {
                ++this.idAttributes;
                if (this.idAttributes == 2 && this.getConfiguration().getXsdVersion() == 10) {
                    String message = "Element has more than one ID attribute";
                    ValidationException ve = new ValidationException(message);
                    ve.setConstraintReference(1, "cvc-complex-type", "5");
                    this.reportValidationError(ve, false, locationId, 1);
                }
            }
            if ((err = type.validateContent(value, this.getNamespaceResolver(), this.getConfiguration().getConversionRules())) != null) {
                err.setConstraintReference(1, "cvc-complex-type", "3");
                this.reportValidationError(err.makeException("Validating " + this.getNamePool().getDisplayName(this.getContainingElement()) + "/@" + this.getNamePool().getDisplayName(nameCode) + ": "), false, locationId, 1);
            } else {
                if (type instanceof UserAtomicType) {
                    value = ((UserAtomicType)type).getSharedInstance(((Object)value).toString());
                }
                annotation = type.getFingerprint();
                boolean matchesFixed = use != null ? use.testFixedValue(value, this.getNamespaceResolver()) : decl.testFixedValue(value, this.getNamespaceResolver());
                if (!matchesFixed) {
                    Value fixed = use != null ? use.getUnderlyingFixedValue() : decl.getFixedValue();
                    String message = "The actual value " + Err.wrap(value, 4) + " of attribute " + Err.wrap(this.getNamePool().getDisplayName(nameCode), 2) + " does not match the required fixed value " + (fixed instanceof AtomicValue ? Err.wrap(fixed.getStringValue(), 4) : "");
                    ValidationException ve = new ValidationException(message);
                    ve.setConstraintReference(1, "cvc-au", "0");
                    this.reportValidationError(ve, false, locationId, 1);
                }
            }
        }
        if (use != null && use.isInheritable() || use == null && decl != null && decl.isInheritable()) {
            this.getStartTagBuffer().notifyInheritableAttribute(nameCode, ((Object)value).toString(), locationId, properties);
        }
        this.nextReceiver.attribute(nameCode, annotation, value, locationId, properties);
    }

    public SimpleType getMostRecentAttributeType() {
        return this.latestAttributeType;
    }

    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        this.idAttributes = 0;
        if (this.nil) {
            String message = "No child elements are allowed when xsi:nil is true";
            ValidationException ve = new ValidationException(message);
            ve.setConstraintReference(1, "cvc-elt", "3.2.1");
            this.reportValidationError(ve, true, locationId, 2);
        }
        super.startElement(nameCode, typeCode, locationId, properties);
    }

    public final void startContent() throws XPathException {
        PipelineConfiguration pipe = this.getPipelineConfiguration();
        if (this.declaredAttributes != null) {
            IntIterator iter2 = this.declaredAttributes.keyIterator();
            while (iter2.hasNext()) {
                NamePool pool;
                String uri;
                ValidationFailure err;
                int key = iter2.next();
                int counter = this.attributeCounterMap.get(key);
                if (this.found[counter]) continue;
                AttributeUse use = this.declaredAttributes.get(key);
                if (use.isRequired()) {
                    String name = this.getNamePool().getClarkName(key);
                    String message = "Required attribute " + Err.wrap(name, 2) + " is missing";
                    ValidationException ve = new ValidationException(message);
                    ve.setConstraintReference(1, "cvc-complex-type", "4");
                    this.reportValidationError(ve, true, this.getContainingElementLocationId(), 1);
                    continue;
                }
                if (!pipe.isExpandAttributeDefaults()) continue;
                String value = use.getUnderlyingDefaultValue();
                if (value == null) {
                    Value fixed = use.getUnderlyingFixedValue();
                    String string = value = fixed == null ? null : fixed.getStringValue();
                }
                if (value == null) continue;
                if (use.getAttributeDeclaration().getSimpleType().isNamespaceSensitive() && (err = use.getAttributeDeclaration().getSimpleType().validateContent(value, this.getNamespaceResolver(), this.getConfiguration().getConversionRules())) != null) {
                    String message = "The namespace-sensitive default value is invalid in the namespace context where it is being used";
                    ValidationException ve = new ValidationException(message);
                    this.reportValidationError(ve, true, this.getContainingElementLocationId(), 1);
                }
                if ((uri = (pool = this.getNamePool()).getURI(key)).length() != 0) {
                    NamespaceResolver resolver = this.getNamespaceResolver();
                    Iterator<String> iter = resolver.iteratePrefixes();
                    String prefix = null;
                    while (iter.hasNext()) {
                        String p = iter.next();
                        if (p.length() == 0 || !uri.equals(resolver.getURIForPrefix(p, false))) continue;
                        prefix = p;
                        break;
                    }
                    if (prefix == null) {
                        String u;
                        prefix = pool.getPrefix(key);
                        if (prefix.length() == 0) {
                            prefix = pool.suggestPrefixForURI(uri);
                        }
                        while ((u = this.getNamespaceResolver().getURIForPrefix(prefix, false)) != null && !u.equals(uri)) {
                            prefix = prefix + "1";
                        }
                        int nscode = pool.allocateNamespaceCode(prefix, uri);
                        this.nextReceiver.namespace(nscode, 0);
                    }
                    key = pool.allocate(prefix, uri, pool.getLocalName(key));
                }
                this.nextReceiver.attribute(key, use.getAttributeDeclaration().getSimpleType().getFingerprint(), value, 0, 8);
            }
        }
        this.nextReceiver.startContent();
        if (this.isInvalid() && this.pendingMessages != null) {
            for (int m = 0; m < this.pendingMessages.size(); ++m) {
                this.nextReceiver.comment((CharSequence)this.pendingMessages.get(m), 0, 0);
            }
        }
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        if (this.nil && !Whitespace.isWhite(chars)) {
            String message = "No character content is allowed when xsi:nil is true";
            ValidationException ve = new ValidationException(message);
            ve.setConstraintReference(1, "cvc-elt", "3.2.1");
            this.reportValidationError(ve, true, locationId, 1);
        }
        this.nextReceiver.characters(chars, locationId, properties);
    }

    protected int processWildcardTerm(Wildcard card, int nameCode, int locationId) throws XPathException {
        UserComplexType containingType;
        int annotation;
        ElementDecl decl;
        int fingerprint = nameCode & 0xFFFFF;
        Configuration config = this.getConfiguration();
        PipelineConfiguration pipe = this.getPipelineConfiguration();
        NamePool pool = this.getNamePool();
        String mode = card.getProcessContents();
        if (mode.equals("strict")) {
            decl = (ElementDecl)this.getConfiguration().getElementDeclaration(fingerprint);
            if (decl == null) {
                if (this.xsiType == null) {
                    String message = "No element declaration found for element " + Err.wrap(pool.getDisplayName(nameCode), 1);
                    if (this.getContainingElement() != -1) {
                        message = "In content of " + this.getContainingElementName() + ": " + message;
                    }
                    ValidationException ve = new ValidationException(message);
                    ve.setConstraintReference(1, "cvc-wildcard", "2");
                    this.reportValidationError(ve, true, locationId, 2);
                    int annotation2 = 572;
                    return annotation2;
                }
                this.childValidator = AttributeValidator.makeValidator(null, nameCode, locationId, this.getStartTagBuffer(), this.xsiType, 0, pipe, this.getUnderlyingReceiver());
            } else {
                try {
                    this.childValidator = AttributeValidator.makeValidator(decl, nameCode, locationId, this.getStartTagBuffer(), this.xsiType, 0, pipe, this.getUnderlyingReceiver());
                }
                catch (ValidationException e) {
                    this.reportValidationError(e, true, locationId, 2);
                    this.childValidator = new SkipValidator();
                    this.childValidator.setUnderlyingReceiver(this.getUnderlyingReceiver());
                }
            }
            this.childValidator.setContainingElement(fingerprint, locationId);
            annotation = this.childValidator.getAnnotation();
        } else if (mode.equals("lax")) {
            decl = (ElementDecl)this.getConfiguration().getElementDeclaration(fingerprint);
            if (decl == null) {
                if (this.xsiType != null) {
                    this.childValidator = AttributeValidator.makeValidator(null, nameCode, locationId, this.getStartTagBuffer(), this.xsiType, 0, pipe, this.getUnderlyingReceiver());
                    annotation = this.childValidator.getAnnotation();
                } else {
                    this.childValidator = new LaxValidator();
                    this.childValidator.setPipelineConfiguration(this.getPipelineConfiguration());
                    this.childValidator.setContainingElement(fingerprint, locationId);
                    this.childValidator.setUnderlyingReceiver(this.getUnderlyingReceiver());
                    annotation = 572;
                }
            } else {
                try {
                    this.childValidator = AttributeValidator.makeValidator(decl, nameCode, locationId, this.getStartTagBuffer(), this.xsiType, 0, pipe, this.getUnderlyingReceiver());
                }
                catch (ValidationException e) {
                    String message = e.getMessage();
                    if (this.getContainingElement() != -1) {
                        message = "In content of " + this.getContainingElementName() + ": " + message;
                        ValidationException ve = new ValidationException(message);
                        ve.setConstraintReference(e);
                        this.reportValidationError(ve, true, locationId, 2);
                    } else {
                        this.reportValidationError(e, true, locationId, 2);
                    }
                    this.childValidator = new SkipValidator();
                }
                this.childValidator.setContainingElement(fingerprint, locationId);
                annotation = this.childValidator.getAnnotation();
            }
        } else {
            annotation = 572;
            this.childValidator = new SkipValidator();
        }
        if (!(this.childValidator instanceof SkipValidator) && (containingType = (UserComplexType)this.getSchemaType()).getLanguageVersion() != 10) {
            SchemaType contextDeterminedType = containingType.getContextDeterminedTypeForElement(fingerprint);
            SchemaType governingType = this.childValidator.getSchemaType();
            if (contextDeterminedType != null && governingType != null) {
                try {
                    config.checkTypeDerivationIsOK(governingType, contextDeterminedType, 0);
                }
                catch (SchemaException err) {
                    String message = "The governing type (" + governingType.getDescription() + ") of the " + Err.wrap(pool.getDisplayName(nameCode), 1) + " element which matches against a wildcard is not substitutable for the " + "context-determined type of the element particle named " + pool.getDisplayName(nameCode) + " within the content model of type " + containingType.getDescription() + ". " + err.getMessage();
                    ValidationException verr = new ValidationException(message);
                    verr.setConstraintReference(1, "cvc-complex-type", "5");
                    this.reportValidationError(verr, true, locationId, 2);
                }
            }
        }
        return annotation;
    }
}

