/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.validate;

import com.saxonica.schema.AllModelGroup;
import com.saxonica.schema.ElementDecl;
import com.saxonica.schema.ElementWildcard;
import com.saxonica.schema.ModelGroupParticle;
import com.saxonica.schema.UserComplexType;
import com.saxonica.schema.Wildcard;
import com.saxonica.validate.AnyTypeValidator;
import com.saxonica.validate.AttributeValidator;
import com.saxonica.validate.ContentValidator;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.sort.IntToIntMap;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.UnresolvedReferenceException;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.Whitespace;

public class AllElementValidator
extends AttributeValidator {
    private UserComplexType type;
    private AllModelGroup allGroup;
    boolean mixed;
    boolean empty = true;
    boolean emptiable;
    int[] counters;
    boolean ignoreIgnorable;
    boolean inOpenSuffix;

    protected AllElementValidator(UserComplexType type) throws ValidationException {
        try {
            this.type = type;
            this.mixed = type.isMixedContent();
            this.setAnnotation(type.getFingerprint());
            this.setAttributeGroup(type.getCombinedAttributeGroup());
            ModelGroupParticle allParticle = type.getAllCompositor();
            if (allParticle == null) {
                throw new IllegalStateException("Calling xs:all validator, cannot find xs:all compositor");
            }
            this.allGroup = (AllModelGroup)allParticle.getGroup();
            this.emptiable = allParticle.isEmptiable();
            this.counters = new int[this.allGroup.getMinima().length];
        }
        catch (UnresolvedReferenceException e) {
            throw new ValidationException(e);
        }
    }

    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        super.setPipelineConfiguration(pipe);
        this.ignoreIgnorable = this.getConfiguration().getStripsWhiteSpace() != 0;
    }

    public SchemaType getSchemaType() {
        return this.type;
    }

    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        boolean exhausted;
        int annotation = -1;
        int key = nameCode & 0xFFFFF;
        Configuration config = this.getConfiguration();
        NamePool pool = config.getNamePool();
        this.empty = false;
        IntToIntMap counterMap = this.allGroup.getCounterMap();
        int counter = counterMap.get(key);
        boolean foundElementParticle = counter != counterMap.getDefaultValue();
        boolean bl = exhausted = !foundElementParticle;
        if (foundElementParticle) {
            int n = counter;
            int n2 = this.counters[n] + 1;
            this.counters[n] = n2;
            int count = n2;
            int max = this.allGroup.getMaxima()[counter];
            boolean bl2 = exhausted = max != -1 && count > max;
        }
        if (exhausted) {
            Wildcard openWildcard;
            List<ElementWildcard> wildcards = this.allGroup.getWildcards();
            int w = 0;
            for (ElementWildcard wildcard : wildcards) {
                if (wildcard.getWildcard().matches(nameCode & 0xFFFFF, true, config, this.type)) {
                    if (this.inOpenSuffix) {
                        this.reportNotAllowedInSuffix(nameCode, locationId);
                    }
                    int n = w;
                    int n3 = this.counters[n] + 1;
                    this.counters[n] = n3;
                    int found = n3;
                    int wmax = wildcard.getMaxOccurs();
                    if (wmax != -1 && found > wmax) {
                        this.reportExcess(pool, nameCode, locationId, wmax);
                        this.counters[w] = Integer.MIN_VALUE;
                    }
                    annotation = this.processWildcardTerm(wildcard.getWildcard(), nameCode, locationId);
                    break;
                }
                ++w;
            }
            if (annotation == -1 && (openWildcard = this.type.getOpenContentWildcard()) != null && openWildcard.matches(nameCode & 0xFFFFF, true, config, this.type)) {
                annotation = this.processWildcardTerm(openWildcard, nameCode, locationId);
                boolean bl3 = this.inOpenSuffix = this.type.getOpenContentMode() == 3;
            }
            if (annotation == -1) {
                if (foundElementParticle) {
                    this.reportExcess(pool, nameCode, locationId, this.allGroup.getMaxima()[counter]);
                    this.counters[counter] = Integer.MIN_VALUE;
                } else {
                    String reason = "";
                    if (wildcards.size() == 1) {
                        Iterator<ElementWildcard> it = wildcards.iterator();
                        ElementWildcard wildcard = it.next();
                        reason = ". " + wildcard.getWildcard().reasonForNonMatch(nameCode & 0xFFFFF, true, config);
                    }
                    this.reportNotAllowed(pool, nameCode, locationId, reason);
                }
                this.childValidator = new AnyTypeValidator();
                annotation = 572;
            }
        } else {
            if (this.inOpenSuffix) {
                this.reportNotAllowedInSuffix(nameCode, locationId);
            }
            ElementDecl contextDeterminedDeclaration = (ElementDecl)this.allGroup.getDeclarationMap().get(key);
            try {
                this.childValidator = AllElementValidator.makeValidator(contextDeterminedDeclaration, nameCode, locationId, this.getStartTagBuffer(), this.xsiType, 0, this.getPipelineConfiguration(), this.getUnderlyingReceiver());
                this.childValidator.setContainingElement(nameCode & 0xFFFFF, locationId);
            }
            catch (ValidationException err) {
                this.reportValidationError(err, true, locationId, 2);
                this.childValidator = new AnyTypeValidator();
            }
            annotation = this.childValidator.getAnnotation();
        }
        super.startElement(nameCode, annotation, locationId, properties);
    }

    private void reportExcess(NamePool pool, int nameCode, int locationId, int maxAllowed) throws XPathException {
        ValidationException ve = new ValidationException("Element " + Err.wrap(pool.getDisplayName(nameCode), 1) + " exceeds limits defined in xs:all group: maxOccurs is " + maxAllowed);
        ve.setConstraintReference(1, "cvc-model-group", "1");
        this.reportValidationError(ve, true, locationId, 2);
    }

    private void reportNotAllowed(NamePool pool, int nameCode, int locationId, String reason) throws XPathException {
        ValidationException ve = new ValidationException("Element " + Err.wrap(pool.getDisplayName(nameCode), 1) + " is not allowed in the content of the xs:all group" + reason);
        ve.setConstraintReference(1, "cvc-complex-content", "1");
        this.reportValidationError(ve, true, locationId, 2);
    }

    private void reportNotAllowedInSuffix(int nameCode, int locationId) throws XPathException {
        ValidationException ve = new ValidationException("Element " + Err.wrap(this.getNamePool().getDisplayName(nameCode), 1) + " cannot appear in the content of the xs:all group after an element that matches open content with mode=suffix");
        ve.setConstraintReference(1, "cvc-complex-content", "2");
        this.reportValidationError(ve, true, locationId, 2);
    }

    protected ContentValidator getChildValidator() {
        if (this.getInvalidity() > 1) {
            return new AnyTypeValidator();
        }
        return this.childValidator;
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        if (this.mixed) {
            this.nextReceiver.characters(chars, locationId, properties);
            this.empty = false;
        } else if (Whitespace.isWhite(chars)) {
            if (!this.ignoreIgnorable) {
                this.nextReceiver.characters(chars, locationId, properties);
            }
        } else {
            ValidationException ve = new ValidationException("The content model for the type " + this.type.getDescription() + " does not allow character content");
            ve.setConstraintReference(1, "cvc-complex-type", "2.3");
            this.reportValidationError(ve, true, locationId, 1);
        }
    }

    public void endElement() throws XPathException {
        if (!(this.empty && this.emptiable || this.isNil())) {
            List<ElementWildcard> wildcards = this.allGroup.getWildcards();
            int[] minima = this.allGroup.getMinima();
            for (int i = wildcards.size(); i < this.counters.length; ++i) {
                String container;
                int found = this.counters[i];
                if (found >= minima[i] || found < 0) continue;
                String name = this.getConfiguration().getNamePool().getDisplayName(this.allGroup.getNameCodes()[i]);
                if (this.getContainingElement() == -1) {
                    if (this.type.isAnonymousType()) {
                        int nc = this.type.getContainingDeclarationName();
                        container = "element " + this.getNamePool().getDisplayName(nc);
                    } else {
                        container = "element of type " + this.type.getDescription();
                    }
                } else {
                    container = this.getContainingElementName();
                }
                String msg = "In content of " + container + ": " + "element " + Err.wrap(name, 1) + (found == 0 ? " is not present" : " has " + found + " occurrence" + (found == 1 ? "" : "s") + " but minOccurs is " + this.allGroup.getMinima()[i]);
                ValidationException ve = new ValidationException(msg);
                ve.setConstraintReference(1, "cvc-model-group", "3");
                this.reportValidationError(ve, true, this.getContainingElementLocationId(), 1);
            }
            int index = 0;
            for (ElementWildcard wildcard : wildcards) {
                int found;
                int min = wildcard.getMinOccurs();
                if ((found = this.counters[index++]) >= min || found < 0) continue;
                String msg = "In content of " + Err.wrap(this.getNamePool().getDisplayName(this.getContainingElement()), 1) + ": " + (found == 0 ? "No" : "Only " + found) + " child element" + (found == 1 ? "" : "s") + " found to match element wildcard with minOccurs=" + min;
                ValidationException ve = new ValidationException(msg);
                ve.setConstraintReference(1, "cvc-model-group", "3");
                this.reportValidationError(ve, true, this.getContainingElementLocationId(), 1);
            }
        }
        this.nextReceiver.endElement();
    }
}

