/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.update;

import com.saxonica.update.BasicUpdatingExpression;
import com.saxonica.update.PendingUpdateListImpl;
import com.saxonica.update.ReplaceValueAction;
import java.io.Serializable;
import java.util.Iterator;
import javax.xml.transform.TransformerException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.PairIterator;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.ValueOf;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.MutableNodeInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.query.QueryParser;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplaceValueExpression
extends BasicUpdatingExpression {
    private Expression targetExpression;
    private Expression replacement;

    public ReplaceValueExpression(Expression target, Expression replacement) {
        this.targetExpression = target;
        this.replacement = replacement;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return new PairIterator(this.targetExpression, this.replacement);
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.targetExpression = visitor.simplify(this.targetExpression);
        this.replacement = visitor.simplify(this.replacement);
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.targetExpression = visitor.typeCheck(this.targetExpression, contextItemType);
        this.replacement = visitor.typeCheck(this.replacement, contextItemType);
        this.replacement = QueryParser.stringify(this.replacement, true);
        this.replacement = new ValueOf(this.replacement, false, true);
        RoleLocator role0 = new RoleLocator(10, (Serializable)((Object)"replace"), 0);
        role0.setErrorCode("XUDY0027");
        this.targetExpression = TypeChecker.staticTypeCheck(this.targetExpression, SequenceType.NON_EMPTY_SEQUENCE, false, role0, visitor);
        role0 = new RoleLocator(10, (Serializable)((Object)"replace"), 0);
        role0.setErrorCode("XUTY0008");
        this.targetExpression = TypeChecker.staticTypeCheck(this.targetExpression, SequenceType.OPTIONAL_NODE, false, role0, visitor);
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.targetExpression = visitor.optimize(this.targetExpression, contextItemType);
        this.replacement = visitor.optimize(this.replacement, contextItemType);
        return this;
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        Expression exp = offer.accept(parent, this);
        if (exp != null) {
            return exp;
        }
        this.targetExpression = this.doPromotion(this.targetExpression, offer);
        this.replacement = this.doPromotion(this.replacement, offer);
        return this;
    }

    @Override
    public Expression copy() {
        return new ReplaceValueExpression(this.targetExpression.copy(), this.replacement.copy());
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("replaceValue");
        this.targetExpression.explain(out);
        this.replacement.explain(out);
        out.endElement();
    }

    @Override
    public void evaluatePendingUpdates(XPathContext context, PendingUpdateList pul) throws XPathException {
        Item newText = this.replacement.evaluateItem(context);
        String newString = newText == null ? "" : newText.getStringValue();
        NodeInfo targetNode = (NodeInfo)this.targetExpression.evaluateItem(context);
        TransformerException err = null;
        switch (targetNode.getNodeKind()) {
            case 8: {
                if (newString.indexOf("--") >= 0) {
                    err = new XPathException("Replacement comment value cannot contain two adjacent hyphens", "XQDY0072");
                    break;
                }
                if (!newString.endsWith("-")) break;
                err = new XPathException("Replacement comment value cannot end with a hyphen", "XQDY0072");
                break;
            }
            case 7: {
                if (newString.indexOf("?>") < 0) break;
                err = new XPathException("Replacement processing instruction value cannot contain '?>'", "XQDY0026");
                break;
            }
            case 9: {
                err = new XPathException("Cannot replace the value of a document node", "XUTY0008");
                break;
            }
            case 13: {
                err = new XPathException("Cannot replace the value of a namespace node", "XUTY0008");
                break;
            }
        }
        if (err != null) {
            err.setLocator(this);
            ((XPathException)err).setXPathContext(context);
            throw err;
        }
        if (!(targetNode instanceof MutableNodeInfo)) {
            XPathException er = new XPathException("Target node of replace expression is not updateable", "SXUP0081");
            er.setLocator(this);
            throw er;
        }
        try {
            ReplaceValueAction action = new ReplaceValueAction(newString, (MutableNodeInfo)targetNode);
            action.setOriginator(this);
            ((PendingUpdateListImpl)pul).add(action);
        }
        catch (XPathException e) {
            e.maybeSetLocation(this);
            e.maybeSetContext(context);
            throw e;
        }
    }
}

