/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.update;

import com.saxonica.update.BasicUpdatingExpression;
import com.saxonica.update.PendingUpdateListImpl;
import com.saxonica.update.ReplaceAttributeAction;
import com.saxonica.update.ReplaceNodeAction;
import com.saxonica.validate.SkipValidator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.PairIterator;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.MutableNodeInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.tree.util.AttributeCollectionImpl;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplaceNodeExpression
extends BasicUpdatingExpression {
    private Expression targetExpression;
    private Expression replacement;
    private int constructionMode;

    public ReplaceNodeExpression(Expression target, Expression replacement, int constructionMode) {
        this.targetExpression = target;
        this.replacement = replacement;
        this.constructionMode = constructionMode;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return new PairIterator(this.targetExpression, this.replacement);
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.targetExpression = visitor.simplify(this.targetExpression);
        this.replacement = visitor.simplify(this.replacement);
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.targetExpression = visitor.typeCheck(this.targetExpression, contextItemType);
        this.replacement = visitor.typeCheck(this.replacement, contextItemType);
        RoleLocator role0 = new RoleLocator(10, (Serializable)((Object)"replace"), 0);
        role0.setErrorCode("XUDY0027");
        this.targetExpression = TypeChecker.staticTypeCheck(this.targetExpression, SequenceType.NON_EMPTY_SEQUENCE, false, role0, visitor);
        role0 = new RoleLocator(10, (Serializable)((Object)"replace"), 0);
        role0.setErrorCode("XUTY0008");
        this.targetExpression = TypeChecker.staticTypeCheck(this.targetExpression, SequenceType.OPTIONAL_NODE, false, role0, visitor);
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.targetExpression = visitor.optimize(this.targetExpression, contextItemType);
        this.replacement = visitor.optimize(this.replacement, contextItemType);
        return this;
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        Expression exp = offer.accept(parent, this);
        if (exp != null) {
            return exp;
        }
        this.targetExpression = this.doPromotion(this.targetExpression, offer);
        this.replacement = this.doPromotion(this.replacement, offer);
        return this;
    }

    @Override
    public Expression copy() {
        return new ReplaceNodeExpression(this.targetExpression.copy(), this.replacement.copy(), this.constructionMode);
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("replaceNodes");
        this.targetExpression.explain(out);
        this.replacement.explain(out);
        out.endElement();
    }

    @Override
    public void evaluatePendingUpdates(XPathContext context, PendingUpdateList pul) throws XPathException {
        ArrayList<Item> content = new ArrayList<Item>();
        NodeInfo target = (NodeInfo)this.targetExpression.evaluateItem(context);
        if (target == null) {
            XPathException err = new XPathException("Target of replace expression must not be empty", "XUDY0027");
            err.setLocator(this);
            throw err;
        }
        int kind = target.getNodeKind();
        if (kind == 13) {
            XPathException err = new XPathException("Target of replace expression must not be a namespace node", "XUTY0008");
            err.setLocator(this);
            throw err;
        }
        if (kind == 9) {
            XPathException err = new XPathException("Target of replace expression must not be a document node", "XUTY0008");
            err.setLocator(this);
            throw err;
        }
        NodeInfo parent = target.getParent();
        if (parent == null) {
            XPathException err = new XPathException("Target node of replace expression has no parent", "XUDY0009");
            err.setLocator(this);
            throw err;
        }
        if (!(parent instanceof MutableNodeInfo)) {
            XPathException err = new XPathException("Target node of replace expression is not updateable", "SXUP0081");
            err.setLocator(this);
            throw err;
        }
        if (kind == 2) {
            Item item;
            SequenceIterator iter = this.replacement.iterate(context);
            AttributeCollectionImpl atts = new AttributeCollectionImpl(context.getConfiguration());
            while ((item = iter.next()) != null) {
                int typeCode;
                boolean isAttribute;
                boolean bl = isAttribute = item instanceof NodeInfo && ((NodeInfo)item).getNodeKind() == 2;
                if (!isAttribute) {
                    XPathException err = new XPathException("The replacement nodes for an attribute must all be attributes", "XUTY0011");
                    err.setLocator(this);
                    throw err;
                }
                NodeInfo att = (NodeInfo)item;
                int properties = 0;
                if (this.constructionMode == 4 || parent.getTypeAnnotation() == 630) {
                    typeCode = 631;
                } else {
                    typeCode = att.getTypeAnnotation();
                    if (att.isId() || att.getFingerprint() == 388) {
                        properties |= 0x800;
                    }
                    if (att.isIdref()) {
                        properties |= 0x1000;
                    }
                }
                atts.addAttribute(att.getNameCode(), typeCode, att.getStringValue(), 0L, properties);
            }
            ReplaceAttributeAction action = new ReplaceAttributeAction(parent, target, atts);
            action.setOriginator(this);
            ((PendingUpdateListImpl)pul).add(action);
        } else {
            Item item;
            SequenceIterator iter = this.replacement.iterate(context);
            while ((item = iter.next()) != null) {
                if (item instanceof NodeInfo && ((NodeInfo)item).getNodeKind() == 2) {
                    XPathException err = new XPathException("An attribute node cannot replace a node that is not itself an attribute", "XUTY0010");
                    err.setLocator(this);
                    throw err;
                }
                content.add(item);
            }
            if (content.isEmpty()) {
                try {
                    ReplaceNodeAction action = new ReplaceNodeAction(new NodeImpl[0], (MutableNodeInfo)target);
                    action.setOriginator(this);
                    ((PendingUpdateListImpl)pul).add(action);
                }
                catch (XPathException e) {
                    e.maybeSetLocation(this);
                    e.maybeSetContext(context);
                    throw e;
                }
            }
            XPathContextMinor c2 = context.newMinorContext();
            c2.setOrigin(this);
            Builder builder = ((MutableNodeInfo)parent).newBuilder();
            Controller controller = context.getController();
            builder.setLineNumbering(controller.getConfiguration().isLineNumbering());
            PipelineConfiguration pipe = controller.makePipelineConfiguration();
            pipe.setHostLanguage(this.getHostLanguage());
            builder.setPipelineConfiguration(pipe);
            Receiver r = builder;
            if (this.constructionMode == 4 || parent.getTypeAnnotation() == 630) {
                SkipValidator sv = new SkipValidator();
                sv.setPipelineConfiguration(pipe);
                sv.setUnderlyingReceiver(r);
                r = sv;
            }
            TreeReceiver out = new TreeReceiver(r);
            out.setPipelineConfiguration(pipe);
            out.open();
            out.startDocument(0);
            for (Item n : content) {
                out.append(n, 0, 2);
            }
            out.endDocument();
            out.close();
            DocumentInfo root = (DocumentInfo)builder.getCurrentRoot();
            AxisIterator top = root.iterateAxis((byte)3);
            Value extent = Value.asValue(SequenceExtent.makeSequenceExtent(top));
            int len = extent.getLength();
            NodeInfo[] array = new NodeInfo[len];
            for (int i = 0; i < len; ++i) {
                array[i] = (NodeInfo)extent.itemAt(i);
            }
            try {
                ReplaceNodeAction action = new ReplaceNodeAction(array, (MutableNodeInfo)target);
                action.setOriginator(this);
                ((PendingUpdateListImpl)pul).add(action);
            }
            catch (XPathException e) {
                e.maybeSetLocation(this);
                e.maybeSetContext(context);
                throw e;
            }
        }
    }
}

