/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.update;

import com.saxonica.update.DeleteAction;
import com.saxonica.update.InsertAction;
import com.saxonica.update.InsertAttributeAction;
import com.saxonica.update.PendingUpdateAction;
import com.saxonica.update.PutAction;
import com.saxonica.update.RenameAction;
import com.saxonica.update.ReplaceAttributeAction;
import com.saxonica.update.ReplaceNodeAction;
import com.saxonica.update.ReplaceValueAction;
import com.saxonica.validate.InSituValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.IntIterator;
import net.sf.saxon.expr.sort.IntToIntHashMap;
import net.sf.saxon.expr.sort.IntToIntMap;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.MutableDocumentInfo;
import net.sf.saxon.om.MutableNodeInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.util.NamespaceCodeIterator;
import net.sf.saxon.tree.util.Navigator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PendingUpdateListImpl
implements PendingUpdateList {
    private Configuration config;
    private List<PendingUpdateAction>[] lists = new ArrayList[7];
    private Set<MutableNodeInfo> affectedTrees = new HashSet<MutableNodeInfo>();
    private Set<NodeInfo> renamedNodes = new HashSet<NodeInfo>();
    private Set<NodeInfo> replacedNodes = new HashSet<NodeInfo>();
    private Set<NodeInfo> replacedValueNodes = new HashSet<NodeInfo>();
    private Map<NodeInfo, IntToIntMap> newNamespaceBindings = new HashMap<NodeInfo, IntToIntMap>();
    private Set<String> putURIs = new HashSet<String>();
    private Map<NodeInfo, List<PendingUpdateAction>> attributeActions = new HashMap<NodeInfo, List<PendingUpdateAction>>();

    public PendingUpdateListImpl(Configuration config) {
        this.config = config;
    }

    public void add(PendingUpdateAction action) throws XPathException {
        NamePool pool = this.config.getNamePool();
        int phase = action.getApplyPhase();
        if (this.lists[phase] == null) {
            this.lists[phase] = new ArrayList<PendingUpdateAction>(4);
        }
        if (action instanceof RenameAction) {
            boolean added = this.renamedNodes.add(action.getTargetNode());
            if (!added) {
                throw this.conflict("rename", "XUDY0015", action.getTargetNode());
            }
            int nameCode = ((RenameAction)action).getNewNameCode();
            int nsCode = pool.getNamespaceCode(nameCode);
            NodeInfo targetNode = action.getTargetNode();
            int nodeKind = targetNode.getNodeKind();
            if (nodeKind == 2) {
                NodeInfo parent = targetNode.getParent();
                this.addAttributeAction(parent, action);
                targetNode = parent;
            } else if (nodeKind == 7) {
                targetNode = null;
            }
            this.checkForNamespaceConflict(targetNode, nodeKind, nsCode, action);
            if (nodeKind != 2) {
                this.lists[phase].add(action);
            }
        } else if (action instanceof ReplaceNodeAction) {
            boolean added = this.replacedNodes.add(action.getTargetNode());
            if (!added) {
                throw this.conflict("replace", "XUDY0016", action.getTargetNode());
            }
            this.lists[phase].add(action);
        } else if (action instanceof ReplaceAttributeAction) {
            NodeInfo element = action.getTargetNode();
            NodeInfo oldAtt = ((ReplaceAttributeAction)action).getOldAttribute();
            boolean added = this.replacedNodes.add(oldAtt);
            if (!added) {
                throw this.conflict("replace", "XUDY0016", oldAtt);
            }
            this.addAttributeAction(element, action);
            int fp = oldAtt.getNameCode() & 0xFFFFF;
            AttributeCollection newAtts = ((ReplaceAttributeAction)action).getNewAttributes();
            for (int i = 0; i < newAtts.getLength(); ++i) {
                int newNameCode = newAtts.getNameCode(i);
                int newfp = newNameCode & 0xFFFFF;
                if (newfp == fp) continue;
                int nsCode = pool.getNamespaceCode(newNameCode);
                this.checkForNamespaceConflict(element, 2, nsCode, action);
            }
        } else if (action instanceof ReplaceValueAction) {
            boolean added = this.replacedValueNodes.add(action.getTargetNode());
            if (!added) {
                throw this.conflict("replace the value of", "XUDY0017", action.getTargetNode());
            }
            this.lists[phase].add(action);
        } else if (action instanceof InsertAttributeAction) {
            int nameCode = ((InsertAttributeAction)action).getNewNameCode();
            int nsCode = pool.getNamespaceCode(nameCode);
            NodeInfo targetNode = action.getTargetNode();
            this.addAttributeAction(targetNode, action);
            this.checkForNamespaceConflict(targetNode, 2, nsCode, action);
        } else if (action instanceof InsertAction) {
            this.lists[phase].add(action);
        } else if (action instanceof DeleteAction) {
            NodeInfo targetNode = action.getTargetNode();
            if (targetNode.getNodeKind() == 2) {
                NodeInfo parent = targetNode.getParent();
                if (parent != null) {
                    this.addAttributeAction(parent, action);
                }
            } else {
                this.lists[phase].add(action);
            }
        } else if (action instanceof PutAction) {
            this.lists[phase].add(action);
        }
    }

    private void addAttributeAction(NodeInfo element, PendingUpdateAction action) {
        List<PendingUpdateAction> actions = this.attributeActions.get(element);
        if (actions == null) {
            actions = new ArrayList<PendingUpdateAction>(2);
            this.attributeActions.put(element, actions);
        }
        actions.add(action);
    }

    @Override
    public void addPutAction(NodeInfo node, String uri, Expression originator) throws XPathException {
        if (!this.putURIs.add(uri)) {
            XPathException err1 = new XPathException("Cannot put() two documents to the same URI (" + uri + ")");
            err1.setErrorCode("XUDY0031");
            err1.setIsTypeError(false);
            err1.setLocator(originator);
            throw err1;
        }
        PutAction action = new PutAction(node, uri);
        action.setOriginator(originator);
        this.add(action);
    }

    private void checkForNamespaceConflict(NodeInfo targetNode, int nodeKind, int nsCode, PendingUpdateAction action) throws XPathException {
        if (targetNode != null && (nodeKind == 1 || (nsCode & 0xFFFF0000) != 0)) {
            int prefixCode = nsCode >> 16;
            int uriCode = nsCode & 0xFFFF;
            IntIterator iter = NamespaceCodeIterator.iterateNamespaces(targetNode);
            while (iter.hasNext()) {
                int oldNsCode = iter.next();
                if (oldNsCode >> 16 != prefixCode || (oldNsCode & 0xFFFF) == 0 || (oldNsCode & 0xFFFF) == uriCode) continue;
                XPathException err1 = new XPathException("An update action creates a namespace binding that conflicts with an existing namespace binding on the same target element");
                err1.setErrorCode("XUDY0023");
                err1.setIsTypeError(false);
                err1.setLocator(action.getOriginator());
                throw err1;
            }
            IntToIntMap nsmap = this.newNamespaceBindings.get(targetNode);
            if (nsmap == null) {
                nsmap = new IntToIntHashMap();
                this.newNamespaceBindings.put(targetNode, nsmap);
                nsmap.put(prefixCode, uriCode);
            } else {
                short existingUriCode = (short)nsmap.get(prefixCode);
                if (existingUriCode == -1) {
                    nsmap.put(prefixCode, uriCode);
                } else if (existingUriCode != uriCode) {
                    XPathException err1 = new XPathException("Two updates create conflicting namespace bindings on the same target node");
                    err1.setErrorCode("XUDY0024");
                    err1.setIsTypeError(false);
                    throw err1;
                }
            }
        }
    }

    private XPathException conflict(String action, String errorCode, NodeInfo node) {
        int kind = node.getNodeKind();
        String kindStr = NodeKindTest.toString(kind);
        if (kind == 1) {
            kindStr = Err.wrap(node.getDisplayName(), 1) + " " + kindStr;
        } else if (kind == 2) {
            kindStr = Err.wrap(node.getDisplayName(), 2) + " " + kindStr;
        }
        String msg = "Update conflict: two attempts to " + action + " the same " + kindStr + " node";
        if (node.getLineNumber() != -1) {
            msg = msg + ". Node at line " + node.getLineNumber() + " of " + node.getSystemId();
        }
        return new XPathException(msg, errorCode);
    }

    private void finalCheck() throws XPathException {
        for (Map.Entry<NodeInfo, List<PendingUpdateAction>> e : this.attributeActions.entrySet()) {
            MutableNodeInfo element = (MutableNodeInfo)e.getKey();
            this.checkAttributeActions(element, e.getValue());
            this.affectedTrees.add((MutableNodeInfo)element.getRoot());
        }
    }

    @Override
    public synchronized void apply(XPathContext context, int validationMode) throws XPathException {
        this.finalCheck();
        for (int phase = 0; phase < 6; ++phase) {
            List<PendingUpdateAction> list = this.lists[phase];
            if (list == null) continue;
            for (PendingUpdateAction action : list) {
                action.apply(context, this.affectedTrees);
            }
        }
        for (Map.Entry<NodeInfo, List<PendingUpdateAction>> e : this.attributeActions.entrySet()) {
            MutableNodeInfo mutableNodeInfo = (MutableNodeInfo)e.getKey();
            if (mutableNodeInfo.isDeleted()) continue;
            this.applyAttributeActions(mutableNodeInfo, e.getValue());
            this.affectedTrees.add((MutableNodeInfo)mutableNodeInfo.getRoot());
        }
        List<PendingUpdateAction> list = this.lists[6];
        if (list != null) {
            for (PendingUpdateAction pendingUpdateAction : list) {
                pendingUpdateAction.apply(context, this.affectedTrees);
            }
        }
        for (NodeInfo nodeInfo : this.affectedTrees) {
            if (!(nodeInfo instanceof MutableDocumentInfo)) continue;
            context.getController().getKeyManager().clearDocumentIndexes((DocumentInfo)nodeInfo);
            ((MutableDocumentInfo)((Object)nodeInfo)).resetIndexes();
        }
        if (validationMode == 1 || validationMode == 2) {
            for (MutableNodeInfo mutableNodeInfo : this.affectedTrees) {
                InSituValidator validator = new InSituValidator(mutableNodeInfo, validationMode);
                validator.validate();
            }
        }
    }

    private void checkAttributeActions(MutableNodeInfo element, List<PendingUpdateAction> actions) throws XPathException {
        NodeInfo att;
        IntToIntHashMap names = new IntToIntHashMap();
        names.setDefaultValue(0);
        AxisIterator attributes = element.iterateAxis((byte)2);
        while ((att = (NodeInfo)attributes.next()) != null) {
            names.put(att.getFingerprint(), 1);
        }
        for (PendingUpdateAction action : actions) {
            int count;
            if (action instanceof DeleteAction) {
                int fp = action.getTargetNode().getFingerprint();
                count = names.get(fp);
                if (count <= 0) continue;
                names.put(fp, count - 1);
                continue;
            }
            if (action instanceof RenameAction) {
                int fp = action.getTargetNode().getFingerprint();
                count = names.get(fp);
                if (count > 0) {
                    names.put(fp, count - 1);
                }
                fp = ((RenameAction)action).getNewNameCode() & 0xFFFFF;
                count = names.get(fp);
                names.put(fp, count + 1);
                continue;
            }
            if (action instanceof ReplaceAttributeAction) {
                NodeInfo target = ((ReplaceAttributeAction)action).getOldAttribute();
                int fp = target.getFingerprint();
                int count2 = names.get(fp);
                if (count2 > 0) {
                    names.put(fp, count2 - 1);
                }
                AttributeCollection newNodes = ((ReplaceAttributeAction)action).getNewAttributes();
                for (int i = 0; i < newNodes.getLength(); ++i) {
                    fp = newNodes.getNameCode(i) & 0xFFFFF;
                    count2 = names.get(fp);
                    names.put(fp, count2 + 1);
                }
                continue;
            }
            if (!(action instanceof InsertAttributeAction)) continue;
            int fp = ((InsertAttributeAction)action).getNewNameCode() & 0xFFFFF;
            count = names.get(fp);
            names.put(fp, count + 1);
        }
        IntIterator iter = names.keyIterator();
        while (iter.hasNext()) {
            int fp = iter.next();
            int count = names.get(fp);
            if (count <= 1) continue;
            throw new XPathException("After applying all updates, the element at " + Navigator.getPath(element) + " would have " + (count == 2 ? "two" : Integer.valueOf(count)) + " attributes named " + element.getNamePool().getClarkName(fp), "XUDY0021");
        }
    }

    private void applyAttributeActions(MutableNodeInfo element, List<PendingUpdateAction> actions) {
        for (PendingUpdateAction action : actions) {
            if (!(action instanceof DeleteAction)) continue;
            ((MutableNodeInfo)action.getTargetNode()).delete();
        }
        for (PendingUpdateAction action : actions) {
            if (!(action instanceof ReplaceAttributeAction)) continue;
            NodeInfo nodeInfo = ((ReplaceAttributeAction)action).getOldAttribute();
            ((MutableNodeInfo)nodeInfo).delete();
        }
        HashMap<MutableNodeInfo, Integer> pendingRenames = null;
        for (PendingUpdateAction pendingUpdateAction : actions) {
            if (!(pendingUpdateAction instanceof RenameAction)) continue;
            int nc = ((RenameAction)pendingUpdateAction).getNewNameCode();
            if (element.getAttributeValue(nc & 0xFFFFF) != null) {
                int temp = -1;
                for (int n = 1; n < 1024; ++n) {
                    if (element.getAttributeValue(n) != null) continue;
                    temp = n;
                    break;
                }
                if (temp == -1) {
                    throw new NamePool.NamePoolLimitException("Element has too many attributes: circular rename limit reached");
                }
                if (pendingRenames == null) {
                    pendingRenames = new HashMap<MutableNodeInfo, Integer>();
                }
                pendingRenames.put((MutableNodeInfo)pendingUpdateAction.getTargetNode(), nc);
                nc = temp;
            }
            ((MutableNodeInfo)pendingUpdateAction.getTargetNode()).rename(nc);
        }
        if (pendingRenames != null) {
            for (Map.Entry entry : pendingRenames.entrySet()) {
                ((MutableNodeInfo)entry.getKey()).rename((Integer)entry.getValue());
            }
        }
        for (PendingUpdateAction pendingUpdateAction : actions) {
            if (!(pendingUpdateAction instanceof ReplaceAttributeAction)) continue;
            AttributeCollection content = ((ReplaceAttributeAction)pendingUpdateAction).getNewAttributes();
            for (int i = 0; i < content.getLength(); ++i) {
                element.addAttribute(content.getNameCode(i), content.getTypeAnnotation(i), content.getValue(i), 0);
            }
        }
        for (PendingUpdateAction pendingUpdateAction : actions) {
            if (!(pendingUpdateAction instanceof InsertAttributeAction)) continue;
            InsertAttributeAction a = (InsertAttributeAction)pendingUpdateAction;
            element.addAttribute(a.getNewNameCode(), a.getNewTypeCode(), a.getNewStringValue(), 0);
        }
        element.removeTypeAnnotation();
    }

    @Override
    public Set getAffectedTrees() {
        return this.affectedTrees;
    }
}

