/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.update;

import com.saxonica.update.BasicUpdatingExpression;
import com.saxonica.update.InsertAction;
import com.saxonica.update.InsertAttributeAction;
import com.saxonica.update.PendingUpdateListImpl;
import com.saxonica.validate.SkipValidator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.PairIterator;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.Token;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.lib.Validation;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.MutableNodeInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsertExpression
extends BasicUpdatingExpression {
    private Expression sourceExpression;
    private Expression targetExpression;
    private int position;
    private int constructionMode;
    private boolean inheritNamespaces;

    public InsertExpression(Expression source, Expression target, int position, int constructionMode, boolean inherit) {
        this.sourceExpression = source;
        this.targetExpression = target;
        this.position = position;
        this.constructionMode = constructionMode;
        this.inheritNamespaces = inherit;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return new PairIterator(this.sourceExpression, this.targetExpression);
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.sourceExpression = visitor.simplify(this.sourceExpression);
        this.targetExpression = visitor.simplify(this.targetExpression);
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.sourceExpression = visitor.typeCheck(this.sourceExpression, contextItemType);
        this.targetExpression = visitor.typeCheck(this.targetExpression, contextItemType);
        RoleLocator role0 = new RoleLocator(10, (Serializable)((Object)"insert"), 1);
        role0.setErrorCode("XUDY0027");
        this.targetExpression = TypeChecker.staticTypeCheck(this.targetExpression, SequenceType.NON_EMPTY_SEQUENCE, false, role0, visitor);
        role0 = new RoleLocator(10, (Serializable)((Object)"insert"), 1);
        role0.setErrorCode(this.position == 118 || this.position == 119 ? "XUTY0006" : "XUTY0005");
        this.targetExpression = TypeChecker.staticTypeCheck(this.targetExpression, SequenceType.OPTIONAL_NODE, false, role0, visitor);
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.sourceExpression = visitor.optimize(this.sourceExpression, contextItemType);
        this.targetExpression = visitor.optimize(this.targetExpression, contextItemType);
        return this;
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        Expression exp = offer.accept(parent, this);
        if (exp != null) {
            return exp;
        }
        this.sourceExpression = this.doPromotion(this.sourceExpression, offer);
        this.targetExpression = this.doPromotion(this.targetExpression, offer);
        return this;
    }

    @Override
    public Expression copy() {
        return new InsertExpression(this.sourceExpression.copy(), this.targetExpression.copy(), this.position, this.constructionMode, this.inheritNamespaces);
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("insert");
        out.emitAttribute("position", Token.tokens[this.position]);
        out.emitAttribute("constructionMode", Validation.toString(this.constructionMode));
        this.sourceExpression.explain(out);
        this.targetExpression.explain(out);
        out.endElement();
    }

    @Override
    public void evaluatePendingUpdates(XPathContext context, PendingUpdateList pul) throws XPathException {
        Item item;
        NodeInfo parent;
        ArrayList<Item> content = new ArrayList<Item>();
        NodeInfo target = (NodeInfo)this.targetExpression.evaluateItem(context);
        if (target == null) {
            XPathException e = new XPathException("Target of insert expression must not be empty", "XUDY0027");
            e.setLocator(this);
            e.setXPathContext(context);
            throw e;
        }
        int kind = target.getNodeKind();
        if (this.position == 118 || this.position == 119) {
            if (kind != 1 && kind != 3 && kind != 8 && kind != 7) {
                XPathException e = new XPathException("When inserting before or after a node, that node must be an element, text, comment, or processing-instruction node", "XUTY0006");
                e.setLocator(this);
                e.setXPathContext(context);
                throw e;
            }
        } else if (kind != 1 && kind != 9) {
            XPathException e = new XPathException("When inserting into a target node, that node must be an element or document node", "XUTY0005");
            e.setLocator(this);
            e.setXPathContext(context);
            throw e;
        }
        NodeInfo nodeInfo = parent = this.position == 118 || this.position == 119 ? target.getParent() : target;
        if (parent == null) {
            XPathException err = new XPathException("When inserting before or after a node, that node must have a parent", "XUDY0029");
            err.setLocator(this);
            err.setXPathContext(context);
            throw err;
        }
        if (!(parent instanceof MutableNodeInfo)) {
            XPathException err = new XPathException("Target node of insert expression is not updateable", "SXUP0081");
            err.setLocator(this);
            err.setXPathContext(context);
            throw err;
        }
        boolean foundNonAttribute = false;
        SequenceIterator iter = this.sourceExpression.iterate(context);
        while ((item = iter.next()) != null) {
            if (item instanceof NodeInfo && ((NodeInfo)item).getNodeKind() == 2) {
                int typeCode;
                XPathException err;
                if (foundNonAttribute) {
                    err = new XPathException("Attributes must precede non-attributes in the list of nodes to be inserted", "XUTY0004");
                    err.setLocator(this);
                    err.setXPathContext(context);
                    throw err;
                }
                if (parent.getNodeKind() != 1) {
                    if (this.position == 118 || this.position == 119) {
                        err = new XPathException("When inserting an attribute before or after a node, that node must have a parent and the parent must be an element", "XUDY0030");
                        err.setLocator(this);
                        err.setXPathContext(context);
                        throw err;
                    }
                    err = new XPathException("When inserting an attribute into a target node, the target node must be an element", "XUTY0022");
                    err.setLocator(this);
                    err.setXPathContext(context);
                    throw err;
                }
                NodeInfo copiedNode = (NodeInfo)item;
                int properties = 0;
                if (this.constructionMode == 4 || parent.getTypeAnnotation() == 630) {
                    typeCode = 631;
                } else {
                    typeCode = copiedNode.getTypeAnnotation();
                    if (copiedNode.isId() || copiedNode.getFingerprint() == 388) {
                        properties |= 0x800;
                    }
                    if (copiedNode.isIdref()) {
                        properties |= 0x1000;
                    }
                }
                try {
                    InsertAttributeAction action = new InsertAttributeAction(parent, copiedNode.getNameCode(), typeCode, copiedNode.getStringValue(), properties);
                    action.setOriginator(this);
                    ((PendingUpdateListImpl)pul).add(action);
                    continue;
                }
                catch (XPathException e) {
                    e.maybeSetLocation(this);
                    e.maybeSetContext(context);
                    throw e;
                }
            }
            foundNonAttribute = true;
            content.add(item);
        }
        if (!content.isEmpty()) {
            XPathContextMinor c2 = context.newMinorContext();
            c2.setOrigin(this);
            Builder builder = ((MutableNodeInfo)parent).newBuilder();
            Controller controller = context.getController();
            builder.setLineNumbering(controller.getConfiguration().isLineNumbering());
            PipelineConfiguration pipe = controller.makePipelineConfiguration();
            pipe.setHostLanguage(this.getHostLanguage());
            builder.setPipelineConfiguration(pipe);
            Receiver r = builder;
            if (this.constructionMode == 4 || parent.getTypeAnnotation() == 630) {
                SkipValidator sv = new SkipValidator();
                sv.setPipelineConfiguration(pipe);
                sv.setUnderlyingReceiver(r);
                r = sv;
            }
            TreeReceiver out = new TreeReceiver(r);
            out.setPipelineConfiguration(pipe);
            out.open();
            out.startDocument(0);
            for (Item n : content) {
                out.append(n, 0, 2);
            }
            out.endDocument();
            out.close();
            DocumentInfo root = (DocumentInfo)builder.getCurrentRoot();
            AxisIterator top = root.iterateAxis((byte)3);
            Value extent = Value.asValue(SequenceExtent.makeSequenceExtent(top));
            int len = extent.getLength();
            NodeInfo[] array = new NodeInfo[len];
            for (int i = 0; i < len; ++i) {
                array[i] = (NodeInfo)extent.itemAt(i);
            }
            InsertAction action = new InsertAction(array, (MutableNodeInfo)target, this.position, this.inheritNamespaces);
            action.setOriginator(this);
            ((PendingUpdateListImpl)pul).add(action);
        }
    }
}

