/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.update;

import com.saxonica.update.PendingUpdateAction;
import java.util.Set;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.MutableNodeInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;

public class InsertAttributeAction
extends PendingUpdateAction {
    private NodeInfo element;
    int nameCode;
    int typeCode;
    CharSequence value;
    int properties;

    public InsertAttributeAction(NodeInfo element, int nameCode, int typeCode, CharSequence value, int properties) {
        this.element = element;
        this.nameCode = nameCode;
        this.typeCode = typeCode;
        this.value = value;
        this.properties = properties;
    }

    public void apply(XPathContext context, Set affectedRootSet) throws XPathException {
        if (!(this.element instanceof MutableNodeInfo)) {
            throw new XPathException("Attempting to update a non-updateable element");
        }
        if (this.element.getAttributeValue(this.nameCode & 0xFFFFF) != null) {
            throw new XPathException("Attempt to insert an attribute " + context.getNamePool().getDisplayName(this.nameCode) + " that is already present on the target element", "XUDY0021");
        }
        affectedRootSet.add(this.element.getRoot());
        ((MutableNodeInfo)this.element).addAttribute(this.nameCode, this.typeCode, this.value, this.properties);
        ((MutableNodeInfo)this.element).removeTypeAnnotation();
    }

    public NodeInfo getTargetNode() {
        return this.element;
    }

    public int getNewNameCode() {
        return this.nameCode;
    }

    public int getNewTypeCode() {
        return this.typeCode;
    }

    public CharSequence getNewStringValue() {
        return this.value;
    }

    public int getApplyPhase() {
        return 2;
    }
}

