/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.testdriver;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.config.ProfessionalConfiguration;
import com.saxonica.testdriver.CanonicalXML;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.Version;
import net.sf.saxon.expr.number.AbstractNumberer;
import net.sf.saxon.expr.number.Numberer_en;
import net.sf.saxon.lib.AugmentedSource;
import net.sf.saxon.lib.Numberer;
import net.sf.saxon.lib.StandardCollationURIResolver;
import net.sf.saxon.lib.StandardErrorListener;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.lib.Validation;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.option.local.Numberer_da;
import net.sf.saxon.option.local.Numberer_de;
import net.sf.saxon.option.local.Numberer_fr;
import net.sf.saxon.option.local.Numberer_frBE;
import net.sf.saxon.option.local.Numberer_he;
import net.sf.saxon.option.local.Numberer_it;
import net.sf.saxon.option.local.Numberer_nl;
import net.sf.saxon.option.local.Numberer_nlBE;
import net.sf.saxon.option.local.Numberer_sv;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.MessageListener;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SchemaValidator;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.ValidationMode;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import net.sf.saxon.trans.LocalizerFactory;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.DateTimeValue;
import org.w3c.tidy.Tidy;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XsltTestSuiteDriver {
    public static String RNS = "http://www.w3.org/2006/xslt20-test-result";
    String testSuiteDir;
    Processor factory;
    Processor sfactory;
    Processor pfactory;
    Processor factory11;
    Processor schemaAsFactory = new Processor(true);
    MyErrorListener errorListener;
    String overridingModel = null;
    String model = "tinytree";
    String initialMode = null;
    XMLReader parser;
    XMLReader resultParser;
    XMLReader fragmentParser;
    boolean usePull = false;
    boolean useTrace = false;
    boolean traceParam = false;
    HashMap sourceMap;
    boolean dotNetPlatform = false;
    Pattern testPattern = null;
    boolean showWarnings = false;
    boolean xml11 = false;
    boolean xsd11 = false;
    boolean timingOnly = false;
    boolean fastTestsOnly = false;
    XMLStreamWriter results;
    static HashSet noCacheTests = new HashSet(30);
    static HashSet<String> undetectedRecoverableErrors;
    static HashSet<String> unrecoverableErrors;
    static CanonicalXML canon;
    XsltExecutable xhtmlCanonizer;

    public static void main(String[] args) throws Exception {
        if (args.length == 0 || args[0].equals("-?")) {
            System.err.println("XsltTestSuiteDriver testsuiteDir [-c:catalog] [-fast] testName?");
        }
        System.err.println("Testing Saxon " + Version.getProductVersion());
        new XsltTestSuiteDriver().go(args);
    }

    private boolean isSlow(String testName) {
        return testName.startsWith("reclass") || testName.equals("re00985") || testName.equals("re00986") || testName.equals("re00987") || testName.equals("unicode010");
    }

    public void go(String[] args) throws SAXException, ParserConfigurationException {
        this.testSuiteDir = args[0];
        String catalogName = "catalog";
        HashSet<Object> exceptions = new HashSet<Object>();
        for (int i = 1; i < args.length; ++i) {
            if (args[i].equals("-w")) {
                this.showWarnings = true;
                continue;
            }
            if (args[i].equals("-t")) {
                this.timingOnly = true;
                continue;
            }
            if (args[i].startsWith("-c:")) {
                catalogName = args[i].substring(3);
                continue;
            }
            if (args[i].equals("-fast")) {
                this.fastTestsOnly = true;
                continue;
            }
            this.testPattern = Pattern.compile(args[i]);
        }
        try {
            XdmNode catalog;
            NamePool pool = new NamePool();
            Configuration config = new Configuration();
            this.parser = config.getSourceParser();
            if (!this.parser.getFeature("http://xml.org/sax/features/xml-1.1")) {
                System.err.println("Warning: XML parser does not support XML 1.1 - " + this.parser.getClass());
            }
            this.resultParser = config.getSourceParser();
            this.resultParser.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) {
                    return new InputSource(new StringReader(""));
                }
            });
            this.fragmentParser = config.getSourceParser();
            EnterpriseConfiguration sconfig = new EnterpriseConfiguration();
            sconfig.setExtensionElementNamespace("http://saxon.sf.net/sql", "net.sf.saxon.option.sql.SQLElementFactory");
            ProfessionalConfiguration pconfig = new ProfessionalConfiguration();
            pconfig.setExtensionElementNamespace("http://saxon.sf.net/sql", "net.sf.saxon.option.sql.SQLElementFactory");
            EnterpriseConfiguration sasconfig = new EnterpriseConfiguration();
            Configuration config11 = new Configuration();
            config11.setXMLVersion(11);
            config.setNamePool(pool);
            sconfig.setNamePool(pool);
            pconfig.setNamePool(pool);
            config11.setNamePool(pool);
            this.sfactory = new Processor(sconfig);
            this.pfactory = new Processor(pconfig);
            this.factory = new Processor(config);
            this.factory11 = new Processor(config11);
            this.schemaAsFactory = new Processor(sasconfig);
            this.setLocalizers(config);
            this.errorListener = new MyErrorListener();
            String testURI = "http://www.w3.org/2005/05/xslt20-test-catalog";
            DocumentBuilder builder = this.factory.newDocumentBuilder();
            XdmNode exceptionsDoc = builder.build(new StreamSource(new File(this.testSuiteDir + '/' + this.getResultDirectoryName() + "/exceptions.xml")));
            XPathCompiler xpath = this.factory.newXPathCompiler();
            xpath.declareNamespace("t", testURI);
            xpath.setCaching(true);
            for (XdmItem item : xpath.evaluate("//t:testcase/@name", exceptionsDoc)) {
                String name = item.getStringValue();
                StringTokenizer tok = new StringTokenizer(name);
                while (tok.hasMoreElements()) {
                    exceptions.add(tok.nextElement());
                }
            }
            String date = DateTimeValue.getCurrentDateTime(null).getStringValue().substring(0, 10);
            if (catalogName.endsWith(".entity")) {
                String uri = "file:///" + System.getProperty("user.dir").replace('\\', '/') + "/cat/" + catalogName;
                String wrapper = "<!DOCTYPE testcases [\n<!ENTITY e SYSTEM '" + uri + "'>" + "]>\n" + "<testcases xmlns=\"http://www.w3.org/2005/05/xslt20-test-catalog\" SourceOffsetPath=\"./\"\n" + "           ResultOffsetPath=\"ExpectedTestResults/\"\n" + "           InputOffsetPath=\"TestInputs/\"\n" + "           testSuiteVersion=\"1.1.0\">" + "&e;</testcases>";
                StringReader sr = new StringReader(wrapper);
                StreamSource ss = new StreamSource(sr, System.getProperty("user.dir"));
                catalog = builder.build(ss);
            } else {
                catalog = builder.build(new StreamSource(new File(this.testSuiteDir + "/" + catalogName + ".xml")));
            }
            this.writeResultFilePreamble(config, date);
            long startTime = new Date().getTime();
            for (XdmItem item : xpath.evaluate("//t:testcase", catalog)) {
                boolean success;
                String outFileName;
                XdmNode validation;
                this.xml11 = false;
                this.xsd11 = false;
                XdmNode testCase = (XdmNode)item;
                boolean useAssociated = false;
                String testName = xpath.evaluateSingle("t:name", testCase).getStringValue();
                if (this.testPattern != null && !this.testPattern.matcher(testName).matches() || exceptions.contains(testName) || this.isExcluded(testName) || this.fastTestsOnly && this.isSlow(testName)) continue;
                System.err.println("Test " + testName);
                XdmNode testInput = (XdmNode)xpath.evaluateSingle("t:input", testCase);
                XdmNode stylesheet = (XdmNode)xpath.evaluateSingle("t:stylesheet", testInput);
                String absXSLName = null;
                if (stylesheet == null) {
                    useAssociated = true;
                } else {
                    String fileName = XsltTestSuiteDriver.getAttribute(stylesheet, "file");
                    File xslFile = new File(new File(this.testSuiteDir, "TestInputs"), fileName);
                    absXSLName = xslFile.getCanonicalPath();
                }
                XdmNode sourceDocument = (XdmNode)xpath.evaluateSingle("t:source-document[@role='principal']", testInput);
                String absXMLName = null;
                if (sourceDocument != null) {
                    String fileName = XsltTestSuiteDriver.getAttribute(sourceDocument, "file");
                    File xslFile = new File(new File(this.testSuiteDir, "/TestInputs/"), fileName);
                    absXMLName = xslFile.getCanonicalPath();
                }
                boolean schemaAware = false;
                String edition = "HE";
                boolean recoverRecoverable = true;
                boolean backwardsCompatibility = true;
                boolean supportsDOE = true;
                boolean inapplicable = false;
                boolean streaming = false;
                HashSet<String> versionSet = new HashSet<String>();
                for (XdmItem discretionaryItems : xpath.evaluate("t:discretionary-items", testCase)) {
                    String behavior;
                    String featureName;
                    for (XdmItem feature : xpath.evaluate("t:discretionary-feature", discretionaryItems)) {
                        featureName = XsltTestSuiteDriver.getAttribute(feature, "name");
                        behavior = XsltTestSuiteDriver.getAttribute(feature, "behavior");
                        if ("schema_aware".equals(featureName)) {
                            schemaAware = "on".equals(behavior);
                            continue;
                        }
                        if ("streaming".equals(featureName)) {
                            if (!"on".equals(behavior)) continue;
                            edition = "EE";
                            streaming = true;
                            continue;
                        }
                        if ("Saxon-PE".equals(featureName)) {
                            if (!"on".equals(behavior)) continue;
                            edition = "PE";
                            continue;
                        }
                        if ("Saxon-EE".equals(featureName)) {
                            if (!"on".equals(behavior)) continue;
                            edition = "EE";
                            continue;
                        }
                        if ("XML_1.1".equals(featureName)) {
                            this.xml11 = "on".equals(behavior);
                            continue;
                        }
                        if ("XSD_1.1".equals(featureName)) {
                            this.xsd11 = "on".equals(behavior);
                            continue;
                        }
                        if ("backwards_compatibility".equals(featureName)) {
                            backwardsCompatibility = "on".equals(behavior);
                            continue;
                        }
                        if (!"disabling_output_escaping".equals(featureName)) continue;
                        supportsDOE = "on".equals(behavior);
                    }
                    for (XdmItem choice : xpath.evaluate("t:discretionary-choice", discretionaryItems)) {
                        featureName = XsltTestSuiteDriver.getAttribute(choice, "name");
                        behavior = XsltTestSuiteDriver.getAttribute(choice, "behavior");
                        if ("error".equals(behavior)) {
                            recoverRecoverable = false;
                        }
                        if (unrecoverableErrors.contains(featureName) && "recovery".equals(behavior)) {
                            inapplicable = true;
                        }
                        if (!undetectedRecoverableErrors.contains(featureName) || !"error".equals(behavior)) continue;
                        inapplicable = true;
                    }
                    for (XdmItem spec : xpath.evaluate("t:discretionary-version/@spec", discretionaryItems)) {
                        versionSet.add(spec.getStringValue());
                    }
                }
                if (!backwardsCompatibility) {
                    this.writeTestcaseElement(testName, "not run", "requires backwards-compatibility=off");
                    continue;
                }
                if (!supportsDOE) {
                    this.writeTestcaseElement(testName, "not run", "requires disable-output-escaping=off");
                    continue;
                }
                if (inapplicable) {
                    this.writeTestcaseElement(testName, "not run", "unsupported recoverable error choice");
                    continue;
                }
                QName initialMode = XsltTestSuiteDriver.getQNameAttribute(xpath, testInput, "t:initial-mode/@qname");
                QName initialTemplate = XsltTestSuiteDriver.getQNameAttribute(xpath, testInput, "t:entry-named-template/@qname");
                XdmNode initialContextNode = (XdmNode)xpath.evaluateSingle("t:initial-context-node", testInput);
                String initialContextPath = null;
                if (initialContextNode != null) {
                    initialContextPath = initialContextNode.getStringValue();
                }
                String validationMode = (validation = (XdmNode)xpath.evaluateSingle("t:validation", testInput)) == null ? null : XsltTestSuiteDriver.getAttribute(validation, "mode");
                HashMap<String, String> params = new HashMap<String, String>();
                for (XdmItem param : xpath.evaluate("t:stylesheet-parameters/t:param", testInput)) {
                    String name = XsltTestSuiteDriver.getAttribute(param, "qname");
                    String value = param.getStringValue();
                    params.put(name, value);
                }
                for (XdmItem schema : xpath.evaluate("t:schema", testInput)) {
                    String role = XsltTestSuiteDriver.getAttribute(schema, "role");
                    if (!"source-validator".equals(role) && !"source-reference".equals(role)) continue;
                    validationMode = "strict";
                }
                XdmNode testOutput = (XdmNode)xpath.evaluateSingle("t:output", testCase);
                XdmNode resultDocument = (XdmNode)xpath.evaluateSingle("t:result-document", testOutput);
                String refFileName = null;
                String comparator = "xml";
                boolean ignoreIndentation = false;
                if (resultDocument != null) {
                    String outFileAtt = XsltTestSuiteDriver.getAttribute(resultDocument, "file");
                    int slash = outFileAtt.indexOf(47);
                    String outDir = outFileAtt;
                    if (slash >= 0) {
                        outDir = outFileAtt.substring(0, slash);
                    }
                    File refFile = new File(new File(this.testSuiteDir, "/ExpectedTestResults/"), outFileAtt);
                    refFileName = refFile.getCanonicalPath();
                    File outFile = new File(new File(new File(this.testSuiteDir, this.getResultDirectoryName()), outDir), testName + ".out");
                    outFileName = outFile.getCanonicalPath();
                    comparator = XsltTestSuiteDriver.getAttribute(resultDocument, "type");
                    ignoreIndentation = "yes".equals(XsltTestSuiteDriver.getAttribute(resultDocument, "indent-ignore"));
                } else {
                    File outFile = new File(new File(this.testSuiteDir, this.getResultDirectoryName()), "temp.out");
                    outFileName = outFile.getCanonicalPath();
                }
                HashSet<String> expectedErrors = new HashSet<String>(4);
                for (XdmItem errorId : xpath.evaluate("t:error/@error-id", testOutput)) {
                    expectedErrors.add(errorId.getStringValue());
                }
                ArrayList<String> expectedMessages = new ArrayList<String>();
                for (XdmItem msg : xpath.evaluate("t:xsl-message", testOutput)) {
                    expectedMessages.add(msg.getStringValue());
                }
                this.errorListener.errorCodes.clear();
                XdmItem optimizationAssertion = xpath.evaluateSingle("t:optimization/@assert", testCase);
                String assertion = optimizationAssertion == null ? null : optimizationAssertion.getStringValue();
                ArrayList<String> actualMessages = new ArrayList<String>();
                try {
                    this.runXSLT(testName, absXMLName, absXSLName, initialMode, initialTemplate, outFileName, params, initialContextPath, useAssociated, schemaAware, streaming, edition, validationMode, recoverRecoverable, assertion, versionSet, actualMessages);
                    success = true;
                    if (!expectedErrors.isEmpty() && resultDocument == null && !this.timingOnly) {
                        System.err.println("Test failed. Expected error " + this.listErrors(expectedErrors) + ", got success");
                        success = false;
                        this.writeTestcaseElement(testName, "differ", "Expected error " + this.listErrors(expectedErrors) + ", got success");
                    }
                }
                catch (SaxonApiException e) {
                    if (this.timingOnly) continue;
                    Set<String> actual = this.errorListener.errorCodes;
                    QName code = e.getErrorCode();
                    if (code != null) {
                        actual.add(code.getLocalName());
                    }
                    if (XsltTestSuiteDriver.intersects(expectedErrors, actual)) {
                        System.err.println("Test succeeded (" + this.listErrors(actual) + ')');
                        this.writeTestcaseElement(testName, "full", "Error " + this.listErrors(actual) + " as expected");
                        continue;
                    }
                    if (!expectedErrors.isEmpty()) {
                        System.err.println("Test succeeded (??) (expected " + this.listErrors(expectedErrors) + ", got " + this.listErrors(actual) + ')');
                        this.writeTestcaseElement(testName, "different-error", "Expected " + this.listErrors(expectedErrors) + " got " + this.listErrors(actual));
                        continue;
                    }
                    System.err.println("Test failed. Expected success, got " + this.listErrors(actual));
                    this.writeTestcaseElement(testName, "differ", "Expected success, got " + this.listErrors(actual));
                    continue;
                }
                catch (Exception e2) {
                    this.writeTestcaseElement(testName, "differ", "Crashed (" + e2.getMessage() + ") - see stack trace");
                    success = false;
                    e2.printStackTrace();
                }
                if (!success || this.timingOnly) continue;
                boolean same = this.compare(outFileName, refFileName, comparator, ignoreIndentation);
                if (same) {
                    String messageComment = this.compareMessages(expectedMessages, actualMessages);
                    this.writeTestcaseElement(testName, "full", messageComment == null ? null : "Message output differs: " + messageComment);
                    continue;
                }
                this.writeTestcaseElement(testName, "differ", null);
            }
            this.writeResultFilePostamble();
            System.err.println("Time: " + (new Date().getTime() - startTime) + " ms");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean intersects(Set<String> a, Set<String> b) {
        for (String s : b) {
            if (!a.contains(s)) continue;
            return true;
        }
        return false;
    }

    private void writeResultFilePreamble(Configuration config, String date) throws IOException, XPathException, XMLStreamException {
        BufferedWriter resultWriter = new BufferedWriter(new FileWriter(new File(this.testSuiteDir + "/SaxonResults/results" + Version.getProductVersion() + ".xml")));
        Properties resultProperties = new Properties();
        resultProperties.setProperty("method", "xml");
        resultProperties.setProperty("indent", "yes");
        resultProperties.setProperty("{http://saxon.sf.net/}line-length", "120");
        this.results = config.getSerializerFactory().getXMLStreamWriter(new StreamResult(resultWriter), resultProperties);
        this.results.writeStartElement("test-suite-result");
        this.results.writeDefaultNamespace(RNS);
        this.results.writeStartElement("implementation");
        this.results.writeAttribute("name", "Saxon-EE");
        this.results.writeAttribute("version", Version.getProductVersion());
        this.results.writeAttribute("anonymous-result-column", "false");
        this.results.writeEmptyElement("organization");
        this.results.writeAttribute("name", "http://www.saxonica.com/");
        this.results.writeAttribute("anonymous", "false");
        this.results.writeEmptyElement("submitter");
        this.results.writeAttribute("name", "Michael Kay");
        this.results.writeAttribute("email", "mike@saxonica.com");
        this.outputDiscretionaryItems();
        this.results.writeEndElement();
        this.results.writeEmptyElement("test-run");
        this.results.writeAttribute("dateRun", date);
        this.results.writeAttribute("testsuiteVersion", "1.1.0");
    }

    private void writeTestcaseElement(String name, String result, String comment) throws XMLStreamException {
        this.results.writeEmptyElement("testcase");
        this.results.writeAttribute("name", name);
        this.results.writeAttribute("result", result);
        if (comment != null) {
            this.results.writeAttribute("comment", comment);
        }
    }

    private void writeResultFilePostamble() throws XMLStreamException {
        this.results.writeEndElement();
        this.results.close();
    }

    private static String getAttribute(XdmItem element, String attributeName) throws SaxonApiException {
        return ((XdmNode)element).getAttributeValue(new QName(attributeName));
    }

    private static QName getQNameAttribute(XPathCompiler xpath, XdmItem contextItem, String attributePath) throws SaxonApiException {
        String exp = "for $att in " + attributePath + " return if (contains($att, ':')) then resolve-QName($att, $att/..) else QName('', $att)";
        XdmAtomicValue qname = (XdmAtomicValue)xpath.evaluateSingle(exp, contextItem);
        return qname == null ? null : (QName)qname.getValue();
    }

    private String listErrors(Set<String> errors) {
        if (errors.isEmpty()) {
            return "{}";
        }
        FastStringBuffer sb = new FastStringBuffer(40);
        boolean first = true;
        Iterator<String> iter = errors.iterator();
        while (iter.hasNext()) {
            if (!first) {
                sb.append('|');
            }
            first = false;
            sb.append(iter.next());
        }
        return sb.toString();
    }

    protected String getResultDirectoryName() {
        return "SaxonResults";
    }

    protected boolean isExcluded(String testName) {
        return false;
    }

    protected void runXSLT(String testName, String xml, String xsl, QName initialMode, QName initialTemplate, String out, HashMap params, String initialContextPath, boolean useAssociated, boolean schemaAware, boolean streaming, String edition, String validationMode, boolean recoverRecoverable, String assertion, Set<String> versionSet, final List messages) throws SaxonApiException {
        Source styleSource;
        Processor f;
        Serializer sr = new Serializer(new File(out));
        if (noCacheTests.contains(testName) || testName.startsWith("schemaas20") || testName.startsWith("striptype20") || testName.startsWith("notation20")) {
            EnterpriseConfiguration sconfig = new EnterpriseConfiguration();
            sconfig.setNamePool(this.factory.getUnderlyingConfiguration().getNamePool());
            f = new Processor(sconfig);
            f.setConfigurationProperty("http://saxon.sf.net/feature/xsltSchemaAware", true);
        } else if (schemaAware || edition.equals("EE") || versionSet.contains("XSLT30")) {
            f = this.sfactory;
            f.setConfigurationProperty("http://saxon.sf.net/feature/xsltSchemaAware", true);
        } else {
            f = edition.equals("PE") ? this.pfactory : (this.xml11 ? this.factory11 : this.factory);
        }
        XdmNode sourceNode = null;
        Configuration config = f.getUnderlyingConfiguration();
        config.setOptimizerTracing(false);
        if (validationMode == null) {
            config.setSchemaValidationMode(4);
        } else {
            config.setSchemaValidationMode(Validation.getCode(validationMode));
        }
        config.setConfigurationProperty("http://saxon.sf.net/feature/xsd-version", this.xsd11 ? "1.1" : "1.0");
        config.setCollationURIResolver(new StandardCollationURIResolver(){

            public StringCollator resolve(String uri, String base, Configuration config) {
                if ("http://www.w3.org/xslts/collation/caseblind".equals(uri)) {
                    return super.resolve("http://saxon.sf.net/collation?ignore-case=yes", "", config);
                }
                return super.resolve(uri, base, config);
            }
        });
        if (useAssociated) {
            sourceNode = this.buildSourceDoc(xml, initialContextPath, validationMode, f, null);
            try {
                styleSource = PreparedStylesheet.getAssociatedStylesheet(config, sourceNode.asSource(), null, null, null);
            }
            catch (TransformerConfigurationException e) {
                throw new SaxonApiException(e);
            }
        } else {
            styleSource = new StreamSource(new File(xsl));
        }
        XsltCompiler compiler = f.newXsltCompiler();
        compiler.setErrorListener(this.errorListener);
        if (versionSet.contains("XSLT30")) {
            compiler.setXsltLanguageVersion("3.0");
        } else {
            compiler.setXsltLanguageVersion("2.0");
        }
        XsltExecutable sheet = compiler.compile(styleSource);
        if (assertion != null) {
            XdmDestination builder = new XdmDestination();
            sheet.explain(builder);
            builder.close();
            XdmNode expressionTree = builder.getXdmNode();
            XPathCompiler xpe = f.newXPathCompiler();
            XPathSelector exp = xpe.compile(assertion).load();
            exp.setContextItem(expressionTree);
            XdmAtomicValue bv = (XdmAtomicValue)exp.evaluateSingle();
            if (!bv.getBooleanValue()) {
                System.err.println("** Optimization assertion failed");
                System.err.println(expressionTree.toString());
                throw new SaxonApiException("Expected optimization not performed");
            }
        }
        if (xml != null && sourceNode == null && !streaming) {
            sourceNode = this.buildSourceDoc(xml, initialContextPath, validationMode, f, sheet);
        }
        XsltTransformer inst = sheet.load();
        if (initialMode != null) {
            inst.setInitialMode(initialMode);
        }
        if (initialTemplate != null) {
            inst.setInitialTemplate(initialTemplate);
        }
        if (params != null) {
            for (String name : params.keySet()) {
                String value = (String)params.get(name);
                inst.setParameter(new QName(name), new XdmAtomicValue(value));
            }
            if (testName.startsWith("reclass")) {
                inst.setParameter(new QName("result-dirs"), new XdmAtomicValue("3.1"));
            }
        }
        if ("strict".equals(validationMode)) {
            inst.setSchemaValidationMode(ValidationMode.STRICT);
        } else {
            inst.setSchemaValidationMode(ValidationMode.STRIP);
        }
        inst.setURIResolver(this.factory.getUnderlyingConfiguration().getURIResolver());
        inst.setErrorListener(this.errorListener);
        inst.getUnderlyingController().setRecoveryPolicy(recoverRecoverable ? 0 : 2);
        inst.setMessageListener(new MessageListener(){

            public void message(XdmNode content, boolean terminate, SourceLocator locator) {
                messages.add(content.toString());
            }
        });
        if (streaming && xml != null) {
            inst.setSource(new StreamSource(xml));
        }
        if (sourceNode != null) {
            inst.setInitialContextNode(sourceNode);
            inst.getUnderlyingController().setStripSourceTrees(false);
        }
        inst.setDestination(sr);
        inst.transform();
    }

    private XdmNode buildSourceDoc(String xml, String initialContextPath, String validationMode, Processor f, XsltExecutable exec) throws SaxonApiException {
        DocumentBuilder builder = f.newDocumentBuilder();
        if (exec != null) {
            builder.setWhitespaceStrippingPolicy(exec.getWhitespaceStrippingPolicy());
        }
        StreamSource ss = new StreamSource(new File(xml));
        if ("strict".equals(validationMode)) {
            SchemaValidator sv = f.getSchemaManager().newSchemaValidator();
            sv.setLax(false);
            builder.setSchemaValidator(sv);
        }
        XdmNode sourceNode = builder.build(ss);
        if (initialContextPath != null) {
            XPathExecutable expr = f.newXPathCompiler().compile(initialContextPath);
            XPathSelector xs = expr.load();
            xs.setContextItem(sourceNode);
            sourceNode = (XdmNode)xs.evaluateSingle();
        }
        return sourceNode;
    }

    protected Source buildSource(String xml, String validationMode) {
        Source ss = new StreamSource(new File(xml));
        if ("strict".equals(validationMode)) {
            ss = AugmentedSource.makeAugmentedSource(ss);
            ((AugmentedSource)ss).setSchemaValidationMode(1);
        }
        return ss;
    }

    private boolean compare(String outfile, String reffile, String comparator, boolean ignoreIndentation) {
        if (reffile == null) {
            System.err.println("*** No reference results available");
            return false;
        }
        File outfileFile = new File(outfile);
        File reffileFile = new File(reffile);
        if (!reffileFile.exists()) {
            System.err.println("*** No reference results available in " + reffileFile);
            return false;
        }
        String refResult = null;
        String actResult = null;
        try {
            boolean b;
            FileReader reader1 = new FileReader(outfileFile);
            FileReader reader2 = new FileReader(reffileFile);
            char[] contents1 = new char[65536];
            char[] contents2 = new char[65536];
            int size1 = reader1.read(contents1, 0, 65536);
            int size2 = reader2.read(contents2, 0, 65536);
            int offset1 = 0;
            int offset2 = 0;
            if (contents1[0] == '\u00ef' && contents1[1] == '\u00bb' && contents1[2] == '\u00bf') {
                offset1 += 3;
            }
            if (contents2[0] == '\u00ef' && contents2[1] == '\u00bb' && contents2[2] == '\u00bf') {
                offset2 += 3;
            }
            if (b = this.compareContent(actResult = size1 == -1 ? "" : new String(contents1, offset1, size1 - offset1), refResult = size2 == -1 ? "" : new String(contents2, offset2, size2 - offset2), comparator, ignoreIndentation)) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        if (comparator.equals("html-output")) {
            try {
                Tidy tidy = new Tidy();
                tidy.setXmlOut(true);
                tidy.setQuiet(true);
                tidy.setShowWarnings(false);
                tidy.setCharEncoding(3);
                FileInputStream in1 = new FileInputStream(outfile);
                File xml1 = new File(outfile + ".xml");
                xml1.createNewFile();
                FileOutputStream out1 = new FileOutputStream(xml1);
                tidy.parse((InputStream)in1, (OutputStream)out1);
                FileInputStream in2 = new FileInputStream(reffile);
                File xml2 = new File(reffile + ".xml");
                xml2.createNewFile();
                FileOutputStream out2 = new FileOutputStream(xml2);
                tidy.parse((InputStream)in2, (OutputStream)out2);
                ((InputStream)in1).close();
                ((InputStream)in2).close();
                ((OutputStream)out2).close();
                return this.compare(xml1.toString(), xml2.toString(), "xml", ignoreIndentation);
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        if (comparator.equals("xhtml-output")) {
            refResult = this.canonizeXhtml(refResult);
            actResult = this.canonizeXhtml(actResult);
            return actResult.equals(refResult);
        }
        if (comparator.equals("xml-frag")) {
            try {
                return this.compareFragments(outfileFile, reffileFile, outfile);
            }
            catch (Exception err2) {
                System.err.println("Failed to compare results for: " + outfile);
                err2.printStackTrace();
                return false;
            }
        }
        try {
            InputSource out = new InputSource(outfileFile.toURL().toString());
            InputSource ref = new InputSource(reffileFile.toURL().toString());
            String outxml = canon.toCanonicalXML2(this.resultParser, out, false);
            String refxml = canon.toCanonicalXML2(this.resultParser, ref, false);
            if (!outxml.equals(refxml)) {
                if (ignoreIndentation && (outxml = canon.toCanonicalXML2(this.resultParser, out, true)).equals(refxml = canon.toCanonicalXML2(this.resultParser, ref, true))) {
                    return true;
                }
                System.err.println("Mismatch with reference results: " + outfile);
                System.err.println("REFERENCE RESULTS:");
                System.err.println(XsltTestSuiteDriver.truncate(refxml));
                System.err.println("ACTUAL RESULTS:");
                System.err.println(XsltTestSuiteDriver.truncate(outxml));
                XsltTestSuiteDriver.findDiff(refxml, outxml);
                return false;
            }
            return true;
        }
        catch (Exception err) {
            try {
                System.err.println("Failed to compare results for: " + outfile + ": " + err.getMessage());
                err.printStackTrace();
                System.err.println("** Attempting XML Fragment comparison");
                boolean b = this.compareFragments(outfileFile, reffileFile, outfile);
                System.err.println("** " + (b ? "Success" : "Still different"));
                return b;
            }
            catch (Exception err2) {
                System.err.println("Again failed to compare results for: " + outfile);
                err2.printStackTrace();
                return false;
            }
        }
    }

    private boolean compareContent(String actResult, String refResult, String comparator, boolean ignoreIndentation) {
        try {
            actResult = actResult.replace("\r\n", "\n");
            refResult = refResult.replace("\r\n", "\n");
            if (actResult.equals(refResult)) {
                return true;
            }
            int size1 = actResult.length();
            int size2 = refResult.length();
            if (size1 == 0) {
                if (refResult.startsWith("<?xml") && size2 < 60 && refResult.endsWith("?>")) {
                    return true;
                }
                System.err.println("** ACTUAL RESULTS EMPTY; REFERENCE RESULTS LENGTH " + size2);
                return false;
            }
            if (size2 == 0) {
                if (actResult.startsWith("<?xml") && size1 < 60 && actResult.endsWith("?>")) {
                    return true;
                }
                System.err.println("** REFERENCED RESULTS EMPTY; ACTUAL RESULTS LENGTH " + size2);
                return false;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private String canonizeXhtml(String input) {
        try {
            XsltExecutable canonizer = this.getXhtmlCanonizer();
            XsltTransformer t = canonizer.load();
            StringWriter sw = new StringWriter();
            InputSource is = new InputSource(new StringReader(input));
            SAXSource ss = new SAXSource(this.resultParser, is);
            t.setSource(ss);
            t.setDestination(new Serializer(sw));
            t.transform();
            return sw.toString();
        }
        catch (SaxonApiException err) {
            System.err.println("*** Failed to compile/run XHTML canonicalizer stylesheet");
            err.printStackTrace();
            return "";
        }
    }

    private XsltExecutable getXhtmlCanonizer() throws SaxonApiException {
        if (this.xhtmlCanonizer == null) {
            StreamSource source = new StreamSource(new File(this.testSuiteDir + "/SaxonResults/canonizeXhtml.xsl"));
            this.xhtmlCanonizer = this.factory.newXsltCompiler().compile(source);
        }
        return this.xhtmlCanonizer;
    }

    private boolean compareFragments(File outfileFile, File reffileFile, String outfile) {
        String outurl = outfileFile.toURI().toString();
        String refurl = reffileFile.toURI().toString();
        String outdoc = "<?xml version='1.1'?><!DOCTYPE doc [ <!ENTITY e SYSTEM '" + outurl + "'>]><doc>&e;</doc>";
        String refdoc = "<?xml version='1.1'?><!DOCTYPE doc [ <!ENTITY e SYSTEM '" + refurl + "'>]><doc>&e;</doc>";
        InputSource out2 = new InputSource(new StringReader(outdoc));
        InputSource ref2 = new InputSource(new StringReader(refdoc));
        String outxml2 = canon.toCanonicalXML(this.fragmentParser, out2, true);
        String refxml2 = canon.toCanonicalXML(this.fragmentParser, ref2, true);
        if (outxml2 != null && refxml2 != null && !outxml2.equals(refxml2)) {
            System.err.println("Mismatch with reference results: " + outfile);
            System.err.println("REFERENCE RESULTS:");
            System.err.println(XsltTestSuiteDriver.truncate(refxml2));
            System.err.println("ACTUAL RESULTS:");
            System.err.println(XsltTestSuiteDriver.truncate(outxml2));
            XsltTestSuiteDriver.findDiff(refxml2, outxml2);
            return false;
        }
        if (outxml2 == null) {
            System.err.println("Cannot canonicalize actual results");
            return false;
        }
        if (refxml2 == null) {
            System.err.println("Cannot canonicalize reference results");
            return false;
        }
        return true;
    }

    private static String truncate(String s) {
        if (s.length() > 200) {
            return s.substring(0, 200);
        }
        return s;
    }

    private static void findDiff(String s1, String s2) {
        FastStringBuffer sb1 = new FastStringBuffer(s1.length());
        sb1.append(s1);
        FastStringBuffer sb2 = new FastStringBuffer(s2.length());
        sb2.append(s2);
        int i = 0;
        while (true) {
            if (s1.charAt(i) != s2.charAt(i)) {
                int j = i < 50 ? 0 : i - 50;
                int k = i + 50 > s1.length() || i + 50 > s2.length() ? i + 1 : i + 50;
                System.err.println("Different at char " + i + "\n+" + s1.substring(j, k) + "\n+" + s2.substring(j, k));
                break;
            }
            if (i >= s1.length() || i >= s2.length()) break;
            ++i;
        }
    }

    private String compareMessages(List<String> expectedMessages, List<String> actualMessages) {
        if (expectedMessages.size() != actualMessages.size()) {
            return "expected " + expectedMessages.size() + " messages, got " + actualMessages.size();
        }
        for (int i = 0; i < expectedMessages.size(); ++i) {
            boolean b = this.compareContent(expectedMessages.get(i), actualMessages.get(i), "xml-frag", true);
            if (b) continue;
            return actualMessages.get(i);
        }
        return null;
    }

    private void outputDiscretionaryItems() throws XMLStreamException {
        this.results.writeEmptyElement("discretionary-items");
    }

    private void setLocalizers(Configuration config) {
        config.setLocalizerFactory(new LocalizerFactory(){

            public Numberer getNumberer(String language, String country) {
                AbstractNumberer n = language == null ? new Numberer_en() : (language.equals("da") ? new Numberer_da() : (language.equals("de") ? new Numberer_de() : (language.equals("fr") ? new Numberer_fr() : (language.equals("fr-BE") ? new Numberer_frBE() : (language.equals("he") ? new Numberer_he() : (language.equals("it") ? new Numberer_it() : (language.equals("nl") ? new Numberer_nl() : (language.equals("nl-BE") ? new Numberer_nlBE() : (language.equals("sv") ? new Numberer_sv() : new Numberer_en())))))))));
                if (country != null) {
                    n.setCountry(country);
                }
                return n;
            }
        });
    }

    static {
        noCacheTests.add("schema092");
        noCacheTests.add("schemainline20_005_01");
        noCacheTests.add("schemamatch20_001_01");
        noCacheTests.add("schemamatch20_003_01");
        noCacheTests.add("schemamatch20_005_01");
        noCacheTests.add("schemamatch20_007_01");
        noCacheTests.add("schemamatch20_036_01");
        noCacheTests.add("schemamatch20_038_01");
        noCacheTests.add("schemamatch20_061_01");
        noCacheTests.add("schemamatch20_079_01");
        noCacheTests.add("schemamatch20_092_01");
        noCacheTests.add("schemamatch20_123_01");
        noCacheTests.add("schemamatch20_140_01");
        noCacheTests.add("schemanodetest20_001_01");
        noCacheTests.add("schemanodetest20_023_01");
        noCacheTests.add("schvalid001");
        noCacheTests.add("schvalid004");
        noCacheTests.add("schvalid005");
        noCacheTests.add("schvalid009");
        noCacheTests.add("schvalid014");
        noCacheTests.add("schvalid015");
        noCacheTests.add("schvalid020");
        noCacheTests.add("striptype20_003_01");
        noCacheTests.add("striptype20_006_01");
        noCacheTests.add("striptype20_008_01");
        noCacheTests.add("striptype20_011_01");
        noCacheTests.add("striptype20_012_01");
        noCacheTests.add("striptype20_039_01");
        undetectedRecoverableErrors = new HashSet();
        undetectedRecoverableErrors.add("XTRE0270");
        unrecoverableErrors = new HashSet();
        unrecoverableErrors.add("SESU0007");
        canon = new CanonicalXML();
    }

    private class MyErrorListener
    extends StandardErrorListener {
        public Set<String> errorCodes = new HashSet<String>();

        private MyErrorListener() {
        }

        public void error(TransformerException exception) throws TransformerException {
            if (exception instanceof XPathException) {
                String code = ((XPathException)exception).getErrorCodeLocalPart();
                if (code != null) {
                    this.errorCodes.add(code);
                }
                if ("FODC0005".equals(code) || "FODC0002".equals(code)) {
                    this.fatalError(exception);
                }
            }
            super.error(exception);
        }

        public void fatalError(TransformerException exception) throws TransformerException {
            String code;
            if (exception instanceof XPathException && (code = ((XPathException)exception).getErrorCodeLocalPart()) != null) {
                this.errorCodes.add(code);
            }
            super.fatalError(exception);
        }

        public void warning(TransformerException exception) throws TransformerException {
            if (XsltTestSuiteDriver.this.showWarnings) {
                super.warning(exception);
            }
        }

        public StandardErrorListener makeAnother(int hostLanguage) {
            return new MyErrorListener();
        }
    }
}

