/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.testdriver;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.CollectionURIResolver;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.value.AnyURIValue;

public class XQTSCollectionURIResolver
implements CollectionURIResolver {
    private DocumentInfo catalog;
    private NodeInfo collectionElement;
    private boolean isDefault;

    public XQTSCollectionURIResolver(DocumentInfo catalog, NodeInfo collectionElement, boolean isDefault) {
        this.catalog = catalog;
        this.collectionElement = collectionElement;
        this.isDefault = isDefault;
    }

    public SequenceIterator resolve(String href, String base, XPathContext context) throws XPathException {
        NodeInfo m;
        NamePool pool = this.catalog.getNamePool();
        int inputDocumentNC = pool.allocate("", "http://www.w3.org/2005/02/query-test-XQTSCatalog", "input-document");
        int IDNC = pool.allocate("", "", "ID");
        if (href == null) {
            href = "";
        }
        if (!(href.equals(this.collectionElement.getAttributeValue(IDNC)) || href.equals("") && this.isDefault)) {
            throw new XPathException("Unknown collection name " + href);
        }
        AxisIterator iter = this.collectionElement.iterateAxis((byte)3, new NameTest(1, inputDocumentNC, pool));
        ArrayList<AnyURIValue> documents = new ArrayList<AnyURIValue>(5);
        while ((m = (NodeInfo)iter.next()) != null) {
            URI uri;
            String shortName = m.getStringValue();
            String longName = "TestSources/" + shortName + ".xml";
            try {
                uri = new URI(this.collectionElement.getBaseURI()).resolve(longName);
            }
            catch (URISyntaxException e) {
                throw new XPathException(e);
            }
            documents.add(new AnyURIValue(uri.toString()));
        }
        return new ListIterator(documents);
    }
}

