/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.testdriver;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.config.EnterpriseTransformerFactory;
import com.saxonica.deploy.CompiledUserQuery;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.DecimalFormat;
import java.util.Properties;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.Version;
import net.sf.saxon.event.Sink;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.DateTimeValue;

public class XMarkBenchmark {
    static boolean pull = false;
    static boolean lazy = false;
    static boolean saproduct = false;
    static boolean satests = false;
    static boolean xslt = false;
    static boolean runCompiled = false;
    static boolean checkResults = false;
    static boolean val = false;
    static int test = -1;
    private static final DecimalFormat format = new DecimalFormat("######0.00");

    private XMarkBenchmark() {
    }

    public static void main(String[] argv) throws Exception {
        String dir = null;
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].startsWith("-dir:")) {
                dir = argv[i].substring(5);
            }
            if (argv[i].equals("-pull")) {
                pull = true;
            }
            if (argv[i].equals("-lazy")) {
                lazy = true;
            }
            if (argv[i].equals("-sa")) {
                saproduct = true;
            }
            if (argv[i].equals("-satests")) {
                satests = true;
            }
            if (argv[i].equals("-xslt")) {
                xslt = true;
            }
            if (argv[i].equals("-runcomp")) {
                runCompiled = true;
            }
            if (argv[i].equals("-check")) {
                checkResults = true;
            }
            if (argv[i].equals("-val")) {
                val = true;
            }
            if (argv[i].startsWith("-q")) {
                test = Integer.parseInt(argv[i].substring(2));
            }
            if (!argv[i].equals("-?")) continue;
            System.err.println("Options: -pull -lazy -sa -xslt -compile -runcomp");
        }
        if (dir == null) {
            String string = dir = satests ? "e:\\javalib\\xmark\\sa\\" : "e:\\javalib\\xmark\\";
        }
        if (xslt) {
            XMarkBenchmark.transform(lazy, saproduct, dir);
        } else {
            XMarkBenchmark.query(dir);
        }
    }

    public static void query(String dir) throws Exception {
        String[] tests = new String[]{"xmark1.xml", "xmark4.xml", "xmark10.xml"};
        String options = "";
        String when = DateTimeValue.getCurrentDateTime(null).getStringValue();
        if (saproduct) {
            options = options + "-sa ";
        }
        if (satests) {
            options = options + "-satests ";
        }
        if (pull) {
            options = options + "-pull ";
        }
        if (lazy) {
            options = options + "-lazy ";
        }
        if (val) {
            options = options + "-val ";
        }
        if (runCompiled) {
            options = options + "-runcomp";
        }
        System.out.println("<xmark-results product='Saxon' lang='query' version='" + Version.getProductVersion() + "' options='" + options + "' when='" + when + "'>");
        for (int f = 0; f < tests.length; ++f) {
            long time;
            long end;
            Sink result;
            int q;
            Configuration config;
            File file = new File(dir + tests[f]);
            Configuration configuration = config = saproduct ? new EnterpriseConfiguration() : new Configuration();
            if (lazy) {
                config.setLazyConstructionMode(true);
            }
            if (satests) {
                config.setSchemaValidationMode(1);
                config.addSchemaSource(new StreamSource(new File(dir + "schema.xsd")), config.getErrorListener());
                config.setConfigurationProperty("http://saxon.sf.net/feature/use-typed-value-cache", "false");
            }
            if (val) {
                config.loadSchema(new File(dir + "sa\\schema.xsd").toURI().toString());
                config.setSchemaValidationMode(1);
            }
            StreamSource streamSource = new StreamSource(file);
            long pstart = System.currentTimeMillis();
            DocumentInfo doc = config.buildDocument(streamSource);
            long pend = System.currentTimeMillis();
            System.out.println("  <file name='" + tests[f] + "' size='" + file.length() + "' build-time='" + (pend - pstart) + "'>");
            Properties props = new Properties();
            props.setProperty("method", "xml");
            props.setProperty("indent", "yes");
            if (runCompiled) {
                for (q = 1; q <= 20; ++q) {
                    if (test != -1 && test != q) continue;
                    try {
                        URLClassLoader usercodeLoader = new URLClassLoader(new URL[]{new URL("file:///e:/javalib/xMark/java/")});
                        Class<?> userClass = usercodeLoader.loadClass("Q" + q);
                        CompiledUserQuery cuq = (CompiledUserQuery)userClass.newInstance();
                        cuq.setConfiguration(config);
                        DynamicQueryContext dqc = new DynamicQueryContext(config);
                        cuq.setDynamicContext(dqc);
                        int runs = 0;
                        long totalTime = 0L;
                        long min = Integer.MAX_VALUE;
                        long max = 0L;
                        if (checkResults && f == 0) {
                            dqc.setContextItem(doc);
                            File out = new File("e:/javalib/xmark/output/q" + q + ".out");
                            FileOutputStream os = new FileOutputStream(out);
                            StreamResult result2 = new StreamResult(os);
                            cuq.run(result2, props);
                            ((OutputStream)os).close();
                            XMarkBenchmark.compare(new File("e:/javalib/xmark/output/q" + q + ".out"), new File("e:/javalib/xmark/gold1m/q" + q + ".out"));
                        }
                        for (int t = 0; t < 1000; ++t) {
                            dqc.setContextItem(doc);
                            result = new Sink();
                            long start = System.currentTimeMillis();
                            cuq.run(result, props);
                            end = System.currentTimeMillis();
                            ++runs;
                            time = end - start;
                            if (time < min) {
                                min = time;
                            }
                            if (time > max) {
                                max = time;
                            }
                            if ((totalTime += time) > 30000L && t >= 2) break;
                        }
                        double avg = (double)totalTime / (double)runs;
                        String avgs = format.format(avg);
                        System.out.println("    <query q='" + q + "' avg='" + avgs + "' runs='" + runs + "' min='" + min + "' max='" + max + "'/>");
                        continue;
                    }
                    catch (XPathException err) {
                        System.err.println("Error in test " + q);
                        System.err.println(err.getMessageAndLocation());
                    }
                }
            } else {
                for (q = 1; q <= 20; ++q) {
                    if (test != -1 && test != q) continue;
                    try {
                        File query = new File(dir + 'q' + q + ".xq");
                        StaticQueryContext qenv = config.newStaticQueryContext();
                        qenv.setBaseURI(query.toURI().toString());
                        if (val) {
                            qenv.setSchemaAware(true);
                        }
                        XQueryExpression exp = qenv.compileQuery(new FileReader(query));
                        int runs = 0;
                        long totalTime = 0L;
                        long min = Integer.MAX_VALUE;
                        long max = 0L;
                        for (int t = 0; t < 1000; ++t) {
                            long start;
                            DynamicQueryContext context = new DynamicQueryContext(config);
                            context.setContextItem(doc);
                            result = new Sink();
                            if (pull) {
                                start = System.currentTimeMillis();
                                exp.pull(context, result, props);
                                end = System.currentTimeMillis();
                            } else {
                                start = System.currentTimeMillis();
                                exp.run(context, result, props);
                                end = System.currentTimeMillis();
                            }
                            ++runs;
                            time = end - start;
                            if (time < min) {
                                min = time;
                            }
                            if (time > max) {
                                max = time;
                            }
                            if ((totalTime += time) > 30000L && t >= 2) break;
                        }
                        double avg = (double)totalTime / (double)runs;
                        String avgs = format.format(avg);
                        System.out.println("    <query q='" + q + "' avg='" + avgs + "' runs='" + runs + "' min='" + min + "' max='" + max + "'/>");
                        continue;
                    }
                    catch (XPathException err) {
                        System.err.println("Error in test " + q);
                        System.err.println(err.getMessageAndLocation());
                    }
                }
            }
            System.out.println("  </file>");
        }
        System.out.println("</xmark-results>");
    }

    public static void transform(boolean lazy, boolean sa, String dir) throws Exception {
        String[] tests = new String[]{"xmark1.xml", "xmark4.xml", "xmark10.xml"};
        System.out.println("<xmark-results product='Saxon' lang='xslt' version='" + Version.getProductVersion() + "'>");
        for (int f = 0; f < tests.length; ++f) {
            File file = new File(dir + tests[f]);
            TransformerFactoryImpl factory = sa ? new EnterpriseTransformerFactory() : new TransformerFactoryImpl();
            Configuration config = ((TransformerFactoryImpl)factory).getConfiguration();
            if (lazy) {
                config.setLazyConstructionMode(true);
            }
            StreamSource streamSource = new StreamSource(file);
            long pstart = System.currentTimeMillis();
            DocumentInfo doc = config.buildDocument(streamSource);
            long pend = System.currentTimeMillis();
            System.out.println("  <file name='" + tests[f] + "' size='" + file.length() + "' schema-aware='" + config.isLicensedFeature(2) + "' build-time='" + (pend - pstart) + "'>");
            for (int q = 1; q <= 20; ++q) {
                File sheet = new File(dir + 'q' + q + ".xsl");
                if (!sheet.exists()) continue;
                Templates templates = ((TransformerFactory)factory).newTemplates(new StreamSource(sheet));
                int runs = 0;
                long totalTime = 0L;
                long min = Integer.MAX_VALUE;
                long max = 0L;
                for (int t = 0; t < 10; ++t) {
                    Sink result = new Sink();
                    long start = System.currentTimeMillis();
                    templates.newTransformer().transform(doc, result);
                    long end = System.currentTimeMillis();
                    ++runs;
                    long time = end - start;
                    if (time < min) {
                        min = time;
                    }
                    if (time > max) {
                        max = time;
                    }
                    if ((totalTime += time) > 1000L && t >= 2) break;
                }
                System.out.println("    <query q='" + q + "' avg='" + totalTime / (long)runs + "' runs='" + runs + "' min='" + min + "' max='" + max + "'/>");
            }
            System.out.println("  </file>");
        }
        System.out.println("</xmark-results>");
    }

    private static void compare(File actual, File gold) {
        try {
            String refResult;
            FileReader reader1 = new FileReader(actual);
            FileReader reader2 = new FileReader(gold);
            char[] contents1 = new char[65536];
            char[] contents2 = new char[65536];
            int size1 = reader1.read(contents1, 0, 65536);
            int size2 = reader2.read(contents2, 0, 65536);
            reader1.close();
            reader2.close();
            int offset1 = 0;
            int offset2 = 0;
            if (contents1[0] == '\u00ef' && contents1[1] == '\u00bb' && contents1[2] == '\u00bf') {
                offset1 += 3;
            }
            if (contents2[0] == '\u00ef' && contents2[1] == '\u00bb' && contents2[2] == '\u00bf') {
                offset2 += 3;
            }
            String actResult = size1 == -1 ? "" : new String(contents1, offset1, size1 - offset1);
            String string = refResult = size2 == -1 ? "" : new String(contents2, offset2, size2 - offset2);
            if (actResult.equals(refResult)) {
                System.err.println("Results compared OK");
            } else {
                System.err.println("*** Results do not match");
            }
        }
        catch (Exception err) {
            System.err.println("Failed to compare with gold results: " + err.getMessage());
        }
    }
}

