/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.testdriver;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Version;
import net.sf.saxon.event.Builder;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.functions.DeepEqual;
import net.sf.saxon.lib.CollectionURIResolver;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.lib.StandardModuleURIResolver;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Name11Checker;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SchemaManager;
import net.sf.saxon.s9api.SchemaValidator;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XQueryCompiler;
import net.sf.saxon.s9api.XQueryEvaluator;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.DecimalSymbols;
import net.sf.saxon.trans.LicenseException;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.tree.iter.SingleNodeIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Orphan;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.value.Whitespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FOTestSuiteDriver {
    public static String RNS = "http://www.w3.org/2010/09/qt-fots-catalog";
    private Processor driverProc = new Processor(true);
    private Serializer driverSerializer = this.driverProc.newSerializer();
    private Map<String, Environment> globalEnvironments = new HashMap<String, Environment>();
    private Map<String, Environment> localEnvironments = new HashMap<String, Environment>();
    private Pattern testPattern = null;
    private String testFuncSet = null;
    private boolean debug = false;
    XMLStreamWriter results;
    private int successes = 0;
    private int failures = 0;
    private int wrongErrorResults = 0;

    public static void main(String[] args) throws Exception {
        if (args.length == 0 || args[0].equals("-?")) {
            System.err.println("FOTestSuiteDriver catalog [-s:testSetName] [-t:testNamePattern] ");
        }
        System.err.println("Testing Saxon " + Version.getProductVersion());
        new FOTestSuiteDriver().go(args);
    }

    private void go(String[] args) throws SaxonApiException {
        String catalog = args[0];
        for (int i = 1; i < args.length; ++i) {
            if (args[i].startsWith("-t:")) {
                this.testPattern = Pattern.compile(args[i].substring(3));
            }
            if (args[i].startsWith("-s:")) {
                this.testFuncSet = args[i].substring(3);
            }
            if (!args[i].startsWith("-debug")) continue;
            this.debug = true;
        }
        this.driverSerializer.setOutputStream(System.err);
        this.driverSerializer.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes");
        this.processCatalog(new File(catalog));
        System.err.println(this.successes + " successes, " + this.failures + " failures, " + this.wrongErrorResults + " incorrect ErrorCode");
    }

    private void processCatalog(File catalogFile) throws SaxonApiException {
        DocumentBuilder catbuilder = this.driverProc.newDocumentBuilder();
        XdmNode catalog = catbuilder.build(catalogFile);
        XPathCompiler xpc = this.driverProc.newXPathCompiler();
        xpc.setLanguageVersion("3.0");
        xpc.setCaching(true);
        xpc.declareNamespace("", "http://www.w3.org/2010/09/qt-fots-catalog");
        for (XdmItem env : xpc.evaluate("//environment", catalog)) {
            this.processEnvironment(xpc, env, this.globalEnvironments);
        }
        Object testName = null;
        try {
            this.writeResultFilePreamble(this.driverProc, catalog, DateTimeValue.getCurrentDateTime(null).getStringValue().substring(0, 10));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.testFuncSet != null) {
            try {
                XdmNode funcSetNode = (XdmNode)xpc.evaluateSingle("//test-set[@name='" + this.testFuncSet + "']", catalog);
                if (funcSetNode == null) {
                    throw new Exception("Test-set " + this.testFuncSet + " not found!");
                }
                this.processTestSet(catbuilder, xpc, funcSetNode);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        } else {
            for (XdmItem testSet : xpc.evaluate("//test-set", catalog)) {
                this.processTestSet(catbuilder, xpc, (XdmNode)testSet);
            }
        }
        try {
            this.writeResultFilePostamble();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void processTestSet(DocumentBuilder catbuilder, XPathCompiler xpc, XdmNode funcSetNode) throws SaxonApiException {
        try {
            this.results.writeStartElement("test-set");
            this.results.writeAttribute("name", funcSetNode.getAttributeValue(new QName("name")));
        }
        catch (XMLStreamException e) {
            // empty catch block
        }
        File testSetFile = new File(funcSetNode.getAttributeValue(new QName("file")));
        XdmNode testSetDocNode = catbuilder.build(testSetFile);
        this.localEnvironments.clear();
        this.localEnvironments.put("default", this.createLocalEnvironment(testSetDocNode.getBaseURI()));
        boolean run = true;
        for (XdmItem dependency : xpc.evaluate("/test-set/dependency", testSetDocNode)) {
            if (this.dependencyIsSatisfied((XdmNode)dependency, null)) continue;
            run = false;
        }
        if (run) {
            for (XdmItem env : xpc.evaluate("//environment[@name]", testSetDocNode)) {
                this.processEnvironment(xpc, env, this.localEnvironments);
            }
            for (XdmItem testCase : xpc.evaluate("//test-case", testSetDocNode)) {
                String testName = xpc.evaluateSingle("@name", testCase).getStringValue();
                if (this.testPattern != null && !this.testPattern.matcher(testName).matches()) continue;
                this.runTestCase((XdmNode)testCase, xpc);
            }
        }
        try {
            this.results.writeEndElement();
        }
        catch (XMLStreamException e) {
            // empty catch block
        }
    }

    private Environment createLocalEnvironment(URI baseURI) {
        Environment environment = new Environment();
        environment.processor = new Processor(true);
        environment.xpathCompiler = environment.processor.newXPathCompiler();
        environment.xpathCompiler.setBaseURI(baseURI);
        environment.xqueryCompiler = environment.processor.newXQueryCompiler();
        environment.xqueryCompiler.setBaseURI(baseURI);
        return environment;
    }

    private Environment processEnvironment(XPathCompiler xpc, XdmItem env, Map<String, Environment> environments) throws SaxonApiException {
        Environment environment = new Environment();
        String name = ((XdmNode)env).getAttributeValue(new QName("name"));
        try {
            File file;
            String href;
            environment.processor = new Processor(true);
            environment.xpathCompiler = environment.processor.newXPathCompiler();
            environment.xpathCompiler.setBaseURI(((XdmNode)env).getBaseURI());
            environment.xqueryCompiler = environment.processor.newXQueryCompiler();
            environment.xqueryCompiler.setBaseURI(((XdmNode)env).getBaseURI());
            DocumentBuilder builder = environment.processor.newDocumentBuilder();
            environment.sourceDocs = new HashMap<String, XdmNode>();
            if (environments != null && name != null) {
                environments.put(name, environment);
            }
            for (XdmItem dependency : xpc.evaluate("dependency", env)) {
                if (this.dependencyIsSatisfied((XdmNode)dependency, environment)) continue;
                environment.usable = false;
            }
            for (XdmItem base : xpc.evaluate("static-base-uri", env)) {
                String uri = ((XdmNode)base).getAttributeValue(new QName("uri"));
                try {
                    environment.xpathCompiler.setBaseURI(new URI(uri));
                    environment.xqueryCompiler.setBaseURI(new URI(uri));
                }
                catch (URISyntaxException e) {
                    System.err.println("**** invalid base URI " + uri);
                }
            }
            for (XdmItem base : xpc.evaluate("collation", env)) {
                System.err.println("*** Collations not supported in this test driver");
                environment.usable = false;
            }
            for (XdmItem nsElement : xpc.evaluate("namespace", env)) {
                String prefix = ((XdmNode)nsElement).getAttributeValue(new QName("prefix"));
                String uri = ((XdmNode)nsElement).getAttributeValue(new QName("uri"));
                environment.xpathCompiler.declareNamespace(prefix, uri);
                environment.xqueryCompiler.declareNamespace(prefix, uri);
            }
            SchemaManager manager = environment.processor.getSchemaManager();
            for (XdmItem schema : xpc.evaluate("schema", env)) {
                href = ((XdmNode)schema).getAttributeValue(new QName("file"));
                file = new File(((XdmNode)env).getBaseURI().resolve(href));
                manager.load(new StreamSource(file));
            }
            for (XdmItem source : xpc.evaluate("source", env)) {
                href = ((XdmNode)source).getAttributeValue(new QName("file"));
                file = new File(((XdmNode)env).getBaseURI().resolve(href));
                String uri = ((XdmNode)source).getAttributeValue(new QName("uri"));
                String validation = ((XdmNode)source).getAttributeValue(new QName("", "validation"));
                if (validation == null || validation.equals("skip")) {
                    builder.setSchemaValidator(null);
                } else {
                    SchemaValidator validator = manager.newSchemaValidator();
                    validator.setLax(validation.equals("lax"));
                    builder.setSchemaValidator(validator);
                }
                try {
                    String role;
                    XdmNode doc = builder.build(file);
                    if (uri != null) {
                        environment.sourceDocs.put(uri, doc);
                    }
                    if ((role = ((XdmNode)source).getAttributeValue(new QName("role"))) == null) continue;
                    if (".".equals(role)) {
                        environment.contextNode = doc;
                        continue;
                    }
                    if (!role.startsWith("$")) continue;
                    String varName = role.substring(1);
                    environment.params.put(new QName(varName), doc);
                    environment.xpathCompiler.declareVariable(new QName(varName));
                    environment.paramDeclarations.append("declare variable $" + varName + " external; ");
                }
                catch (SaxonApiException e) {
                    System.err.println("*** failed to build source document " + file);
                }
            }
            final HashMap collections = new HashMap();
            for (XdmItem coll : xpc.evaluate("collection", env)) {
                String collectionURI = ((XdmNode)coll).getAttributeValue(new QName("uri"));
                if (collectionURI == null) {
                    collectionURI = "";
                }
                ArrayList<AnyURIValue> docs = new ArrayList<AnyURIValue>();
                for (XdmItem source : xpc.evaluate("source", coll)) {
                    String href2 = ((XdmNode)source).getAttributeValue(new QName("file"));
                    File file2 = new File(((XdmNode)env).getBaseURI().resolve(href2));
                    String id = ((XdmNode)source).getAttributeValue(new QName("http://www.w3.org/XML/1998/namespace", "id"));
                    XdmNode doc = builder.build(file2);
                    environment.sourceDocs.put(id, doc);
                    docs.add(new AnyURIValue(doc.getDocumentURI().toString()));
                }
                try {
                    collections.put(new URI(collectionURI), docs);
                }
                catch (URISyntaxException e) {
                    System.err.println("**** Invalid collection URI " + collectionURI);
                }
            }
            if (!collections.isEmpty()) {
                environment.processor.getUnderlyingConfiguration().setCollectionURIResolver(new CollectionURIResolver(){

                    public SequenceIterator resolve(String href, String base, XPathContext context) throws XPathException {
                        try {
                            List docs;
                            if (href == null) {
                                docs = (List)collections.get(new URI(""));
                            } else {
                                URI abs = new URI(base).resolve(href);
                                docs = (List)collections.get(abs);
                            }
                            if (docs == null) {
                                return EmptyIterator.getInstance();
                            }
                            return new ListIterator(docs);
                        }
                        catch (URISyntaxException e) {
                            System.err.println("** Invalid URI: " + e.getMessage());
                            return EmptyIterator.getInstance();
                        }
                    }
                });
            }
            for (XdmItem source : xpc.evaluate("function", env)) {
                String fname = ((XdmNode)source).getAttributeValue(new QName("name"));
                if (fname.equals("fots:copy")) {
                    environment.processor.registerExtensionFunction(new FotsCopyFunction());
                    continue;
                }
                System.err.println("**** Unknown function in environment");
            }
            for (XdmItem decimalFormat : xpc.evaluate("decimal-format", env)) {
                DecimalFormatManager dfm = environment.xpathCompiler.getUnderlyingStaticContext().getDecimalFormatManager();
                DecimalSymbols symbols = new DecimalSymbols();
                XdmNode formatElement = (XdmNode)decimalFormat;
                String formatName = formatElement.getAttributeValue(new QName("name"));
                StructuredQName formatQName = null;
                if (formatName != null) {
                    if (formatName.indexOf(58) < 0) {
                        formatQName = new StructuredQName("", "", formatName);
                    } else {
                        try {
                            formatQName = StructuredQName.fromLexicalQName(formatName, false, Name11Checker.getInstance(), environment.xpathCompiler.getUnderlyingStaticContext().getNamespaceResolver());
                        }
                        catch (XPathException e) {
                            System.err.println("**** Invalid QName as decimal-format name");
                            formatQName = new StructuredQName("", "", "error-name");
                        }
                    }
                }
                for (XdmItem decimalFormatAtt : xpc.evaluate("@* except @name", formatElement)) {
                    XdmNode formatAttribute = (XdmNode)decimalFormatAtt;
                    String property = formatAttribute.getNodeName().getLocalName();
                    String value = formatAttribute.getStringValue();
                    if (property.equals("decimal-separator")) {
                        symbols.decimalSeparator = this.toChar(value);
                        continue;
                    }
                    if (property.equals("grouping-separator")) {
                        symbols.groupingSeparator = this.toChar(value);
                        continue;
                    }
                    if (property.equals("infinity")) {
                        symbols.infinity = value;
                        continue;
                    }
                    if (property.equals("NaN")) {
                        symbols.NaN = value;
                        continue;
                    }
                    if (property.equals("minus-sign")) {
                        symbols.minusSign = this.toChar(value);
                        continue;
                    }
                    if (property.equals("percent")) {
                        symbols.percent = this.toChar(value);
                        continue;
                    }
                    if (property.equals("per-mille")) {
                        symbols.permill = this.toChar(value);
                        continue;
                    }
                    if (property.equals("zero-digit")) {
                        symbols.zeroDigit = this.toChar(value);
                        continue;
                    }
                    if (property.equals("digit")) {
                        symbols.digit = this.toChar(value);
                        continue;
                    }
                    if (property.equals("pattern-separator")) {
                        symbols.patternSeparator = this.toChar(value);
                        continue;
                    }
                    System.err.println("**** Unknown decimal format attribute " + property);
                }
                try {
                    symbols.checkDistinctRoles();
                }
                catch (XPathException err) {
                    System.err.println("**** " + err.getMessage());
                }
                try {
                    if (formatName == null) {
                        dfm.setDefaultDecimalFormat(symbols, 0);
                        continue;
                    }
                    dfm.setNamedDecimalFormat(formatQName, symbols, 0);
                }
                catch (XPathException err) {
                    System.err.println("**** " + err.getMessage());
                }
            }
            for (XdmItem param : xpc.evaluate("param", env)) {
                XdmValue value;
                String varName = ((XdmNode)param).getAttributeValue(new QName("name"));
                String source = ((XdmNode)param).getAttributeValue(new QName("source"));
                if (source != null) {
                    XdmNode sourceDoc = environment.sourceDocs.get(source);
                    if (sourceDoc == null) {
                        System.err.println("**** Unknown source document " + source);
                    }
                    value = sourceDoc;
                } else {
                    String select = ((XdmNode)param).getAttributeValue(new QName("select"));
                    value = xpc.evaluate(select, null);
                }
                environment.params.put(new QName(varName), value);
                environment.xpathCompiler.declareVariable(new QName(varName));
                String declared = ((XdmNode)param).getAttributeValue(new QName("declared"));
                if (declared != null && "true".equals(declared) || "1".equals(declared)) continue;
                environment.paramDeclarations.append("declare variable $" + varName + " external; ");
            }
        }
        catch (LicenseException e) {
            System.err.println("Environment (name=" + name + ") requires a Saxon-EE license");
            environment.usable = false;
        }
        return environment;
    }

    private int toChar(String s) {
        int[] e = StringValue.expand(s);
        if (e.length != 1) {
            System.err.println("Attribute \"" + s + "\" should be a single character");
        }
        return e[0];
    }

    private boolean dependencyIsSatisfied(XdmNode dependency, Environment env) {
        String type = dependency.getAttributeValue(new QName("type"));
        String value = dependency.getAttributeValue(new QName("value"));
        boolean inverse = "false".equals(dependency.getAttributeValue(new QName("satisfied")));
        if ("xpath-1.0-compatibility".equals(type)) {
            if ("true".equals(value)) {
                if (env != null) {
                    env.xpathCompiler.setBackwardsCompatible(true);
                } else {
                    return false;
                }
            }
            return true;
        }
        if ("xml-version".equals(type)) {
            if ("1.1".equals(value) && !inverse) {
                if (env != null) {
                    env.processor.setXmlVersion("1.1");
                } else {
                    return false;
                }
            }
            return true;
        }
        if ("limits".equals(type)) {
            return "year_lt_0".equals(value) && !inverse;
        }
        if ("spec".equals(type)) {
            return true;
        }
        if ("collection-stability".equals(type)) {
            return "false".equals(value) != inverse;
        }
        if ("default-language".equals(type)) {
            return "en".equals(value) != inverse;
        }
        if ("directory-as-collection-uri".equals(type)) {
            return "true".equals(value) != inverse;
        }
        if ("language".equals(type)) {
            return ("en".equals(value) || "de".equals(value) || "fr".equals(value)) != inverse;
        }
        if ("calendar".equals(type)) {
            return ("AD".equals(value) || "ISO".equals(value)) != inverse;
        }
        if ("format-integer-sequence".equals(type)) {
            return !inverse;
        }
        if ("feature".equals(type)) {
            if ("namespace-axis".equals(value)) {
                return !inverse;
            }
            if ("schemaImport".equals(value) || "schemaValidation".equals(value)) {
                if (env != null) {
                    env.xpathCompiler.setSchemaAware(true);
                    env.xqueryCompiler.setSchemaAware(true);
                }
                return true;
            }
            System.err.println("**** feature = " + value + "  ????");
            return false;
        }
        System.err.println("**** dependency not recognized: " + type);
        return false;
    }

    private void runTestCase(XdmNode testCase, XPathCompiler xpc) throws SaxonApiException {
        Environment env;
        String testCaseName = testCase.getAttributeValue(new QName("name"));
        System.err.println("Test case " + testCaseName);
        XdmNode environmentNode = (XdmNode)xpc.evaluateSingle("environment", testCase);
        if (environmentNode == null) {
            env = this.localEnvironments.get("default");
        } else {
            String envName = environmentNode.getAttributeValue(new QName("ref"));
            if (envName == null) {
                env = this.processEnvironment(xpc, environmentNode, null);
            } else {
                env = this.localEnvironments.get(envName);
                if (env == null) {
                    env = this.globalEnvironments.get(envName);
                }
                if (env == null) {
                    System.err.println("*** Unknown environment " + envName);
                    this.writeTestcaseElement(testCaseName, "fail", "Environment " + envName + " not found");
                    ++this.failures;
                    return;
                }
            }
            if (!env.usable) {
                System.err.println("*** Unusable environment " + envName);
                this.writeTestcaseElement(testCaseName, "fail", "Environment " + envName + " not found");
                ++this.failures;
                return;
            }
        }
        env.xpathCompiler.setBackwardsCompatible(false);
        env.processor.setXmlVersion("1.0");
        boolean run = true;
        String hostLang = "XP";
        String langVersion = "2.0";
        for (XdmItem dependency : xpc.evaluate("/*/dependency, ./dependency", testCase)) {
            String type = ((XdmNode)dependency).getAttributeValue(new QName("type"));
            if (type == null) {
                throw new IllegalStateException("dependency/@type is missing");
            }
            String value = ((XdmNode)dependency).getAttributeValue(new QName("value"));
            if (value == null) {
                throw new IllegalStateException("dependency/@value is missing");
            }
            if (type.equals("spec")) {
                if (value.contains("XP")) {
                    hostLang = "XP";
                    langVersion = value.equals("XP20") ? "2.0" : "3.0";
                } else {
                    hostLang = "XQ";
                    String string = langVersion = value.contains("XQ10+") || value.contains("XQ30") ? "3.0" : "1.0";
                }
            }
            if (this.dependencyIsSatisfied((XdmNode)dependency, env)) continue;
            System.err.println("*** Dependency not satisfied: " + ((XdmNode)dependency).getAttributeValue(new QName("type")));
            this.writeTestcaseElement(testCaseName, "notRun", "Dependency not satisfied");
            run = false;
        }
        if (run) {
            XdmNode assertion;
            Outcome outcome = null;
            String exp = null;
            try {
                exp = xpc.evaluate("if (test/@file) then unparsed-text(resolve-uri(test/@file, base-uri(.))) else string(test)", testCase).toString();
            }
            catch (SaxonApiException err) {
                System.err.println("*** Failed to read query: " + err.getMessage());
                outcome = new Outcome(err);
            }
            if (outcome == null) {
                if (hostLang.equals("XP")) {
                    XPathCompiler testXpc = env.xpathCompiler;
                    testXpc.setLanguageVersion(langVersion);
                    testXpc.declareNamespace("fn", "http://www.w3.org/2005/xpath-functions");
                    testXpc.declareNamespace("xs", "http://www.w3.org/2001/XMLSchema");
                    try {
                        XPathSelector selector = testXpc.compile(exp).load();
                        for (QName varName : env.params.keySet()) {
                            selector.setVariable(varName, env.params.get(varName));
                        }
                        if (env.contextNode != null) {
                            selector.setContextItem(env.contextNode);
                        }
                        XdmValue result = selector.evaluate();
                        outcome = new Outcome(result);
                    }
                    catch (SaxonApiException err) {
                        System.err.println(err.getMessage());
                        outcome = new Outcome(err);
                    }
                } else {
                    XQueryCompiler testXqc = env.xqueryCompiler;
                    testXqc.setLanguageVersion(langVersion);
                    testXqc.declareNamespace("fn", "http://www.w3.org/2005/xpath-functions");
                    testXqc.declareNamespace("xs", "http://www.w3.org/2001/XMLSchema");
                    String vars = env.paramDeclarations.toString();
                    if (!vars.isEmpty()) {
                        int x = exp.indexOf("(:%VARDECL%:)");
                        exp = x < 0 ? vars + exp : exp.substring(0, x) + vars + exp.substring(x + 13);
                    }
                    ModuleResolver mr = new ModuleResolver(xpc);
                    mr.setTestCase(testCase);
                    testXqc.setModuleURIResolver(mr);
                    try {
                        XQueryEvaluator selector = testXqc.compile(exp).load();
                        for (QName varName : env.params.keySet()) {
                            selector.setExternalVariable(varName, env.params.get(varName));
                        }
                        if (env.contextNode != null) {
                            selector.setContextItem(env.contextNode);
                        }
                        selector.setURIResolver(new TestURIResolver(env));
                        XdmValue result = selector.evaluate();
                        outcome = new Outcome(result);
                    }
                    catch (SaxonApiException err) {
                        System.err.println(err.getMessage());
                        outcome = new Outcome(err);
                    }
                }
            }
            if ((assertion = (XdmNode)xpc.evaluateSingle("result/*[1]", testCase)) == null) {
                System.err.println("*** No assertions found for test case " + testCaseName);
                this.writeTestcaseElement(testCaseName, "fail", "No assertions in test case");
                ++this.failures;
                return;
            }
            XPathCompiler assertXpc = env.processor.newXPathCompiler();
            assertXpc.setLanguageVersion("3.0");
            assertXpc.declareNamespace("fn", "http://www.w3.org/2005/xpath-functions");
            assertXpc.declareNamespace("xs", "http://www.w3.org/2001/XMLSchema");
            assertXpc.declareVariable(new QName("result"));
            boolean b = this.testAssertion(assertion, outcome, assertXpc, xpc, this.debug);
            if (b) {
                System.err.println("OK");
                this.writeTestcaseElement(testCaseName, "full", null);
                ++this.successes;
            } else if (outcome.isException()) {
                XdmItem expectedError = xpc.evaluateSingle("result//error/@code", testCase);
                if (expectedError == null) {
                    this.writeTestcaseElement(testCaseName, "fail", "Expected success, got " + outcome.getException().getErrorCode());
                    System.err.println("*** fail, result " + outcome.getException().getErrorCode() + " Expected success.");
                    ++this.failures;
                } else {
                    this.writeTestcaseElement(testCaseName, "different-error", "Expected error:" + expectedError.getStringValue() + ", got " + outcome.getException().getErrorCode());
                    System.err.println("*** fail, result " + outcome.getException().getErrorCode() + " Expected error:" + expectedError.getStringValue());
                    ++this.wrongErrorResults;
                }
            } else {
                this.writeTestcaseElement(testCaseName, "fail", "Wrong results, got " + this.truncate(outcome.serialize(assertXpc.getProcessor())));
                ++this.failures;
                if (this.debug) {
                    try {
                        System.err.println("Result: " + outcome.serialize(assertXpc.getProcessor()));
                    }
                    catch (Exception err) {}
                } else {
                    System.err.println("*** fail (use -debug to show actual result)");
                }
            }
        }
    }

    private String truncate(String in) {
        if (in.length() > 80) {
            return in.substring(0, 80) + "...";
        }
        return in;
    }

    private boolean testAssertion(XdmNode assertion, Outcome outcome, XPathCompiler assertXpc, XPathCompiler catalogXpc, boolean debug) throws SaxonApiException {
        String tag = assertion.getNodeName().getLocalName();
        boolean result = this.testAssertion2(assertion, outcome, assertXpc, catalogXpc, debug);
        if (debug && !"all-of".equals(tag) && !"any-of".equals(tag)) {
            System.err.println("Assertion " + tag + " (" + assertion.getStringValue() + ") " + (result ? " succeeded" : " failed"));
            if (tag.equals("error")) {
                System.err.println("Expected exception " + assertion.getAttributeValue(new QName("code")) + ", got " + (outcome.isException() ? outcome.getException().getErrorCode() : "success"));
            }
        }
        return result;
    }

    private boolean testAssertion2(XdmNode assertion, Outcome outcome, XPathCompiler assertXpc, XPathCompiler catalogXpc, boolean debug) throws SaxonApiException {
        String tag = assertion.getNodeName().getLocalName();
        if (tag.equals("assert-eq")) {
            if (outcome.isException()) {
                return false;
            }
            XPathSelector s = assertXpc.compile("$result eq " + assertion.getStringValue()).load();
            s.setVariable(new QName("result"), outcome.getResult());
            XdmAtomicValue item = (XdmAtomicValue)s.evaluateSingle();
            if (s == null) {
                return false;
            }
            return item.getBooleanValue();
        }
        if (tag.equals("assert-deep-eq")) {
            if (outcome.isException()) {
                return false;
            }
            XPathSelector s = assertXpc.compile("deep-equal($result , (" + assertion.getStringValue() + "))").load();
            s.setVariable(new QName("result"), outcome.getResult());
            return ((XdmAtomicValue)s.evaluate()).getBooleanValue();
        }
        if (tag.equals("assert-permutation")) {
            if (outcome.isException()) {
                return false;
            }
            try {
                int expectedItems = 0;
                HashSet<Object> expected = new HashSet<Object>();
                XPathSelector s = assertXpc.compile("(" + assertion.getStringValue() + ")").load();
                s.setVariable(new QName("result"), outcome.getResult());
                CodepointCollator collator = CodepointCollator.getInstance();
                XPathContextMajor context = new XPathContextMajor((Item)StringValue.EMPTY_STRING, assertXpc.getUnderlyingStaticContext().getConfiguration());
                for (XdmItem item : s) {
                    ++expectedItems;
                    AtomicValue value = (AtomicValue)item.getUnderlyingValue();
                    Object comparable = value.isNaN() ? new StructuredQName("saxon", "http://saxon.sf.net/collation-key", "NaN") : value.getXPathComparable(false, collator, context);
                    expected.add(comparable);
                }
                int actualItems = 0;
                for (XdmItem item : outcome.getResult()) {
                    ++actualItems;
                    AtomicValue value = (AtomicValue)item.getUnderlyingValue();
                    Object comparable = value.isNaN() ? new StructuredQName("saxon", "http://saxon.sf.net/collation-key", "NaN") : value.getXPathComparable(false, collator, context);
                    if (expected.contains(comparable)) continue;
                    return false;
                }
                return actualItems == expectedItems;
            }
            catch (NoDynamicContextException e) {
                return false;
            }
        }
        if (tag.equals("assert-serialization")) {
            if (outcome.isException()) {
                return false;
            }
            String normalizeAtt = assertion.getAttributeValue(new QName("normalize-space"));
            boolean normalize = normalizeAtt != null && ("true".equals(normalizeAtt.trim()) || "1".equals(normalizeAtt.trim()));
            String ignoreAtt = assertion.getAttributeValue(new QName("ignore-prefixes"));
            boolean ignorePrefixes = ignoreAtt != null && ("true".equals(ignoreAtt.trim()) || "1".equals(ignoreAtt.trim()));
            String comparand = catalogXpc.evaluate("if (@file) then unparsed-text(resolve-uri(@file, base-uri(.))) else string(.)", assertion).toString();
            if (normalize) {
                comparand = ((Object)Whitespace.collapseWhitespace(comparand)).toString();
            }
            StringWriter sw = new StringWriter();
            Serializer serializer = assertXpc.getProcessor().newSerializer(sw);
            serializer.setOutputProperty(Serializer.Property.METHOD, "xml");
            serializer.setOutputProperty(Serializer.Property.INDENT, "no");
            serializer.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes");
            XdmValue value = outcome.getResult();
            if (value instanceof XdmNode) {
                serializer.serializeNode((XdmNode)value);
            } else {
                sw.append("Test-driver limitation: Cannot serialize a non-node value");
            }
            if (comparand.equals(sw.toString())) {
                return true;
            }
            DocumentBuilder builder = assertXpc.getProcessor().newDocumentBuilder();
            StringReader reader = new StringReader("<z>" + comparand + "</z>");
            XdmNode expected = builder.build(new StreamSource(reader));
            int flag = 0;
            flag |= 4;
            flag |= 8;
            if (!ignorePrefixes) {
                flag |= 1;
                flag |= 2;
            }
            flag |= 0x20;
            flag |= 0x80;
            try {
                XdmValue v = outcome.getResult();
                SequenceIterator iter0 = v.size() == 1 && v.itemAt(0) instanceof XdmNode && ((XdmNode)v.itemAt(0)).getNodeKind() == XdmNodeKind.DOCUMENT ? ((XdmNode)v.itemAt(0)).getUnderlyingNode().iterateAxis((byte)3) : Value.asIterator(outcome.getResult().getUnderlyingValue());
                AxisIterator iter1 = ((NodeInfo)expected.axisIterator(Axis.CHILD).next().getUnderlyingValue()).iterateAxis((byte)3);
                return DeepEqual.deepEquals(iter0, iter1, new GenericAtomicComparer(CodepointCollator.getInstance(), null), assertXpc.getProcessor().getUnderlyingConfiguration(), flag);
            }
            catch (XPathException e) {
                e.printStackTrace();
                return false;
            }
        }
        if (tag.equals("assert-serialization-error")) {
            if (outcome.isException()) {
                return false;
            }
            String expectedError = assertion.getAttributeValue(new QName("code"));
            StringWriter sw = new StringWriter();
            Serializer serializer = assertXpc.getProcessor().newSerializer(sw);
            serializer.setOutputProperty(Serializer.Property.METHOD, "xml");
            serializer.setOutputProperty(Serializer.Property.INDENT, "no");
            serializer.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes");
            XdmValue value = outcome.getResult();
            if (value instanceof XdmNode) {
                try {
                    serializer.serializeNodeToString((XdmNode)value);
                    return false;
                }
                catch (SaxonApiException err) {
                    boolean b = expectedError.equals(err.getErrorCode().getLocalName());
                    if (!b) {
                        System.err.println("Expected " + expectedError + ", got " + err.getErrorCode().getLocalName());
                    }
                    return true;
                }
            }
            System.err.println("This test driver cannot test serialization errors unless the result is a node");
        } else {
            if (tag.equals("assert-empty")) {
                if (outcome.isException()) {
                    return false;
                }
                XdmValue result = outcome.getResult();
                return result.size() == 0;
            }
            if (tag.equals("assert-count")) {
                if (outcome.isException()) {
                    return false;
                }
                XdmValue result = outcome.getResult();
                return result.size() == Integer.parseInt(assertion.getStringValue());
            }
            if (tag.equals("assert")) {
                if (outcome.isException()) {
                    return false;
                }
                XPathSelector s = assertXpc.compile(assertion.getStringValue()).load();
                s.setVariable(new QName("result"), outcome.getResult());
                return ((XdmAtomicValue)s.evaluateSingle()).getBooleanValue();
            }
            if (tag.equals("assert-string-value")) {
                String resultString;
                if (outcome.isException()) {
                    return false;
                }
                XdmValue resultValue = outcome.getResult();
                String assertionString = assertion.getStringValue();
                if (resultValue instanceof XdmItem) {
                    resultString = ((XdmItem)resultValue).getStringValue();
                } else {
                    boolean first = true;
                    FastStringBuffer fsb = new FastStringBuffer(256);
                    for (XdmItem item : resultValue) {
                        if (first) {
                            first = false;
                        } else {
                            fsb.append(' ');
                        }
                        fsb.append(item.getStringValue());
                    }
                    resultString = fsb.toString();
                }
                String normalizeAtt = assertion.getAttributeValue(new QName("normalize-space"));
                if (normalizeAtt != null && (normalizeAtt.trim().equals("true") || normalizeAtt.trim().equals("1"))) {
                    assertionString = ((Object)Whitespace.collapseWhitespace(assertionString)).toString();
                    resultString = ((Object)Whitespace.collapseWhitespace(resultString)).toString();
                }
                if (resultString.equals(assertionString)) {
                    return true;
                }
                if (debug) {
                    if (resultString.length() != assertionString.length()) {
                        System.err.println("Result length " + resultString.length() + "; expected length " + assertionString.length());
                    }
                    int len = Math.min(resultString.length(), assertionString.length());
                    for (int i = 0; i < len; ++i) {
                        if (resultString.charAt(i) == assertionString.charAt(i)) continue;
                        System.err.println("Results differ at index " + i + "(\"" + resultString.substring(i, i + 10 > len ? len : i + 10) + "\") vs (\"" + assertionString.substring(i, i + 10 > len ? len : i + 10) + "\")");
                        break;
                    }
                }
                return false;
            }
            if (tag.equals("assert-type")) {
                if (outcome.isException()) {
                    return false;
                }
                XPathSelector s = assertXpc.compile("$result instance of " + assertion.getStringValue()).load();
                s.setVariable(new QName("result"), outcome.getResult());
                return ((XdmAtomicValue)s.evaluateSingle()).getBooleanValue();
            }
            if (tag.equals("assert-true")) {
                if (outcome.isException()) {
                    return false;
                }
                XdmValue result = outcome.getResult();
                return result.size() == 1 && result.itemAt(0).isAtomicValue() && ((XdmAtomicValue)result.itemAt(0)).getPrimitiveTypeName().equals(QName.XS_BOOLEAN) && ((XdmAtomicValue)result.itemAt(0)).getBooleanValue();
            }
            if (tag.equals("assert-false")) {
                if (outcome.isException()) {
                    return false;
                }
                XdmValue result = outcome.getResult();
                return result.size() == 1 && result.itemAt(0).isAtomicValue() && ((XdmAtomicValue)result.itemAt(0)).getPrimitiveTypeName().equals(QName.XS_BOOLEAN) && !((XdmAtomicValue)result.itemAt(0)).getBooleanValue();
            }
            if (tag.equals("error")) {
                String expectedError = assertion.getAttributeValue(new QName("code"));
                return outcome.isException() && (expectedError.equals("*") || outcome.getException().getErrorCode() != null && outcome.getException().getErrorCode().getLocalName().equals(expectedError));
            }
            if (tag.equals("all-of")) {
                for (XdmItem child : catalogXpc.evaluate("*", assertion)) {
                    if (this.testAssertion((XdmNode)child, outcome, assertXpc, catalogXpc, debug)) continue;
                    return false;
                }
                return true;
            }
            if (tag.equals("any-of")) {
                for (XdmItem child : catalogXpc.evaluate("*", assertion)) {
                    if (!this.testAssertion((XdmNode)child, outcome, assertXpc, catalogXpc, debug)) continue;
                    return true;
                }
                return false;
            }
        }
        throw new IllegalStateException("Unknown assertion element " + tag);
    }

    private void writeResultFilePreamble(Processor processor, XdmNode catalog, String date) throws IOException, SaxonApiException, XMLStreamException {
        BufferedWriter resultWriter = new BufferedWriter(new FileWriter(new File("results/saxon/results" + Version.getProductVersion() + ".xml")));
        Serializer serializer = processor.newSerializer(resultWriter);
        serializer.setOutputProperty(Serializer.Property.METHOD, "xml");
        serializer.setOutputProperty(Serializer.Property.INDENT, "yes");
        serializer.setOutputProperty(Serializer.Property.SAXON_LINE_LENGTH, "120");
        this.results = serializer.getXMLStreamWriter();
        this.results.writeStartElement("FOTS-test-suite-result");
        this.results.writeDefaultNamespace(RNS);
        this.results.writeStartElement("implementation");
        this.results.writeAttribute("name", "Saxon-EE");
        this.results.writeAttribute("version", Version.getProductVersion());
        this.results.writeAttribute("anonymous-result-column", "false");
        this.results.writeEmptyElement("organization");
        this.results.writeAttribute("name", "http://www.saxonica.com/");
        this.results.writeAttribute("anonymous", "false");
        this.results.writeEmptyElement("submitter");
        this.results.writeAttribute("name", "Michael Kay");
        this.results.writeAttribute("email", "mike@saxonica.com");
        this.results.writeEndElement();
        this.results.writeEmptyElement("test-run");
        this.results.writeAttribute("dateRun", date);
        this.results.writeAttribute("testsuiteVersion", catalog.getAttributeValue(new QName("test-suite")) + " " + catalog.getAttributeValue(new QName("version")));
    }

    private void writeResultFilePostamble() throws XMLStreamException {
        this.results.writeEndElement();
        this.results.close();
    }

    private void writeTestcaseElement(String name, String result, String comment) {
        try {
            this.results.writeEmptyElement("testcase");
            this.results.writeAttribute("name", name);
            this.results.writeAttribute("result", result);
            if (comment != null) {
                this.results.writeAttribute("comment", comment);
            }
        }
        catch (XMLStreamException ex) {
            // empty catch block
        }
    }

    public static class TestURIResolver
    implements URIResolver {
        Environment env;

        public TestURIResolver(Environment env) {
            this.env = env;
        }

        public Source resolve(String href, String base) throws TransformerException {
            XdmNode node = this.env.sourceDocs.get(href);
            if (node == null) {
                return null;
            }
            return node.asSource();
        }
    }

    public static class ModuleResolver
    extends StandardModuleURIResolver {
        XPathCompiler catXPC;
        XdmNode testCase;

        public ModuleResolver(XPathCompiler xpc) {
            this.catXPC = xpc;
        }

        public void setTestCase(XdmNode testCase) {
            this.testCase = testCase;
        }

        public StreamSource[] resolve(String moduleURI, String baseURI, String[] locations) throws XPathException {
            try {
                XdmValue file = this.catXPC.evaluate("./module[@uri='" + moduleURI + "']/@file/string()", this.testCase);
                if (file.size() == 0) {
                    throw new XPathException("Failed to find module entry for " + moduleURI);
                }
                URI uri = this.testCase.getBaseURI().resolve(file.toString());
                StreamSource ss = this.getQuerySource(uri);
                return new StreamSource[]{ss};
            }
            catch (SaxonApiException e) {
                throw new XPathException(e);
            }
        }
    }

    private static class FotsCopyFunction
    extends ExtensionFunctionDefinition {
        private FotsCopyFunction() {
        }

        public StructuredQName getFunctionQName() {
            return new StructuredQName("", "http://www.w3.org/2010/09/qt-fots-catalog", "copy");
        }

        public int getMinimumNumberOfArguments() {
            return 1;
        }

        public int getMaximumNumberOfArguments() {
            return 1;
        }

        public SequenceType[] getArgumentTypes() {
            return new SequenceType[]{SequenceType.SINGLE_NODE};
        }

        public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
            return SequenceType.SINGLE_NODE;
        }

        public boolean hasSideEffects() {
            return true;
        }

        public ExtensionFunctionCall makeCallExpression() {
            return new ExtensionFunctionCall(){

                public SequenceIterator call(SequenceIterator[] arguments, XPathContext context) throws XPathException {
                    NodeInfo node = (NodeInfo)arguments[0].next();
                    if (node == null) {
                        return EmptyIterator.getInstance();
                    }
                    switch (node.getNodeKind()) {
                        case 1: 
                        case 9: {
                            Builder builder = context.getController().makeBuilder();
                            builder.open();
                            node.copy(builder, 2, 0);
                            builder.close();
                            return SingleNodeIterator.makeIterator(builder.getCurrentRoot());
                        }
                        case 2: 
                        case 3: 
                        case 7: 
                        case 8: 
                        case 13: {
                            Orphan orphan = new Orphan(context.getConfiguration());
                            orphan.setNodeKind((short)node.getNodeKind());
                            orphan.setNameCode(node.getNameCode());
                            orphan.setStringValue(node.getStringValue());
                            return SingleNodeIterator.makeIterator(orphan);
                        }
                    }
                    throw new IllegalArgumentException("Unknown node kind " + node.getNodeKind());
                }
            };
        }
    }

    private class Outcome {
        private XdmValue value;
        private SaxonApiException exception;

        public Outcome(XdmValue value) {
            this.value = value;
        }

        public Outcome(SaxonApiException exception) {
            this.exception = exception;
        }

        public boolean isException() {
            return this.exception != null;
        }

        public SaxonApiException getException() {
            return this.exception;
        }

        public XdmValue getResult() {
            return this.value;
        }

        public String toString() {
            return this.isException() ? "EXCEPTION " + this.exception.getMessage() : this.value.toString();
        }

        public String serialize(Processor p) {
            if (this.isException()) {
                return "EXCEPTION " + this.exception.getMessage();
            }
            if (this.value instanceof XdmNode) {
                StringWriter sw = new StringWriter();
                Serializer s = p.newSerializer(sw);
                s.setOutputProperty(Serializer.Property.METHOD, "xml");
                s.setOutputProperty(Serializer.Property.INDENT, "yes");
                s.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes");
                try {
                    s.serializeNodeToString((XdmNode)this.value);
                }
                catch (SaxonApiException err) {
                    return "SERIALIZATION FAILED: " + err.getMessage();
                }
                return sw.toString();
            }
            return this.value.toString();
        }
    }

    private class Environment {
        public Processor processor;
        public Map<String, XdmNode> sourceDocs;
        public XPathCompiler xpathCompiler;
        public XQueryCompiler xqueryCompiler;
        public XdmNode contextNode;
        public HashMap<QName, XdmValue> params = new HashMap();
        public boolean xml11 = false;
        public boolean usable = true;
        public FastStringBuffer paramDeclarations = new FastStringBuffer(256);

        private Environment() {
        }
    }
}

