/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.stream.watch;

import com.saxonica.stream.om.FleetingDocumentNode;
import com.saxonica.stream.om.FleetingElementNode;
import com.saxonica.stream.om.FleetingNode;
import com.saxonica.stream.watch.Watch;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.StartTagBuffer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.IntHashSet;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.AttributeCollectionImpl;
import net.sf.saxon.type.ValidationException;

public class WatchManager
extends ProxyReceiver
implements NamespaceResolver {
    private FleetingDocumentNode documentNode;
    private StartTagBuffer startTagBuffer;
    private FleetingNode[] elementStack = new FleetingNode[20];
    private int[] receiverCountStack = new int[20];
    private int[] namespaceCountStack = new int[20];
    protected int elementStackTop = 0;
    private int[] namespaceStack = new int[20];
    private int namespaceStackTop = 0;
    protected List<Watch> watchList = new ArrayList<Watch>(10);
    protected Stack<List<ClosedownAction>> activeWatchStack = new Stack();
    private Stack<Receiver> activeReceiverStack = new Stack();
    private int lastLocationId = 0;
    private XPathContext context;

    public WatchManager(StartTagBuffer startTagBuffer, Configuration config) {
        long docNr = config.getDocumentNumberAllocator().allocateDocumentNumber();
        this.startTagBuffer = startTagBuffer;
        this.documentNode = new FleetingDocumentNode(docNr);
        this.documentNode.setConfiguration(config);
    }

    public void setXPathContext(XPathContext context) {
        this.context = context;
    }

    public XPathContext getXPathContext() {
        return this.context;
    }

    public StartTagBuffer getStartTagBuffer() {
        return this.startTagBuffer;
    }

    public void startDocument(int properties) throws XPathException {
        this.documentNode.setSystemId(this.getSystemId());
        this.elementStack[this.elementStackTop] = this.documentNode;
        this.receiverCountStack[this.elementStackTop] = 0;
        this.namespaceCountStack[this.elementStackTop++] = 0;
        ArrayList<ClosedownAction> activeWatchList = new ArrayList<ClosedownAction>(4);
        this.activeWatchStack.push(activeWatchList);
        for (int i = 0; i < this.watchList.size(); ++i) {
            Watch watch = this.watchList.get(i);
            boolean matches = watch.getSelection().matches(this.documentNode, this.context);
            if (!matches) continue;
            ClosedownAction action = new ClosedownAction(watch, 0);
            activeWatchList.add(action);
            Receiver out = watch.startSelectedParentNode(this.documentNode, 0);
            if (out == null) continue;
            out.open();
            this.activeReceiverStack.push(out);
            int n = this.elementStackTop - 1;
            this.receiverCountStack[n] = this.receiverCountStack[n] + 1;
        }
        int totalReceivers = this.activeReceiverStack.size();
        for (int i = 0; i < totalReceivers; ++i) {
            Receiver out = (Receiver)this.activeReceiverStack.get(i);
            out.startDocument(properties);
        }
        this.nextReceiver.startDocument(properties);
    }

    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        ValidationException ve = null;
        this.ensureStackSpace();
        FleetingElementNode element = new FleetingElementNode();
        if (this.elementStackTop > 0) {
            element.setParent(this.elementStack[this.elementStackTop - 1]);
        } else {
            element.setParent(this.documentNode);
        }
        element.setNodeKind(1);
        element.setNameCode(nameCode);
        element.setTypeAnnotation(typeCode);
        element.setLocalNamespaces(this.startTagBuffer.getLocalNamespaces());
        element.setAttributes(AttributeCollectionImpl.copy((AttributeCollectionImpl)this.startTagBuffer.getAllAttributes()));
        this.elementStack[this.elementStackTop] = element;
        this.receiverCountStack[this.elementStackTop] = 0;
        this.namespaceCountStack[this.elementStackTop++] = 0;
        ArrayList<ClosedownAction> activeWatchList = new ArrayList<ClosedownAction>(4);
        this.activeWatchStack.push(activeWatchList);
        this.addPrearrangedWatches();
        for (int i = 0; i < this.watchList.size(); ++i) {
            Watch watch = this.watchList.get(i);
            boolean matches = watch.getSelection().matchesBeneathAnchor(element, watch.getAnchorNode(), this.context);
            if (!matches) continue;
            ClosedownAction action = new ClosedownAction(watch, 0);
            activeWatchList.add(action);
            Receiver out = watch.startSelectedParentNode(element, locationId);
            if (out == null) continue;
            out.open();
            this.activeReceiverStack.push(out);
            int n = this.elementStackTop - 1;
            this.receiverCountStack[n] = this.receiverCountStack[n] + 1;
        }
        int totalReceivers = this.activeReceiverStack.size();
        for (int i = 0; i < totalReceivers; ++i) {
            Receiver out = (Receiver)this.activeReceiverStack.get(i);
            try {
                out.startElement(nameCode, typeCode, locationId, properties);
                continue;
            }
            catch (ValidationException err) {
                ve = err;
            }
        }
        int newReceivers = this.receiverCountStack[this.elementStackTop - 1];
        for (int i = totalReceivers - newReceivers; i < totalReceivers; ++i) {
            Receiver out = (Receiver)this.activeReceiverStack.get(i);
            for (int n = 0; n < this.namespaceStackTop; ++n) {
                out.namespace(this.namespaceStack[n], 0);
            }
        }
        this.nextReceiver.startElement(nameCode, typeCode, locationId, properties);
        if (ve != null) {
            throw ve;
        }
        this.lastLocationId = locationId;
    }

    private void ensureStackSpace() {
        if (this.elementStackTop + 1 > this.elementStack.length) {
            FleetingNode[] s = new FleetingNode[this.elementStackTop * 2];
            System.arraycopy(this.elementStack, 0, s, 0, this.elementStackTop);
            this.elementStack = s;
            int[] a = new int[this.elementStackTop * 2];
            System.arraycopy(this.receiverCountStack, 0, a, 0, this.elementStackTop);
            this.receiverCountStack = a;
            int[] n = new int[this.elementStackTop * 2];
            System.arraycopy(this.namespaceCountStack, 0, n, 0, this.elementStackTop);
            this.namespaceCountStack = n;
        }
    }

    protected void addPrearrangedWatches() throws XPathException {
    }

    public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        int i;
        FleetingNode att = new FleetingNode();
        att.setNodeKind(2);
        att.setNameCode(nameCode);
        att.setTypeAnnotation(typeCode);
        att.setParent(this.elementStack[this.elementStackTop - 1]);
        att.setStringValue(value);
        for (i = 0; i < this.watchList.size(); ++i) {
            Watch watch = this.watchList.get(i);
            boolean matches = watch.getSelection().matchesBeneathAnchor(att, watch.getAnchorNode(), this.context);
            if (!matches) continue;
            watch.notifySelectedLeafNode(att, locationId);
        }
        for (i = 0; i < this.activeReceiverStack.size(); ++i) {
            Receiver out = (Receiver)this.activeReceiverStack.get(i);
            out.attribute(nameCode, typeCode, value, locationId, properties);
        }
        this.nextReceiver.attribute(nameCode, typeCode, value, locationId, properties);
        this.lastLocationId = locationId;
    }

    public void namespace(int namespaceCode, int properties) throws XPathException {
        int n = this.elementStackTop - 1;
        this.namespaceCountStack[n] = this.namespaceCountStack[n] + 1;
        if (this.namespaceStackTop >= this.namespaceStack.length) {
            int[] n2 = new int[this.namespaceStackTop * 2];
            System.arraycopy(this.namespaceStack, 0, n2, 0, this.namespaceStackTop);
            this.namespaceStack = n2;
        }
        this.namespaceStack[this.namespaceStackTop++] = namespaceCode;
        for (int i = 0; i < this.activeReceiverStack.size(); ++i) {
            Receiver out = (Receiver)this.activeReceiverStack.get(i);
            out.namespace(namespaceCode, properties);
        }
        this.nextReceiver.namespace(namespaceCode, properties);
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        int i;
        this.ensureStackSpace();
        FleetingNode node = new FleetingNode();
        node.setNodeKind(3);
        node.setParent(this.elementStack[this.elementStackTop - 1]);
        node.setStringValue(chars);
        for (i = 0; i < this.watchList.size(); ++i) {
            Watch watch = this.watchList.get(i);
            boolean matches = watch.getSelection().matchesBeneathAnchor(node, watch.getAnchorNode(), this.context);
            if (!matches) continue;
            watch.notifySelectedLeafNode(node, locationId);
        }
        for (i = 0; i < this.activeReceiverStack.size(); ++i) {
            Receiver out = (Receiver)this.activeReceiverStack.get(i);
            out.characters(chars, locationId, properties);
        }
        this.nextReceiver.characters(chars, locationId, properties);
        this.lastLocationId = locationId;
    }

    public void endElement() throws XPathException {
        for (int i = 0; i < this.activeReceiverStack.size(); ++i) {
            Receiver out = (Receiver)this.activeReceiverStack.get(i);
            out.endElement();
        }
        --this.elementStackTop;
        this.namespaceStackTop -= this.namespaceCountStack[this.elementStackTop];
        int drop = this.receiverCountStack[this.elementStackTop];
        this.receiverCountStack[this.elementStackTop] = 0;
        for (int i = 0; i < drop; ++i) {
            Receiver out = this.activeReceiverStack.pop();
            out.close();
        }
        List<ClosedownAction> activeWatchList = this.activeWatchStack.pop();
        for (int i = activeWatchList.size() - 1; i >= 0; --i) {
            ClosedownAction action = activeWatchList.get(i);
            if (action.action == 0) {
                action.watch.endSelectedParentNode(this.lastLocationId);
                continue;
            }
            action.watch.close();
            this.watchList.remove(action.watch);
        }
        this.nextReceiver.endElement();
    }

    public void endDocument() throws XPathException {
        for (int i = 0; i < this.activeReceiverStack.size(); ++i) {
            Receiver out = (Receiver)this.activeReceiverStack.get(i);
            out.endDocument();
        }
        --this.elementStackTop;
        int drop = this.receiverCountStack[this.elementStackTop];
        this.receiverCountStack[this.elementStackTop] = 0;
        for (int i = 0; i < drop; ++i) {
            Receiver out = this.activeReceiverStack.pop();
            out.close();
        }
        List<ClosedownAction> activeWatchList = this.activeWatchStack.pop();
        for (int i = activeWatchList.size() - 1; i >= 0; --i) {
            ClosedownAction action = activeWatchList.get(i);
            if (action.action == 0) {
                action.watch.endSelectedParentNode(this.lastLocationId);
                continue;
            }
            action.watch.close();
            this.watchList.remove(action.watch);
        }
        this.nextReceiver.endDocument();
    }

    public void comment(CharSequence chars, int locationId, int properties) throws XPathException {
        int i;
        this.ensureStackSpace();
        FleetingNode node = new FleetingNode();
        node.setNodeKind(8);
        node.setParent(this.elementStack[this.elementStackTop - 1]);
        node.setStringValue(chars);
        for (i = 0; i < this.watchList.size(); ++i) {
            Watch watch = this.watchList.get(i);
            boolean matches = watch.getSelection().matchesBeneathAnchor(node, watch.getAnchorNode(), this.context);
            if (!matches) continue;
            watch.notifySelectedLeafNode(node, locationId);
        }
        for (i = 0; i < this.activeReceiverStack.size(); ++i) {
            Receiver out = (Receiver)this.activeReceiverStack.get(i);
            out.comment(chars, locationId, properties);
        }
        this.nextReceiver.comment(chars, locationId, properties);
        this.lastLocationId = locationId;
    }

    public void processingInstruction(String target, CharSequence data, int locationId, int properties) throws XPathException {
        int i;
        this.ensureStackSpace();
        FleetingNode node = new FleetingNode();
        node.setNodeKind(7);
        node.setParent(this.elementStack[this.elementStackTop - 1]);
        node.setNameCode(this.getNamePool().allocate("", "", target));
        node.setStringValue(data);
        for (i = 0; i < this.watchList.size(); ++i) {
            Watch watch = this.watchList.get(i);
            boolean matches = watch.getSelection().matchesBeneathAnchor(node, watch.getAnchorNode(), this.context);
            if (!matches) continue;
            watch.notifySelectedLeafNode(node, locationId);
        }
        for (i = 0; i < this.activeReceiverStack.size(); ++i) {
            Receiver out = (Receiver)this.activeReceiverStack.get(i);
            out.processingInstruction(target, data, locationId, properties);
        }
        this.nextReceiver.processingInstruction(target, data, locationId, properties);
        this.lastLocationId = locationId;
    }

    public void startContent() throws XPathException {
        for (int i = 0; i < this.activeReceiverStack.size(); ++i) {
            Receiver out = (Receiver)this.activeReceiverStack.get(i);
            out.startContent();
        }
        this.nextReceiver.startContent();
    }

    public void addWatch(Watch watch) throws XPathException {
        watch.open();
        this.watchList.add(watch);
        watch.setPipelineConfiguration(this.getPipelineConfiguration());
        watch.setNamespaceResolver(this);
        if (this.elementStackTop > 0) {
            watch.setAnchorNode(this.elementStack[this.elementStackTop - 1]);
            this.activeWatchStack.peek().add(new ClosedownAction(watch, 1));
        }
    }

    public String getURIForPrefix(String prefix, boolean useDefault) {
        NamePool pool = this.getNamePool();
        if (!useDefault && prefix.length() == 0) {
            return "";
        }
        short prefixCode = pool.getCodeForPrefix(prefix);
        if (prefixCode == -1) {
            return null;
        }
        for (int i = this.namespaceStackTop - 1; i >= 0; --i) {
            if (this.namespaceStack[i] >> 16 != prefixCode) continue;
            int uriCode = this.namespaceStack[i] & 0xFFFF;
            if (uriCode == 0) {
                if (prefixCode == 0) {
                    return "";
                }
                return null;
            }
            return pool.getURIFromURICode((short)uriCode);
        }
        if (prefixCode == 0) {
            return "";
        }
        return null;
    }

    public Iterator iteratePrefixes() {
        NamePool pool = this.getNamePool();
        HashSet<String> declaredPrefixes = new HashSet<String>(5);
        IntHashSet undeclaredPrefixes = new IntHashSet(5);
        for (int i = this.namespaceStackTop - 1; i >= 0; --i) {
            int prefixCode = this.namespaceStack[i] >> 16;
            int uriCode = this.namespaceStack[i] & 0xFFFF;
            if (uriCode == 0) {
                undeclaredPrefixes.add(prefixCode);
                continue;
            }
            if (undeclaredPrefixes.contains(prefixCode)) continue;
            declaredPrefixes.add(pool.getPrefixFromNamespaceCode(this.namespaceStack[i]));
        }
        return declaredPrefixes.iterator();
    }

    public boolean usesTypeAnnotations() {
        return true;
    }

    public FleetingDocumentNode getDocumentNode() {
        return this.documentNode;
    }

    private static class ClosedownAction {
        public static final int DEACTIVATE = 0;
        public static final int CLOSE = 1;
        public Watch watch;
        public int action;

        public ClosedownAction(Watch watch, int action) {
            this.watch = watch;
            this.action = action;
        }
    }
}

