/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.stream.watch;

import com.saxonica.stream.feed.Feed;
import com.saxonica.stream.om.FleetingDocumentNode;
import com.saxonica.stream.om.FleetingElementNode;
import com.saxonica.stream.om.FleetingNode;
import com.saxonica.stream.watch.ComposingWatch;
import com.saxonica.stream.watch.StringValueAccumulator;
import com.saxonica.stream.watch.Watch;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleContentWatch
extends ComposingWatch
implements Watch {
    Stack<PendingItem> nodesUnderConstructionStack = new Stack();
    List<Value> itemsReadyToBeOutput = new ArrayList<Value>(5);
    FastStringBuffer buffer = new FastStringBuffer(100);

    public SimpleContentWatch(Feed result, Stack<XPathContext> contextStack) {
        super(result, contextStack);
    }

    @Override
    public Receiver startSelectedParentNode(FleetingNode node, int locationId) throws XPathException {
        FastStringBuffer nodeValueBuffer = new FastStringBuffer(100);
        PendingItem item = new PendingItem(this.itemsReadyToBeOutput.size(), node, nodeValueBuffer);
        this.nodesUnderConstructionStack.push(item);
        this.itemsReadyToBeOutput.add(StringValue.EMPTY_STRING);
        return new StringValueAccumulator(nodeValueBuffer);
    }

    @Override
    public void endSelectedParentNode(int locationId) throws XPathException {
        Value typedValue;
        PendingItem pendingItem = this.nodesUnderConstructionStack.pop();
        int seq = pendingItem.sequence;
        if (pendingItem.node instanceof FleetingElementNode) {
            FleetingElementNode element = (FleetingElementNode)pendingItem.node;
            element.setStringValue(pendingItem.buffer);
            typedValue = (Value)SequenceExtent.makeSequenceExtent(element.getTypedValue());
            this.itemsReadyToBeOutput.set(seq, typedValue);
        } else {
            FleetingDocumentNode document = (FleetingDocumentNode)pendingItem.node;
            document.setStringValue(pendingItem.buffer);
            typedValue = (Value)SequenceExtent.makeSequenceExtent(document.getTypedValue());
            this.itemsReadyToBeOutput.set(seq, typedValue);
        }
        if (this.nodesUnderConstructionStack.isEmpty()) {
            this.flushTextNodes();
            for (int i = 0; i < this.itemsReadyToBeOutput.size(); ++i) {
                AtomicValue av;
                Value val = this.itemsReadyToBeOutput.get(i);
                SequenceIterator iter = val.iterate();
                while ((av = (AtomicValue)iter.next()) != null) {
                    this.getResult().append(av);
                }
            }
            this.itemsReadyToBeOutput.clear();
        }
    }

    private void flushTextNodes() throws XPathException {
        if (this.buffer.length() != 0) {
            this.getResult().append(new StringValue(this.buffer.toString()));
            this.buffer.setLength(0);
        }
    }

    @Override
    public void notifySelectedLeafNode(FleetingNode node, int locationId) throws XPathException {
        if (node.getNodeKind() == 3) {
            if (node.getStringValueCS().length() != 0) {
                if (this.nodesUnderConstructionStack.isEmpty()) {
                    this.buffer.append(node.getStringValueCS());
                } else {
                    PendingItem pendingItem = this.nodesUnderConstructionStack.peek();
                    pendingItem.buffer.append(node.getStringValueCS());
                }
            }
        } else if (this.nodesUnderConstructionStack.isEmpty()) {
            AtomicValue item;
            this.flushTextNodes();
            SequenceIterator iter = node.getTypedValue();
            while ((item = (AtomicValue)iter.next()) != null) {
                this.getResult().append(item);
            }
        } else {
            PendingItem pendingItem = this.nodesUnderConstructionStack.peek();
            if (pendingItem.buffer.length() != 0) {
                this.itemsReadyToBeOutput.add(new StringValue(pendingItem.buffer.toString()));
                pendingItem.buffer.setLength(0);
            }
            this.itemsReadyToBeOutput.add((Value)SequenceExtent.makeSequenceExtent(node.getTypedValue()));
        }
    }

    @Override
    public final void close() throws XPathException {
        this.flushTextNodes();
        this.getResult().close();
    }

    private static class PendingItem {
        public int sequence;
        public FleetingNode node;
        public FastStringBuffer buffer;

        public PendingItem(int sequence, FleetingNode element, FastStringBuffer buffer) {
            this.sequence = sequence;
            this.node = element;
            this.buffer = buffer;
        }
    }
}

