/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.stream.watch;

import com.saxonica.stream.ManualIterator;
import com.saxonica.stream.feed.Feed;
import com.saxonica.stream.om.FleetingNode;
import com.saxonica.stream.watch.ComposingWatch;
import java.util.Stack;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.ForEach;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForEachComposingWatch
extends ComposingWatch {
    private XPathContext localContext;
    private Expression action;

    public ForEachComposingWatch(ForEach expression, Feed result, Stack<XPathContext> contextStack) {
        super(result, contextStack);
        this.action = expression.getActionExpression();
    }

    @Override
    public void open() throws XPathException {
        super.open();
        this.localContext = this.getContext().newContext();
        ManualIterator iter = new ManualIterator();
        this.localContext.setCurrentIterator(iter);
        this.getContextStack().push(this.localContext);
    }

    @Override
    public Receiver startSelectedParentNode(FleetingNode node, int locationId) throws XPathException {
        Item item;
        ManualIterator iter = (ManualIterator)this.localContext.getCurrentIterator();
        iter.setContextItem(node);
        iter.incrementPosition();
        Feed parentFeed = this.getResult();
        SequenceIterator stepIter = this.action.iterate(this.localContext);
        while ((item = stepIter.next()) != null) {
            parentFeed.append(item);
        }
        return null;
    }

    @Override
    public void notifySelectedLeafNode(FleetingNode node, int locationId) throws XPathException {
        Item item;
        ManualIterator iter = (ManualIterator)this.localContext.getCurrentIterator();
        iter.setContextItem(node);
        iter.incrementPosition();
        Feed parentFeed = this.getResult();
        SequenceIterator stepIter = this.action.iterate(this.localContext);
        while ((item = stepIter.next()) != null) {
            parentFeed.append(item);
        }
    }

    @Override
    public void endSelectedParentNode(int locationId) throws XPathException {
    }

    @Override
    public void close() throws XPathException {
        this.getContextStack().pop();
        super.close();
    }
}

