/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.stream.watch;

import com.saxonica.stream.feed.Feed;
import com.saxonica.stream.om.FleetingNode;
import com.saxonica.stream.watch.ComposingWatch;
import com.saxonica.stream.watch.Watch;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.tree.util.Orphan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyOfWatch
extends ComposingWatch
implements Watch {
    Stack<PendingItem> nodesUnderConstructionStack = new Stack();
    List<NodeInfo> nodesReadyToBeOutput = new ArrayList<NodeInfo>(5);
    int forestSize = 0;
    TinyBuilder previousBuilder;

    public CopyOfWatch(Feed result, Stack<XPathContext> contextStack) {
        super(result, contextStack);
    }

    @Override
    public Receiver startSelectedParentNode(FleetingNode node, int locationId) throws XPathException {
        TinyBuilder builder;
        if (this.nodesReadyToBeOutput.isEmpty()) {
            if (this.forestSize < 50 && this.previousBuilder != null) {
                builder = this.previousBuilder;
                ++this.forestSize;
            } else {
                this.forestSize = 0;
                this.previousBuilder = builder = new TinyBuilder();
            }
        } else {
            builder = new TinyBuilder();
        }
        builder.setPipelineConfiguration(this.getPipelineConfiguration());
        PendingItem item = new PendingItem(this.nodesReadyToBeOutput.size(), builder);
        this.nodesReadyToBeOutput.add(new Orphan(this.getPipelineConfiguration().getConfiguration()));
        this.nodesUnderConstructionStack.push(item);
        return builder;
    }

    @Override
    public void notifySelectedLeafNode(FleetingNode node, int locationId) throws XPathException {
        if (node.getNodeKind() == 2) {
            Configuration config = this.getPipelineConfiguration().getConfiguration();
            Orphan orphan = new Orphan(config);
            orphan.setNodeKind((short)node.getNodeKind());
            orphan.setNameCode(node.getNameCode());
            orphan.setStringValue(node.getStringValue());
            orphan.setTypeAnnotation(node.getTypeAnnotation());
            if (this.nodesUnderConstructionStack.isEmpty()) {
                this.getResult().append(orphan);
            } else {
                this.nodesReadyToBeOutput.add(orphan);
            }
        }
    }

    @Override
    public void endSelectedParentNode(int locationId) throws XPathException {
        PendingItem item = this.nodesUnderConstructionStack.pop();
        TinyBuilder builder = item.builder;
        int seq = item.sequence;
        NodeInfo root = builder.getCurrentRoot();
        builder.reset();
        this.nodesReadyToBeOutput.set(seq, root);
        if (this.nodesUnderConstructionStack.isEmpty()) {
            for (int i = 0; i < this.nodesReadyToBeOutput.size(); ++i) {
                this.getResult().append(this.nodesReadyToBeOutput.get(i));
            }
            this.nodesReadyToBeOutput.clear();
        }
    }

    private static class PendingItem {
        public int sequence;
        public TinyBuilder builder;

        public PendingItem(int sequence, TinyBuilder builder) {
            this.sequence = sequence;
            this.builder = builder;
        }
    }
}

