/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.stream.om;

import com.saxonica.stream.om.FleetingDocumentNode;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.Axis;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.FingerprintedNode;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

public class FleetingNode
implements NodeInfo,
FingerprintedNode {
    private FleetingNode parent;
    protected FleetingDocumentNode root;
    private int nodeKind;
    private int nameCode;
    private int typeAnnotation;
    private CharSequence stringValue;
    private int nodeNumber;

    public void setParent(FleetingNode parent) {
        this.parent = parent;
        this.root = parent.root;
        this.nodeNumber = this.root.allocateNodeNumber();
    }

    public void setNameCode(int nameCode) {
        this.nameCode = nameCode;
    }

    public void setNodeKind(int nodeKind) {
        this.nodeKind = nodeKind;
    }

    public void setStringValue(CharSequence stringValue) {
        this.stringValue = stringValue;
    }

    public void setTypeAnnotation(int typeAnnotation) {
        this.typeAnnotation = typeAnnotation;
    }

    public int getNodeKind() {
        return this.nodeKind;
    }

    public boolean isSameNodeInfo(NodeInfo other) {
        throw new UnsupportedOperationException("Node identity not supported for streamed nodes");
    }

    public String getSystemId() {
        return this.root.getSystemId();
    }

    public String getBaseURI() {
        return Navigator.getBaseURI(this);
    }

    public int getLineNumber() {
        return -1;
    }

    public int getColumnNumber() {
        return -1;
    }

    public int compareOrder(NodeInfo other) {
        throw new UnsupportedOperationException("Document order is not supported for streamed nodes");
    }

    public String getStringValue() {
        return ((Object)this.stringValue).toString();
    }

    public int getNameCode() {
        return this.nameCode;
    }

    public int getFingerprint() {
        return this.nameCode == -1 ? -1 : this.nameCode & 0xFFFFF;
    }

    public String getLocalPart() {
        return this.getNamePool().getLocalName(this.nameCode);
    }

    public String getURI() {
        return this.getNamePool().getURI(this.nameCode);
    }

    public String getDisplayName() {
        return this.getNamePool().getDisplayName(this.nameCode);
    }

    public String getPrefix() {
        return this.getNamePool().getPrefix(this.nameCode);
    }

    public Configuration getConfiguration() {
        return this.root.getConfiguration();
    }

    public NamePool getNamePool() {
        return this.root.getNamePool();
    }

    public int getTypeAnnotation() {
        return this.typeAnnotation;
    }

    public Value atomize() throws XPathException {
        SchemaType type = this.getConfiguration().getSchemaType(this.typeAnnotation);
        return (Value)SequenceExtent.makeSequenceExtent(type.getTypedValue(this));
    }

    public NodeInfo getParent() {
        return this.parent;
    }

    public AxisIterator iterateAxis(byte axisNumber) {
        return this.iterateAxis(axisNumber, AnyNodeTest.getInstance());
    }

    public AxisIterator iterateAxis(byte axisNumber, NodeTest nodeTest) {
        if (Axis.isAlwaysEmpty(axisNumber, this.nodeKind)) {
            return EmptyIterator.getInstance();
        }
        switch (axisNumber) {
            case 0: {
                if (this.nodeKind == 9) {
                    return EmptyIterator.getInstance();
                }
                return new Navigator.AxisFilter(new Navigator.AncestorEnumeration(this, false), nodeTest);
            }
            case 1: {
                if (this.nodeKind == 9) {
                    return Navigator.filteredSingleton(this, nodeTest);
                }
                return new Navigator.AxisFilter(new Navigator.AncestorEnumeration(this, true), nodeTest);
            }
            case 9: {
                return Navigator.filteredSingleton(this.getParent(), nodeTest);
            }
            case 12: {
                return Navigator.filteredSingleton(this, nodeTest);
            }
            case 2: {
                return EmptyIterator.getInstance();
            }
            case 8: {
                return EmptyIterator.getInstance();
            }
        }
        XPathException err = new XPathException("Navigation using " + Axis.axisName[axisNumber] + " axis is not supported in streaming mode", "SXST0061");
        throw new UnsupportedOperationException(err);
    }

    public String getAttributeValue(int fingerprint) {
        return null;
    }

    public NodeInfo getRoot() {
        return this.root;
    }

    public DocumentInfo getDocumentRoot() {
        return this.root;
    }

    public boolean hasChildNodes() {
        return false;
    }

    public void generateId(FastStringBuffer buffer) {
        buffer.append("d" + this.root.getDocumentNumber());
        buffer.append("f" + this.nodeNumber);
    }

    public long getDocumentNumber() {
        return this.root.getDocumentNumber();
    }

    public void copy(Receiver out, int copyOptions, int locationId) throws XPathException {
        Navigator.copy(this, out, this.getNamePool(), copyOptions, locationId);
    }

    public int[] getDeclaredNamespaces(int[] buffer) {
        return null;
    }

    public boolean isId() {
        return false;
    }

    public boolean isIdref() {
        return false;
    }

    public boolean isNilled() {
        return false;
    }

    public void setSystemId(String systemId) {
    }

    public CharSequence getStringValueCS() {
        return this.stringValue;
    }

    public SequenceIterator getTypedValue() throws XPathException {
        switch (this.getNodeKind()) {
            case 1: 
            case 2: {
                SchemaType type = this.getConfiguration().getSchemaType(this.typeAnnotation);
                return type.getTypedValue(this);
            }
        }
        return SingletonIterator.makeIterator(new UntypedAtomicValue(this.getStringValueCS()));
    }
}

