/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.stream.om;

import com.saxonica.stream.om.FleetingElementNode;
import com.saxonica.stream.om.FleetingNode;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.iter.AxisIteratorImpl;
import net.sf.saxon.tree.iter.LookaheadIterator;

final class AttributeIterator
extends AxisIteratorImpl
implements LookaheadIterator {
    private FleetingElementNode element;
    private AttributeCollection attributes;
    private NodeTest nodeTest;
    private FleetingNode next;
    private int index;
    private int length;

    public AttributeIterator(FleetingElementNode element, AttributeCollection attributes, NodeTest nodeTest) {
        this.nodeTest = nodeTest;
        if (element.getNodeKind() == 1) {
            this.element = element;
            this.attributes = attributes;
            this.index = 0;
            if (nodeTest instanceof NameTest) {
                NameTest test = (NameTest)nodeTest;
                this.index = attributes.getIndexByFingerprint(test.getFingerprint());
                if (this.index < 0) {
                    this.next = null;
                } else {
                    this.next = AttributeIterator.makeAttributeNode(element, attributes, this.index);
                    this.index = 0;
                    this.length = 0;
                }
            } else {
                this.index = 0;
                this.length = attributes.getLength();
                this.advance();
            }
        } else {
            this.next = null;
            this.index = 0;
            this.length = 0;
        }
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public Item next() {
        if (this.next == null) {
            this.current = null;
            this.position = -1;
            return null;
        }
        this.current = this.next;
        ++this.position;
        this.advance();
        return this.current;
    }

    private void advance() {
        do {
            if (this.index >= this.length) {
                this.next = null;
                return;
            }
            this.next = AttributeIterator.makeAttributeNode(this.element, this.attributes, this.index);
            ++this.index;
        } while (!this.nodeTest.matches(this.next));
    }

    public SequenceIterator getAnother() {
        return new AttributeIterator(this.element, this.attributes, this.nodeTest);
    }

    public int getProperties() {
        return 4;
    }

    private static FleetingNode makeAttributeNode(FleetingElementNode element, AttributeCollection attributes, int index) {
        FleetingNode attr = new FleetingNode();
        attr.setParent(element);
        attr.setNodeKind(2);
        attr.setNameCode(attributes.getNameCode(index));
        attr.setTypeAnnotation(attributes.getTypeAnnotation(index));
        attr.setStringValue(attributes.getValue(index));
        return attr;
    }
}

