/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.stream.feed;

import com.saxonica.stream.feed.Feed;
import com.saxonica.stream.feed.ItemFeed;
import java.util.Stack;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.StringJoin;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringJoinFeed
extends ItemFeed {
    private FastStringBuffer buffer = null;
    private CharSequence sep = null;

    public StringJoinFeed(Expression expr, Feed result, Stack<XPathContext> contextStack) {
        super(expr, result, contextStack);
    }

    @Override
    public void append(Item item) throws XPathException {
        if (this.buffer == null) {
            this.buffer = new FastStringBuffer(100);
            this.buffer.append(item.getStringValueCS());
        } else {
            if (this.sep == null) {
                Expression sepExpr = ((StringJoin)this.getExpression()).getArguments()[1];
                this.sep = sepExpr.evaluateItem(this.getContext()).getStringValueCS();
            }
            this.buffer.append(this.sep);
            this.buffer.append(item.getStringValueCS());
        }
    }

    @Override
    public void close() throws XPathException {
        if (this.buffer == null) {
            this.getResult().append(StringValue.EMPTY_STRING);
        } else {
            this.getResult().append(new StringValue(this.buffer));
        }
        this.getResult().close();
    }
}

