/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.stream.feed;

import com.saxonica.stream.feed.Feed;
import com.saxonica.stream.feed.ItemFeed;
import java.util.Stack;
import net.sf.saxon.event.SequenceWriter;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.instruct.SimpleNodeConstructor;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Orphan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleNodeConstructorFeed
extends ItemFeed {
    private FastStringBuffer buffer = new FastStringBuffer(100);

    public SimpleNodeConstructorFeed(Expression expr, Feed result, Stack<XPathContext> contextStack) {
        super(expr, result, contextStack);
    }

    @Override
    public void open() throws XPathException {
        super.open();
        XPathContextMinor context = this.getContextStack().peek().newMinorContext();
        this.getContextStack().push(context);
        SequenceWriter out2 = new SequenceWriter(){

            public void write(Item item) throws XPathException {
                SimpleNodeConstructorFeed.this.append(item);
            }
        };
        out2.setPipelineConfiguration(this.getPipelineConfiguration());
        context.setReceiver(out2);
    }

    @Override
    public void close() throws XPathException {
        this.getContextStack().pop();
        SimpleNodeConstructor constructor = (SimpleNodeConstructor)this.getExpression();
        int nameCode = constructor.evaluateNameCode(this.getContext());
        Orphan node = new Orphan(this.getContext().getConfiguration());
        node.setNodeKind((short)constructor.getItemType(null).getPrimitiveType());
        node.setNameCode(nameCode);
        node.setStringValue(this.buffer);
        this.getResult().append(node);
        super.close();
    }

    @Override
    public void append(Item item) throws XPathException {
        this.buffer.append(item.getStringValueCS());
    }
}

