/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.stream.feed;

import com.saxonica.stream.feed.Feed;
import com.saxonica.stream.feed.ItemFeed;
import java.util.Stack;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.DescendingComparer;
import net.sf.saxon.functions.Minimax;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.StringToDouble;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.UntypedAtomicValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinimaxFeed
extends ItemFeed {
    private AtomicValue min = null;
    private AtomicComparer atomicComparer;
    private boolean foundDouble = false;
    private boolean foundFloat = false;
    private boolean foundNaN = false;
    private AtomicType lowestCommonSuperType;
    private boolean ignoreNaN;

    public MinimaxFeed(Expression expr, Feed result, Stack<XPathContext> contextStack) {
        super(expr, result, contextStack);
    }

    @Override
    public void open() throws XPathException {
        Minimax function = (Minimax)this.getExpression();
        this.atomicComparer = function.getAtomicComparer(this.getContext());
        if (function.getDetails().opcode == 3) {
            this.atomicComparer = new DescendingComparer(this.atomicComparer);
        }
        this.ignoreNaN = function.isIgnoreNaN();
        this.getResult().open();
    }

    @Override
    public void append(Item item) throws XPathException {
        AtomicValue value = (AtomicValue)item;
        TypeHierarchy th = this.getContext().getConfiguration().getTypeHierarchy();
        if (value instanceof UntypedAtomicValue) {
            try {
                StringToDouble converter = this.getContext().getConfiguration().getConversionRules().getStringToDoubleConverter();
                value = new DoubleValue(converter.stringToNumber(this.min.getStringValueCS()));
                this.foundDouble = true;
            }
            catch (NumberFormatException e) {
                XPathException de = new XPathException("Failure converting " + Err.wrap(this.min.getStringValueCS()) + " to a number");
                de.setErrorCode("FORG0001");
                de.setXPathContext(this.getContext());
                throw de;
            }
        } else if (value instanceof DoubleValue) {
            this.foundDouble = true;
        } else if (value instanceof FloatValue) {
            this.foundFloat = true;
        }
        if (value.isNaN()) {
            if (this.ignoreNaN) {
                return;
            }
            this.foundNaN = true;
        } else if (!value.getPrimitiveType().isOrdered()) {
            XPathException de = new XPathException("Type " + value.getPrimitiveType() + " is not an ordered type");
            de.setErrorCode("FORG0006");
            de.setIsTypeError(true);
            de.setXPathContext(this.getContext());
            throw de;
        }
        if (this.min == null) {
            this.min = value;
            this.lowestCommonSuperType = value.getTypeLabel();
        } else {
            this.lowestCommonSuperType = (AtomicType)Type.getCommonSuperType(this.lowestCommonSuperType, value.getTypeLabel(), th);
            try {
                if (this.atomicComparer.compareAtomicValues(value, this.min) < 0) {
                    this.min = value;
                }
            }
            catch (ClassCastException err) {
                XPathException de = new XPathException("Cannot compare " + this.min.getItemType(th) + " with " + value.getItemType(th));
                de.setErrorCode("FORG0006");
                de.setIsTypeError(true);
                de.setXPathContext(this.getContext());
                throw de;
            }
        }
    }

    @Override
    public void close() throws XPathException {
        if (this.min == null) {
            this.min = DoubleValue.NaN;
        } else {
            if (this.foundNaN) {
                this.min = FloatValue.NaN;
            }
            ConversionRules rules = this.getContext().getConfiguration().getConversionRules();
            if (this.foundDouble) {
                if (!(this.min instanceof DoubleValue)) {
                    this.min = this.min.convert(BuiltInAtomicType.DOUBLE, true, rules).asAtomic();
                }
            } else if (this.foundFloat && !(this.min instanceof FloatValue)) {
                this.min = this.min.convert(BuiltInAtomicType.FLOAT, true, rules).asAtomic();
            }
            this.min = this.min.convert(this.lowestCommonSuperType, false, rules).asAtomic();
        }
        this.getResult().append(this.min);
        this.getResult().close();
    }
}

