/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.stream.feed;

import com.saxonica.stream.feed.Feed;
import com.saxonica.stream.feed.ItemFeed;
import java.util.HashSet;
import java.util.Stack;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.GeneralComparison;
import net.sf.saxon.expr.Token;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralComparisonFeed
extends ItemFeed {
    private StringCollator collator = ((GeneralComparison)this.getExpression()).getAtomicComparer().getCollator();
    private HashSet<Object> lookup = null;
    int operator = ((GeneralComparison)this.getExpression()).getSingletonOperator();
    boolean done = false;
    private Expression pullOperand;

    public GeneralComparisonFeed(Expression expr, int pushedArg, Feed result, Stack<XPathContext> contextStack) {
        super(expr, result, contextStack);
        if (pushedArg == 1) {
            this.operator = Token.inverse(this.operator);
        }
        this.pullOperand = ((GeneralComparison)this.getExpression()).getOperands()[1 - pushedArg];
    }

    @Override
    public void open() throws XPathException {
        this.getResult().open();
        this.done = false;
        this.lookup = null;
    }

    @Override
    public void append(Item item) throws XPathException {
        block9: {
            Object k1;
            block11: {
                block10: {
                    if (this.done) break block9;
                    XPathContext context = this.getContext();
                    boolean ordered = this.operator != 50 && this.operator != 51;
                    AtomicValue next = (AtomicValue)item;
                    k1 = next.getXPathComparable(ordered, this.collator, context);
                    if (this.lookup == null) {
                        AtomicValue atomicValue;
                        this.lookup = new HashSet(40);
                        SequenceIterator comparand = this.pullOperand.iterate(context);
                        while ((atomicValue = (AtomicValue)comparand.next()) != null) {
                            this.lookup.add(atomicValue.getXPathComparable(ordered, this.collator, context));
                        }
                    }
                    if (this.operator != 50) break block10;
                    if (!this.lookup.contains(k1)) break block9;
                    this.done = true;
                    this.getResult().append(BooleanValue.TRUE);
                    this.lookup = null;
                    break block9;
                }
                if (this.operator != 51) break block11;
                if (this.lookup.size() <= 1 && this.lookup.contains(k1)) break block9;
                this.done = true;
                this.getResult().append(BooleanValue.TRUE);
                this.lookup = null;
                break block9;
            }
            for (Comparable comparable : this.lookup) {
                boolean result;
                int c = ((Comparable)k1).compareTo(comparable);
                switch (this.operator) {
                    case 55: {
                        result = c <= 0;
                        break;
                    }
                    case 53: {
                        result = c < 0;
                        break;
                    }
                    case 54: {
                        result = c >= 0;
                        break;
                    }
                    case 52: {
                        result = c > 0;
                        break;
                    }
                    default: {
                        result = false;
                    }
                }
                if (!result) continue;
                this.done = true;
                this.getResult().append(BooleanValue.TRUE);
                this.lookup = null;
                break;
            }
        }
    }

    @Override
    public void close() throws XPathException {
        if (!this.done) {
            this.getResult().append(BooleanValue.FALSE);
            this.lookup = null;
        }
        super.close();
    }
}

