/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.stream.feed;

import com.saxonica.stream.feed.Feed;
import com.saxonica.stream.feed.ItemFeed;
import java.util.Stack;
import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Cardinality;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CardinalityCheckingFeed
extends ItemFeed {
    private int count = 0;
    private int requiredCardinality;

    public CardinalityCheckingFeed(Expression checker, Feed result, Stack<XPathContext> contextStack) {
        super(checker, result, contextStack);
        this.requiredCardinality = ((CardinalityChecker)checker).getRequiredCardinality();
    }

    @Override
    public void append(Item item) throws XPathException {
        if (this.count <= 2) {
            ++this.count;
            if (this.count == 1 && this.requiredCardinality == 8192) {
                RoleLocator role = ((CardinalityChecker)this.getExpression()).getRoleLocator();
                this.typeError("The only value allowed for the " + role.getMessage() + " is an empty sequence", role.getErrorCode());
            } else if (this.count == 2 && !Cardinality.allowsMany(this.requiredCardinality)) {
                RoleLocator role = ((CardinalityChecker)this.getExpression()).getRoleLocator();
                this.typeError("A sequence of more than one item is not allowed as the " + role.getMessage(), role.getErrorCode());
            }
        }
        this.getResult().append(item);
    }

    @Override
    public void close() throws XPathException {
        if (this.count == 0 && !Cardinality.allowsZero(this.requiredCardinality)) {
            RoleLocator role = ((CardinalityChecker)this.getExpression()).getRoleLocator();
            this.typeError("An empty sequence is not allowed as the " + role.getMessage(), role.getErrorCode());
        }
        this.getResult().close();
    }

    private void typeError(String message, String errorCode) throws XPathException {
        XPathException e = new XPathException(message, this.getExpression());
        e.setIsTypeError(true);
        e.setErrorCode(errorCode);
        throw e;
    }
}

