/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.stream.feed;

import com.saxonica.stream.feed.Feed;
import com.saxonica.stream.feed.ItemFeed;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceExtent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferingFeed
extends ItemFeed {
    private List<Item> inputValue = new ArrayList<Item>(4);

    public BufferingFeed(Expression expr, Feed result, Stack<XPathContext> contextStack) {
        super(expr, result, contextStack);
    }

    @Override
    public void append(Item item) throws XPathException {
        this.inputValue.add(item);
        if (this.inputValue.size() == 2) {
            System.err.println("**** BufferingFeed using buffer size > 1 {" + this.getExpression().toString() + "}");
        }
    }

    @Override
    public void close() throws XPathException {
        Item item;
        this.getContext().getStackFrame().pushDynamicValue(SequenceExtent.makeSequenceExtent(this.inputValue));
        SequenceIterator iter = this.getExpression().iterate(this.getContext());
        while ((item = iter.next()) != null) {
            this.getResult().append(item);
        }
        this.getResult().close();
    }
}

