/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.stream.feed;

import com.saxonica.stream.feed.Feed;
import com.saxonica.stream.feed.ItemFeed;
import java.util.Stack;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockFeed
extends ItemFeed {
    private int streamedArgument;

    public BlockFeed(Expression block, Feed result, Stack<XPathContext> contextStack, int arg) throws XPathException {
        super(block, result, contextStack);
        this.streamedArgument = arg;
    }

    @Override
    public void open() throws XPathException {
        Feed result = this.getResult();
        result.open();
        Expression[] children = ((Block)this.getExpression()).getChildren();
        for (int i = 0; i < this.streamedArgument; ++i) {
            Item item;
            SequenceIterator iter = children[i].iterate(this.getContext());
            while ((item = iter.next()) != null) {
                result.append(item);
            }
        }
    }

    @Override
    public void append(Item item) throws XPathException {
        this.getResult().append(item);
    }

    @Override
    public void close() throws XPathException {
        Feed result = this.getResult();
        Expression[] children = ((Block)this.getExpression()).getChildren();
        for (int i = this.streamedArgument + 1; i < children.length; ++i) {
            Item item;
            SequenceIterator iter = children[i].iterate(this.getContext());
            while ((item = iter.next()) != null) {
                result.append(item);
            }
        }
        result.close();
    }
}

