/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.stream.adjunct;

import com.saxonica.stream.adjunct.AdjunctClassMapper;
import com.saxonica.stream.feed.BufferingFeed;
import com.saxonica.stream.feed.Feed;
import com.saxonica.stream.feed.FeedMaker;
import com.saxonica.stream.feed.ItemFeed;
import com.saxonica.stream.feed.ItemFeedMaker;
import com.saxonica.stream.watch.WatchMaker;
import com.saxonica.stream.watch.WatchManager;
import java.util.List;
import java.util.Stack;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.SuppliedParameterReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.trans.XPathException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamingAdjunct {
    private Configuration config;

    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public WatchMaker getWatchMaker(Expression expression, List<String> reasonsForFailure) throws XPathException {
        return null;
    }

    public FeedMaker getFeedMaker(Expression expression, int arg) throws XPathException {
        Expression exp2;
        try {
            exp2 = expression.copy();
        }
        catch (UnsupportedOperationException e) {
            e.printStackTrace();
            throw new XPathException("Streaming is not supported for expression " + e.getMessage() + " in " + expression.getExpressionName() + " (no copy operation)", expression);
        }
        ExpressionTool.copyLocationInfo(expression, exp2);
        ExpressionTool.replaceNthSubexpression(exp2, arg, new SuppliedParameterReference(-1));
        return new ItemFeedMaker(){

            @Override
            public ItemFeed makeItemFeed(WatchManager watchManager, Feed out, Stack<XPathContext> contextStack) throws XPathException {
                return new BufferingFeed(exp2, out, contextStack);
            }
        };
    }

    public static StreamingAdjunct makeStreamingAdjunct(Expression exp, Configuration config) {
        StreamingAdjunct ec = AdjunctClassMapper.map(exp);
        if (ec == null) {
            ec = new StreamingAdjunct();
        }
        ec.setConfiguration(config);
        return ec;
    }
}

