/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.stream.adjunct;

import com.saxonica.stream.ExpressionInverter;
import com.saxonica.stream.InvertedExpression;
import com.saxonica.stream.StreamingRoute;
import com.saxonica.stream.adjunct.StreamingAdjunct;
import com.saxonica.stream.feed.EventFeed;
import com.saxonica.stream.feed.EventFeedMaker;
import com.saxonica.stream.feed.Feed;
import com.saxonica.stream.watch.Watch;
import com.saxonica.stream.watch.WatchMaker;
import com.saxonica.stream.watch.WatchManager;
import java.util.List;
import java.util.Stack;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceExtent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LetExpressionAdjunct
extends StreamingAdjunct {
    @Override
    public WatchMaker getWatchMaker(final Expression expression, List<String> reasonsForFailure) throws XPathException {
        final Expression select = ((LetExpression)expression).getSequence();
        final Expression action = ((LetExpression)expression).getAction();
        if (ExpressionInverter.consumesStream(select)) {
            ExpressionInverter ei = new ExpressionInverter(this.getConfiguration());
            InvertedExpression ie = ei.invertExpression(select);
            final StreamingRoute route = ie.getStreamingRoute().copy();
            StreamingRoute.PushAction letAction = new StreamingRoute.PushAction();
            letAction.feedMaker = new EventFeedMaker(){

                @Override
                public Feed makeEventFeed(final WatchManager watchManager, Feed out, final Stack<XPathContext> contextStack) throws XPathException {
                    return new EventFeed(expression, out, contextStack){
                        private SequenceOutputter writer;

                        public void open() throws XPathException {
                            super.open();
                            this.writer = new SequenceOutputter();
                            this.writer.setPipelineConfiguration(watchManager.getPipelineConfiguration());
                            XPathContextMinor c2 = ((XPathContext)contextStack.peek()).newMinorContext();
                            c2.setReceiver(this.writer);
                            contextStack.push(c2);
                        }

                        public void close() throws XPathException {
                            contextStack.pop();
                            ValueRepresentation value = this.writer.getSequence();
                            this.getContext().setLocalVariable(((LetExpression)expression).getLocalSlotNumber(), value);
                            action.process(this.getContext());
                            super.close();
                        }
                    };
                }
            };
            letAction.pushMethod = 32;
            letAction.streamingChildSequence = 0;
            route.prepend(letAction);
            return new WatchMaker(){

                @Override
                public Watch makeWatch(WatchManager watchManager, Feed out, Stack<XPathContext> contextStack) throws XPathException {
                    return route.getWatch(watchManager, out, contextStack);
                }
            };
        }
        ExpressionInverter ei = new ExpressionInverter(this.getConfiguration());
        InvertedExpression ie = ei.invertExpression(action);
        final StreamingRoute route = ie.getStreamingRoute().copy();
        StreamingRoute.PushAction letAction = new StreamingRoute.PushAction();
        letAction.feedMaker = new EventFeedMaker(){

            @Override
            public Feed makeEventFeed(WatchManager watchManager, Feed out, Stack<XPathContext> contextStack) throws XPathException {
                return new EventFeed(expression, out, contextStack){

                    public void open() throws XPathException {
                        ValueRepresentation value = SequenceExtent.makeSequenceExtent(select.iterate(this.getContext()));
                        this.getContext().setLocalVariable(((LetExpression)expression).getLocalSlotNumber(), value);
                        super.open();
                    }
                };
            }
        };
        letAction.pushMethod = 32;
        letAction.streamingChildSequence = 0;
        route.prepend(letAction);
        return new WatchMaker(){

            @Override
            public Watch makeWatch(WatchManager watchManager, Feed out, Stack<XPathContext> contextStack) throws XPathException {
                return route.getWatch(watchManager, out, contextStack);
            }
        };
    }
}

