/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.stream.adjunct;

import com.saxonica.expr.IterateInstr;
import com.saxonica.expr.ee.OptimizerEE;
import com.saxonica.stream.ExpressionInverter;
import com.saxonica.stream.InvertedExpression;
import com.saxonica.stream.adjunct.StreamingAdjunct;
import com.saxonica.stream.feed.Feed;
import com.saxonica.stream.watch.EventPushingWatch;
import com.saxonica.stream.watch.IterateWatch;
import com.saxonica.stream.watch.WatchMaker;
import com.saxonica.stream.watch.WatchManager;
import java.util.List;
import java.util.Stack;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IterateAdjunct
extends StreamingAdjunct {
    @Override
    public WatchMaker getWatchMaker(final Expression expression, List<String> reasonsForFailure) {
        Expression select = ((IterateInstr)expression).getSelectExpression();
        Expression action = ((IterateInstr)expression).getActionExpression();
        Configuration config = this.getConfiguration();
        final Pattern selection = ((OptimizerEE)config.getOptimizer()).makeStreamingPattern(select, reasonsForFailure);
        try {
            ExpressionInverter inverter = new ExpressionInverter(config);
            final InvertedExpression body = inverter.invertExpression(action);
            if (selection != null) {
                return new WatchMaker(){

                    @Override
                    public EventPushingWatch makeWatch(WatchManager watchManager, Feed out, Stack<XPathContext> contextStack) throws XPathException {
                        SequenceReceiver result = contextStack.peek().getReceiver();
                        IterateWatch watch = new IterateWatch(expression, result, contextStack);
                        watch.setSelection(selection);
                        watch.setParentExpressionFeed(out);
                        watch.setPipelineConfiguration(result.getPipelineConfiguration());
                        watch.setWatchManager(watchManager);
                        watch.setBody(body);
                        return watch;
                    }
                };
            }
        }
        catch (XPathException err) {
            reasonsForFailure.add(err.getMessage());
            return null;
        }
        return null;
    }
}

