/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.stream.adjunct;

import com.saxonica.stream.adjunct.StreamingAdjunct;
import com.saxonica.stream.feed.Feed;
import com.saxonica.stream.feed.FeedMaker;
import com.saxonica.stream.feed.FilterExpressionFeed;
import com.saxonica.stream.feed.ItemFeed;
import com.saxonica.stream.feed.ItemFeedMaker;
import com.saxonica.stream.watch.WatchManager;
import java.util.Stack;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.trans.XPathException;

public class FilterExpressionAdjunct
extends StreamingAdjunct {
    public FeedMaker getFeedMaker(final Expression expr, int arg) throws XPathException {
        FilterExpression f = (FilterExpression)expr;
        if ((f.getControlledExpression().getDependencies() & 8) != 0) {
            XPathException err = new XPathException("Cannot use last() in a predicate applied to the streamed input");
            err.setErrorCode("SXST0067");
            err.setLocator(f);
            throw err;
        }
        if (ExpressionTool.selectsSideways(f.getControlledExpression())) {
            XPathException err = new XPathException("Cannot use preceding/following axes in a predicate applied to the streamed input");
            err.setErrorCode("SXST0067");
            err.setLocator(f);
            throw err;
        }
        return new ItemFeedMaker(){

            @Override
            public ItemFeed makeItemFeed(WatchManager watchManager, Feed out, Stack<XPathContext> contextStack) throws XPathException {
                return new FilterExpressionFeed(expr, out, contextStack);
            }
        };
    }
}

