/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.stream.adjunct;

import com.saxonica.stream.ExpressionInverter;
import com.saxonica.stream.adjunct.StreamingAdjunct;
import com.saxonica.stream.feed.EventFeed;
import com.saxonica.stream.feed.EventFeedMaker;
import com.saxonica.stream.feed.Feed;
import com.saxonica.stream.feed.FeedMaker;
import com.saxonica.stream.watch.WatchManager;
import java.util.Stack;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;

public class BlockAdjunct
extends StreamingAdjunct {
    public FeedMaker getFeedMaker(final Expression expression, int arg) throws XPathException {
        Block block = (Block)expression;
        Expression[] children = block.getChildren();
        int index = -1;
        for (int i = 0; i < children.length; ++i) {
            if (!ExpressionInverter.consumesStream(children[i])) continue;
            if (index == -1) {
                index = i;
                continue;
            }
            XPathException err = new XPathException("Sequence expression reads the streamed input more than once");
            err.setErrorCode("SXST0060");
            err.setLocator(expression);
            throw err;
        }
        final int descender = index;
        return new EventFeedMaker(){

            @Override
            public EventFeed makeEventFeed(WatchManager watchManager, Feed out, Stack<XPathContext> contextStack) throws XPathException {
                return new EventFeed(expression, out, contextStack){

                    public void open() throws XPathException {
                        super.open();
                        Expression[] children = ((Block)this.getExpression()).getChildren();
                        for (int i = 0; i < descender; ++i) {
                            Item item;
                            SequenceIterator iter = children[i].iterate(this.getContext());
                            while ((item = iter.next()) != null) {
                                this.getResult().append(item);
                            }
                        }
                    }

                    public void append(Item item) throws XPathException {
                        this.getResult().append(item);
                    }

                    public void close() throws XPathException {
                        Expression[] children = ((Block)this.getExpression()).getChildren();
                        for (int i = descender + 1; i < children.length; ++i) {
                            Item item;
                            SequenceIterator iter = children[i].iterate(this.getContext());
                            while ((item = iter.next()) != null) {
                                this.getResult().append(item);
                            }
                        }
                        super.close();
                    }
                };
            }
        };
    }
}

