/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.stream;

import com.saxonica.stream.Conduit;
import com.saxonica.stream.SequenceExchanger;
import com.saxonica.stream.SequenceFilter;
import com.saxonica.stream.SequenceTransmitter;
import com.saxonica.stream.feed.DecomposingFeed;
import com.saxonica.stream.watch.CopyOfWatch;
import com.saxonica.stream.watch.WatchManager;
import java.util.Iterator;
import java.util.Stack;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.SequenceWriter;
import net.sf.saxon.event.Sink;
import net.sf.saxon.event.StartTagBuffer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.PairIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.functions.Doc;
import net.sf.saxon.functions.DocumentFn;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.PatternSponsor;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamingCopy
extends Expression {
    private Expression documentExp;
    private Pattern selectPattern;
    private Expression filter;

    public StreamingCopy(Expression documentExp, Pattern selectPattern, Expression filter) {
        this.documentExp = documentExp;
        this.selectPattern = selectPattern;
        this.filter = filter;
    }

    @Override
    protected int computeCardinality() {
        return 57344;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.documentExp = visitor.optimize(this.documentExp, contextItemType);
        visitor.optimize(new PatternSponsor(this.selectPattern), this.documentExp.getItemType(visitor.getConfiguration().getTypeHierarchy()));
        this.filter = visitor.optimize(this.filter, this.selectPattern.getNodeTest());
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.documentExp = visitor.typeCheck(this.documentExp, contextItemType);
        visitor.typeCheck(new PatternSponsor(this.selectPattern), this.documentExp.getItemType(visitor.getConfiguration().getTypeHierarchy()));
        this.filter = visitor.typeCheck(this.filter, this.selectPattern.getNodeTest());
        return this;
    }

    @Override
    public Expression copy() {
        throw new UnsupportedOperationException("StreamingCopy.copy()");
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        Expression exp = offer.accept(parent, this);
        if (exp != null) {
            return exp;
        }
        if (offer.action == 12 || offer.action == 14) {
            this.documentExp = this.documentExp.promote(offer, this);
            this.filter = this.documentExp.promote(offer, this);
        }
        return this;
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("streamingCopy");
        out.startElement("document");
        this.documentExp.explain(out);
        out.endElement();
        out.startElement("selection");
        out.emitAttribute("select", this.selectPattern.toString());
        out.endElement();
        if (this.filter != null) {
            out.startElement("filter");
            this.filter.explain(out);
            out.endElement();
        }
        out.endElement();
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return this.selectPattern.getNodeTest();
    }

    @Override
    public int computeDependencies() {
        return this.documentExp.getDependencies() | this.filter.getDependencies() & 0xFFFFFFE1;
    }

    @Override
    public int computeSpecialProperties() {
        int prop = 131072;
        if (!Cardinality.allowsMany(this.documentExp.getCardinality())) {
            prop |= 0x800000;
        }
        return prop;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return new PairIterator(this.documentExp, this.filter);
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.documentExp == original) {
            this.documentExp = replacement;
            found = true;
        }
        if (this.filter == original) {
            this.filter = replacement;
            found = true;
        }
        return found;
    }

    @Override
    public int getImplementationMethod() {
        return 2;
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        Conduit conduit = new Conduit();
        PipelineConfiguration pipe = context.getController().makePipelineConfiguration();
        pipe.setHostLanguage(this.getContainer().getHostLanguage());
        SequenceExchanger.EvaluationThread eval = new SequenceExchanger.EvaluationThread(this, pipe, context, conduit);
        SequenceExchanger.Consumer consumer = new SequenceExchanger.Consumer(conduit, eval);
        Thread thread = new Thread(eval);
        thread.start();
        return consumer;
    }

    @Override
    public void process(XPathContext context) throws XPathException {
        SequenceReceiver out = context.getReceiver();
        PipelineConfiguration pipe = out.getPipelineConfiguration();
        if (!(out instanceof SequenceWriter)) {
            out = new SequenceTransmitter(out);
            out.setPipelineConfiguration(pipe);
        }
        if (!Literal.isConstantBoolean(this.filter, true)) {
            out = new SequenceFilter((SequenceWriter)out, context, this.filter);
        }
        StartTagBuffer stb = new StartTagBuffer();
        stb.setPipelineConfiguration(pipe);
        WatchManager wm = new WatchManager(stb, pipe.getConfiguration());
        wm.setPipelineConfiguration(pipe);
        wm.setXPathContext(context);
        wm.setUnderlyingReceiver(new Sink());
        XPathContextMajor c2 = context.newContext();
        c2.setReceiver(wm);
        Stack<XPathContext> contextStack = new Stack<XPathContext>();
        contextStack.push(c2);
        DecomposingFeed outFeed = new DecomposingFeed(out);
        CopyOfWatch watch = new CopyOfWatch(outFeed, contextStack);
        watch.setSelection(this.selectPattern);
        wm.addWatch(watch);
        watch.setAnchorNode(wm.getDocumentNode());
        stb.setUnderlyingReceiver(wm);
        if (this.documentExp instanceof Doc) {
            ((Doc)this.documentExp).sendDocument(context, stb);
        } else {
            ((DocumentFn)this.documentExp).sendDocuments(context, stb);
        }
    }
}

