/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.stream;

import com.saxonica.stream.watch.ApplyTemplatesWatch;
import com.saxonica.stream.watch.WatchManager;
import java.util.Stack;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.Sink;
import net.sf.saxon.event.StartTagBuffer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.ApplyTemplates;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.WithParam;
import net.sf.saxon.functions.Doc;
import net.sf.saxon.functions.DocumentFn;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;

public class StreamingApplyTemplates
extends ApplyTemplates {
    private Expression documentExp;
    private Pattern selectPattern;

    public StreamingApplyTemplates(ApplyTemplates apply, Expression documentExp, Pattern selectPattern) throws XPathException {
        this.documentExp = documentExp;
        this.selectPattern = selectPattern;
        this.init(apply.getSelectExpression(), apply.usesCurrentMode(), false, apply.getMode());
        this.setLocationId(apply.getLocationId());
        this.setContainer(apply.getContainer());
        this.setActualParameters(apply.getActualParams(), apply.getTunnelParams());
    }

    protected void promoteInst(PromotionOffer offer) throws XPathException {
        if (offer.action != 15) {
            this.select = this.doPromotion(this.select, offer);
        }
        WithParam.promoteParams(this, this.actualParams, offer);
        WithParam.promoteParams(this, this.tunnelParams, offer);
    }

    protected TailCall apply(XPathContext context, boolean returnTailCall) throws XPathException {
        XPathContextMajor c2 = context.newContext();
        c2.setCurrentMode(this.mode);
        PipelineConfiguration pipe = context.getController().makePipelineConfiguration();
        StartTagBuffer stb = new StartTagBuffer();
        stb.setPipelineConfiguration(pipe);
        WatchManager wm = new WatchManager(stb, pipe.getConfiguration());
        wm.setPipelineConfiguration(pipe);
        wm.setXPathContext(context);
        wm.setUnderlyingReceiver(new Sink());
        SequenceReceiver out = context.getReceiver();
        Stack<XPathContext> contextStack = new Stack<XPathContext>();
        contextStack.push(c2);
        ApplyTemplatesWatch watch = new ApplyTemplatesWatch(this, out, contextStack);
        watch.setMode(this.mode);
        watch.setWatchManager(wm);
        watch.setSelection(this.selectPattern);
        watch.computeActualParams(this.actualParams);
        watch.computeTunnelParams(this.tunnelParams);
        watch.setPipelineConfiguration(pipe);
        wm.addWatch(watch);
        watch.setAnchorNode(wm.getDocumentNode());
        stb.setUnderlyingReceiver(wm);
        if (this.documentExp instanceof Doc) {
            ((Doc)this.documentExp).sendDocument(context, stb);
        } else {
            ((DocumentFn)this.documentExp).sendDocuments(context, stb);
        }
        return null;
    }

    protected void explainStreaming(ExpressionPresenter out) {
        out.emitAttribute("streaming", "true");
    }
}

