/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.stream;

import com.saxonica.stream.InvertedExpression;
import com.saxonica.stream.StreamingPatternMaker;
import com.saxonica.stream.StreamingRoute;
import com.saxonica.stream.adjunct.StreamingAdjunct;
import com.saxonica.stream.feed.EventFeedMaker;
import com.saxonica.stream.feed.Feed;
import com.saxonica.stream.watch.CopyOfWatch;
import com.saxonica.stream.watch.NonstreamingExpressionWatch;
import com.saxonica.stream.watch.Watch;
import com.saxonica.stream.watch.WatchMaker;
import com.saxonica.stream.watch.WatchManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.ParentNodeExpression;
import net.sf.saxon.expr.PathExpression;
import net.sf.saxon.expr.PathMap;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.BaseURI;
import net.sf.saxon.functions.BooleanFn;
import net.sf.saxon.functions.Empty;
import net.sf.saxon.functions.Exists;
import net.sf.saxon.functions.NamePart;
import net.sf.saxon.functions.Nilled;
import net.sf.saxon.functions.Position;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.EmptySequence;

public class ExpressionInverter {
    private Configuration config;

    public ExpressionInverter(Configuration config) {
        this.config = config;
    }

    public InvertedExpression invertExpression(final Expression exp) throws XPathException {
        StreamingRoute route = new StreamingRoute();
        StreamingRoute.PushAction action = this.makePushAction(exp);
        if (action != null) {
            route.append(action);
            if (action.watchMaker == null) {
                this.processChildExpressions(exp, action, route);
            }
        }
        if (route.getRoute().isEmpty()) {
            action = new StreamingRoute.PushAction();
            action.watchMaker = new WatchMaker(){

                @Override
                public Watch makeWatch(WatchManager watchManager, Feed out, Stack<XPathContext> contextStack) throws XPathException {
                    NonstreamingExpressionWatch watch = new NonstreamingExpressionWatch(exp, out, contextStack);
                    watch.setNonstreamingExpression(exp);
                    watch.setSelection(new NodeTestPattern(EmptySequenceTest.getInstance()));
                    return watch;
                }
            };
            action.pushMethod = 8;
            action.expression = new Literal(EmptySequence.getInstance());
            route.append(action);
        }
        List<StreamingRoute.PushAction> r = route.getRoute();
        if (r.get((int)(r.size() - 1)).pushMethod != 8) {
            XPathException err = new XPathException("No watchable streaming selection found in expression");
            err.setLocator(exp);
            throw err;
        }
        return new InvertedExpression(exp, route);
    }

    private void processChildExpressions(Expression parent, StreamingRoute.PushAction parentAction, StreamingRoute route) throws XPathException {
        int i = 0;
        boolean foundStreamingChild = false;
        Iterator<Expression> sub = parent.iterateSubExpressions();
        while (sub.hasNext()) {
            Expression child = sub.next();
            StreamingRoute.PushAction childAction = this.makePushAction(child);
            if (childAction != null) {
                if (foundStreamingChild) {
                    XPathException err = new XPathException("Expression " + parent.getExpressionName() + " has more than one subexpression that reads descendants", "SXST0060");
                    err.setLocator(parent);
                    throw err;
                }
                route.append(childAction);
                parentAction.feedMaker = parentAction.adjunct.getFeedMaker(parentAction.expression, i);
                parentAction.streamingChildSequence = i;
                if (childAction.watchMaker == null) {
                    this.processChildExpressions(child, childAction, route);
                }
                foundStreamingChild = true;
            }
            ++i;
        }
    }

    private StreamingRoute.PushAction makePushAction(Expression exp) throws XPathException {
        if (ExpressionInverter.consumesStream(exp)) {
            StreamingRoute.PushAction action = new StreamingRoute.PushAction();
            action.expression = exp;
            action.adjunct = StreamingAdjunct.makeStreamingAdjunct(exp, this.config);
            ArrayList<String> reasonsForFailure = new ArrayList<String>(1);
            action.watchMaker = action.adjunct.getWatchMaker(exp, reasonsForFailure);
            if (action.watchMaker == null) {
                try {
                    final Pattern selection = StreamingPatternMaker.fromExpression(exp, this.config);
                    action.watchMaker = new WatchMaker(){

                        @Override
                        public Watch makeWatch(WatchManager watchManager, Feed out, Stack<XPathContext> contextStack) throws XPathException {
                            CopyOfWatch watch = new CopyOfWatch(out, contextStack);
                            watch.setSelection(selection);
                            return watch;
                        }
                    };
                    action.pushMethod = 8;
                    return action;
                }
                catch (XPathException err) {
                    if (action.feedMaker instanceof EventFeedMaker) {
                        action.pushMethod = 32;
                        exp.setEvaluationMethod(32);
                    } else {
                        action.pushMethod = 16;
                        exp.setEvaluationMethod(16);
                    }
                    return action;
                }
            }
            exp.setEvaluationMethod(8);
            action.pushMethod = 8;
            return action;
        }
        return null;
    }

    public static boolean consumesStream(Expression exp) {
        if (!ExpressionTool.dependsOnFocus(exp)) {
            return false;
        }
        if (exp instanceof Position) {
            return false;
        }
        if (exp instanceof ContextItemExpression) {
            return false;
        }
        if (exp instanceof NamePart || exp instanceof BaseURI || exp instanceof BooleanFn || exp instanceof Exists || exp instanceof Empty || exp instanceof Nilled) {
            FunctionCall fc = (FunctionCall)exp;
            if (fc.getNumberOfArguments() == 0 || fc.getArguments()[0] instanceof ContextItemExpression) {
                return false;
            }
            if (ExpressionInverter.isUpwardsExpression(fc.getArguments()[0])) {
                return false;
            }
        }
        if (exp instanceof AxisExpression && ((AxisExpression)exp).getAxis() == 2) {
            return false;
        }
        if (exp instanceof ParentNodeExpression) {
            return false;
        }
        PathMap map = new PathMap(exp);
        PathMap.PathMapRoot root = map.getContextItemRoot();
        return !root.allPathsAreWithinStreamableSnapshot();
    }

    public static boolean returnsStreamedNode(Expression exp) {
        if (!ExpressionTool.dependsOnFocus(exp)) {
            return false;
        }
        TypeHierarchy th = exp.getExecutable().getConfiguration().getTypeHierarchy();
        if (exp.getItemType(th) instanceof AtomicType) {
            return false;
        }
        PathMap map = new PathMap(exp);
        PathMap.PathMapRoot contextRoot = map.getContextItemRoot();
        if (contextRoot == null) {
            throw new IllegalStateException("No context root in path map");
        }
        return contextRoot.hasReachableReturnables();
    }

    public static boolean isUpwardsExpression(Expression exp) {
        if (exp instanceof ParentNodeExpression) {
            return true;
        }
        if (exp instanceof AxisExpression) {
            byte axis = ((AxisExpression)exp).getAxis();
            return axis == 9 || axis == 0 || axis == 1;
        }
        return exp instanceof PathExpression && ExpressionInverter.isUpwardsExpression(((PathExpression)exp).getControllingExpression()) && ExpressionInverter.isUpwardsExpression(((PathExpression)exp).getControlledExpression());
    }
}

