/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.serialize;

import com.saxonica.ptree.PTreeEmitter;
import com.saxonica.serialize.Base64BinaryEmitter;
import com.saxonica.serialize.HexBinaryEmitter;
import com.saxonica.serialize.XQueryEmitter;
import java.util.Properties;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.serialize.CharacterMapExpander;
import net.sf.saxon.serialize.Emitter;
import net.sf.saxon.trans.XPathException;

public class SerializerFactoryPE
extends SerializerFactory {
    public SerializerFactoryPE(Configuration config) {
        super(config);
    }

    protected Receiver createSaxonSerializationMethod(String method, Properties props, PipelineConfiguration pipe, CharacterMapExpander characterMapExpander, ProxyReceiver normalizer) throws XPathException {
        if (!pipe.getConfiguration().isLicensedFeature(64)) {
            throw new XPathException("Unsupported serialization method " + method + " (requires Saxon-PE license)");
        }
        if ("{http://saxon.sf.net/}xquery".equals(method)) {
            XQueryEmitter emitter = new XQueryEmitter();
            emitter.setPipelineConfiguration(pipe);
            props.setProperty("omit-xml-declaration", "yes");
            return this.createXMLSerializer(emitter, props, pipe, characterMapExpander, normalizer);
        }
        if ("{http://saxon.sf.net/}base64Binary".equals(method)) {
            Base64BinaryEmitter emitter = new Base64BinaryEmitter();
            emitter.setPipelineConfiguration(pipe);
            props.setProperty("omit-xml-declaration", "yes");
            return emitter;
        }
        if ("{http://saxon.sf.net/}hexBinary".equals(method)) {
            HexBinaryEmitter emitter = new HexBinaryEmitter();
            emitter.setPipelineConfiguration(pipe);
            props.setProperty("omit-xml-declaration", "yes");
            return emitter;
        }
        if ("{http://saxon.sf.net/}ptree".equals(method)) {
            PTreeEmitter emitter = new PTreeEmitter();
            ((Emitter)emitter).setPipelineConfiguration(pipe);
            return emitter;
        }
        XPathException err = new XPathException("Unknown serialization method " + method);
        err.setErrorCode("SXCH0004");
        throw err;
    }
}

